<?php

$errorStr = array();

define("LETTERS_OR_UNDERSCORES", 1);
define("NORMAL_CHARACTERS", 2);
define("Y_OR_N", 3);
define("NUMBERS_ONLY", 4);
define("VALIDATION_TYPE", 5);
define("MIN_OR_MAX_OR_NEW", 9);
define("W_OR_R_OR_H", 10);

function ValidateAndBuildSQL(&$processParam) {
	global $errorStr;
	//$xmlStr = '';
	//$dir = 'config/';
	//$dp = opendir($dir);

	//$query = "select * from setting";
	//if (!mysqli_query($processParam->linki, $query)) $error = mysqli_error($processParam->linki); else $error = '';
	//mysqli_query($processParam->linki, $query);
/*
	while ($xml = readdir($dp)) {
		if (preg_match('/\.xml$/', $xml)) { 
			$configXmlDoc = new DOMDocument();
			$configXmlDoc->load("{$dir}/{$xml}");
			$xmlStr = $configXmlDoc->saveXML();
			$xmlStr = mysqli_real_escape_string($processParam->linki, $xmlStr);
			$insertQuery = "insert into config values ('$xml', '{$xmlStr}', 0)";
			mysqli_query($processParam->linki, $insertQuery);
		}
	}

	closedir($dp);
	*/
	//$processParam->returnString = (strlen($error) > 0) ? 'SQL build statement returned an error: ' . $error : 'SQL build statement ran successfully'; 

$dir = 'config';
if (!($dp = opendir($dir))) die(displayErrorPage("The directory $dir cannot be found."));

$arr = array();
$arrIdx = 0;
$sqlStr = array();

while ($xml = readdir($dp)) {

	if ($xml != '.' &&
		$xml != '..' &&
		//$xml == 'ticket.xml' &&
		$xml != 'user.xml' &&
		$xml != 'menu.xml' &&
		$xml != 'role.xml' &&
		$xml != 'search.xml' &&
		$xml != 'setting.xml' &&
		$xml != 'fileExtension.xml' &&
		preg_match('/^.*\.xml$/', $xml)) {
			// load the configuration file
			$configXmlDoc = new DOMDocument();
			//try {
			if ($configXmlDoc->load("{$dir}/{$xml}")) {
				//$table = $configXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("name");
				$errorStr[$arrIdx] = "[{$xml}]" . '<br/>' . checkConfigFile($configXmlDoc, $processParam->linki);
				$sqlStr[$arrIdx] = buildSQL($configXmlDoc, $processParam->linki);

				//$label = $configXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("name");
				//$formSet = $configXmlDoc->getElementsByTagName("form");
				///////////////echo "<option value=\"{$xml}\">{$xml}</option>";
				//$arr[$arrIdx] = "<div id=\"{$xml}\" style=\"display: none\">{$xml}<br/>{$errorStr[$arrIdx]}<br/>{$sqlStr[$arrIdx]}</div>";
				$arrIdx++;
			}
			//}
			//catch (Exception $e) {
			//	$errorStr[$arrIdx] = "[{$xml}.xml] is not valid and cannot be loaded." . '<br/>';
			//}
			else {
				$errorStr[$arrIdx++] = "[{$xml}] is not valid and cannot be loaded." . '<br/>';
			//	//echo "<option value=\"{$xml}\">\"{$xml}\" is not valid and cannot be loaded</option>";
			}

	}
}

for ($i = 0; $i < $arrIdx; $i++) {
	$processParam->returnString .= $errorStr[$i] . '<br/>' . $sqlStr[$i] . '<br/>===========================================================<br/><br/>';
}
}

function checkConfigFile($configXmlDoc, $linki) {
	//global $errorStr;
	$errorStr = checkDocRoot($configXmlDoc);
	$errorStr .= checkPage($configXmlDoc);
	$errorStr .= checkForm($configXmlDoc, $linki);
	return $errorStr;
}

function checkElements($configXmlDoc, $table, $linki) {
	//global $errorStr;
	$errorStr = '';
	$elementSet = $configXmlDoc->getElementsByTagName("element");
	for ($i = 0; $i < $elementSet->length; $i++) {
		//$errorStr .= checkElement($elementSet->item($i), $table, $linki);
		$errorStr .= checkElement($i, $elementSet->item($i), $table, $linki, $configXmlDoc);
	}
	return $errorStr;
}

function checkElement($i, $element, $table, $linki, $configXmlDoc) {
	$column = $element->getAttribute("name");
	$returnStr = checkColumnAndTableExist($column, $table, $linki);
	//if (strlen($tmpStr) > 0) return $tmpStr;	
	//$sql = "select $name from $table";
	//if (! mysqli_query($linki, $sql)) return "The column [$name] does not exist in the table [$table] in the database<br/>"; 
	$type = $element->getAttribute("type");
	// if type is nothing, or empty...
	if (!$type || strlen($type) == 0) {
		return "The 'type' attribute is missing or empty/invalid for {$element->getAttribute("name")}<br/>";
	}
	$returnStr = '';
	switch ($type) {
		case 'input': $returnStr = checkInput($i+1, $configXmlDoc); break;
		case 'textarea': $returnStr = checkTextArea($i+1, $configXmlDoc); break;
		case 'checkbox': $returnStr = checkCheckbox($i+1, $configXmlDoc); break;
		case 'file': case 'url': $returnStr = checkFile($i+1, $configXmlDoc); break;
		case 'grid': $returnStr = checkGrid($i+1, $configXmlDoc, $linki); break;
		case 'radio': case 'select': $returnStr = checkRadioOrSelect($i+1, $configXmlDoc, $linki); break;
		// TODO case 'url'
	}
	return $returnStr;
}

function checkGrid($i, $configXmlDoc, $linki) {

	$xpath = new DOMXPath($configXmlDoc);
	$errorStr = validateXML($configXmlDoc, "/doc/form/element[{$i}]/@label", 2);
	//$errorStr .= '1++++++++++++++++++++++++++++++++++++++++++++++++++++++++++';
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@mandatory", Y_OR_N);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@source", 1);
	//if (strlen($tmpStr) > 0) return $tmpStr;
	$source = $xpath->evaluate("/doc/form/element[{$i}]/@source")->item(0)->value;
	//$errorStr .= " --- $source --- "; exit;
	//echo $source; exit;
	//$errorStr .= '2++++++++++++++++++++++++++++++++++++++++++++++++++++++++++';
	$errorStr .= checkColumnAndTableExist('id', $source, $linki); 
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@label", 2);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@mandatory", Y_OR_N);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@autoRowNumber", NUMBERS_ONLY);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@selectCriteria", 2);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@filterColumn", 1);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@permission", W_OR_R_OR_H);
	$fieldSet = $xpath->query("/doc/form/element[{$i}]/field");
	//echo $fieldSet->length; exit;
	for ($j = 0; $j < $fieldSet->length; $j++) {
		$field = $fieldSet->item($j)->getAttribute('name');
		$maxSize = $fieldSet->item($j)->getAttribute('maxSize');
		if (strlen($maxSize) == 0) $errorStr .= "The grid / field element for [$field] can have a 'maxSize' attribute.<br/>";
		$errorStr .= checkColumnAndTableExist($field, $source, $linki); 
	}
	//$rowSet = $xpath->query("/doc/form/element[{$i}]/row");
	//for ($j = 0; $j < $rowSet->length; $j++) {
	//	$row = $rowSet->item($j)->getAttribute('label');
	//	$errorStr .= checkColumnAndTableExist($row, $source, $linki); 
	//}
	return $errorStr;
}

function checkRadioOrSelect($i, $configXmlDoc, $linki) {
	$xpath = new DOMXPath($configXmlDoc);
	$errorStr = validateXML($configXmlDoc, "/doc/form/element[{$i}]/@label", 2);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@mandatory", Y_OR_N);
	// if there is no source value, throw error immediately
	$tmpStr = validateXML($configXmlDoc, "/doc/form/element[{$i}]/@source", 1);
	if (strlen($tmpStr) > 0) return $errorStr . $tmpStr;

	$source = $xpath->evaluate("/doc/form/element[{$i}]/@source")->item(0)->value;
	if (strpos($source, ',') < 1) {
		$tmpStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@display", 1);
		if (strlen($tmpStr) > 0) return $tmpStr;
		$display = $xpath->evaluate("/doc/form/element[{$i}]/@display")->item(0)->value;
		$errorStr .= checkColumnAndTableExist($display, $source, $linki); 
	}	
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@filterByUser", Y_OR_N);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@selectCriteria", Y_OR_N);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@keepHistory", Y_OR_N);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@showHistory", Y_OR_N);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@javascript", 1);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@permission", W_OR_R_OR_H);
	return $errorStr;
}

function checkColumnAndTableExist($display, $source, $linki) {
	//return ' Here<br/>';
	//echo "$display $source \n";
	$sql = "select $display from $source limit 1";
	if (! mysqli_query($linki, $sql)) return "The column [$display] or the table [$source] may not exist in the database<br/>"; else return '';
}

function checkFile($i, $configXmlDoc) {
	$xpath = new DOMXPath($configXmlDoc);
	//echo $xpath->query("/doc/form/element[1]/@validate")->item(0)->value; exit;
	if ($xpath->evaluate("count(/doc/form/element[{$i}][@validate='none'])") != 1) return 'A \'file\' element must have a \'validate="none"\' attribute.<br/>';
	$errorStr = validateXML($configXmlDoc, "/doc/form/element[{$i}]/@label", 2);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@mandatory", Y_OR_N);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@maxSize", NUMBERS_ONLY);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@permission", W_OR_R_OR_H);
	return $errorStr;
}

function checkCheckbox($i, $configXmlDoc) {
	$errorStr = validateXML($configXmlDoc, "/doc/form/element[{$i}]/@label", 2);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@mandatory", Y_OR_N);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@permission", W_OR_R_OR_H);
	return $errorStr;
}

function checkTextArea($i, $configXmlDoc) {
	$errorStr = validateXML($configXmlDoc, "/doc/form/element[{$i}]/@validate", VALIDATION_TYPE);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@maxSize", NUMBERS_ONLY);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@label", 2);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@mandatory", Y_OR_N);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@default", 2);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@keepHistory", Y_OR_N);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@showHistory", Y_OR_N);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@rows", NUMBERS_ONLY);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@cols", NUMBERS_ONLY);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@permission", W_OR_R_OR_H);
	return $errorStr;
}

function checkInput($i, $configXmlDoc) {
	$errorStr = validateXML($configXmlDoc, "/doc/form/element[{$i}]/@validate", VALIDATION_TYPE);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@maxSize", NUMBERS_ONLY);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@label", 2);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@mandatory", Y_OR_N);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@default", 2);
	$errorStr .= validateXML($configXmlDoc, "/doc/form/element[{$i}]/@permission", W_OR_R_OR_H);
	return $errorStr;
}

function checkDocRoot($configXmlDoc) {
	return validateXML($configXmlDoc, '/doc', 0);

}

function checkPage($configXmlDoc) {
	//global $errorStr;
	$errorStr = '';
	$errorStr .= validateXML($configXmlDoc, '/doc/page', 0);
	$errorStr .= validateXML($configXmlDoc, '/doc/page/@heading', 2);
	$errorStr .= validateXML($configXmlDoc, '/doc/page/@permission', W_OR_R_OR_H);
	return $errorStr;
}

function checkForm($configXmlDoc, $linki) {
	$xpath = new DOMXPath($configXmlDoc);
	//echo $xpath->query("/doc/form/element[1]/@validate")->item(0)->value; exit;
	if ($xpath->evaluate("count(/doc/form[@name='dummy'])") == 1 || $xpath->evaluate("count(/doc/form)") == 0) return '';
	//global $errorStr;
	$errorStr = '';
	$errorStr .= validateXML($configXmlDoc, '/doc/form', 0);
	$tmpStr = validateXML($configXmlDoc, '/doc/form/@name', 1);
	if (strlen($tmpStr) == 0) {
			$table = $xpath->query("/doc/form/@name")->item(0)->value;
			$sql = "select id from $table";
			if (! mysqli_query($linki, $sql)) $errorStr .= "The table '$table' does not exist in the database<br/>"; 
			$errorStr .= checkElements($configXmlDoc, $table, $linki);
	}
	else {
		$errorStr .= $tmpStr;
	}

	$errorStr .= validateXML($configXmlDoc, '/doc/form/@showId', Y_OR_N);
	$errorStr .= validateXML($configXmlDoc, '/doc/form/@showNavButtons', Y_OR_N);
	$errorStr .= validateXML($configXmlDoc, '/doc/form/@showSaveButton', Y_OR_N);
	$errorStr .= validateXML($configXmlDoc, '/doc/form/@showNewButton', Y_OR_N);
	$errorStr .= validateXML($configXmlDoc, '/doc/form/@showDeleteButton', Y_OR_N);
	$errorStr .= validateXML($configXmlDoc, '/doc/form/@showDuplicateButton', Y_OR_N);
	$errorStr .= validateXML($configXmlDoc, '/doc/form/@showXofXX', Y_OR_N);
	$errorStr .= validateXML($configXmlDoc, '/doc/form/@initialId', MIN_OR_MAX_OR_NEW);
	$errorStr .= validateXML($configXmlDoc, '/doc/form/@useRules', Y_OR_N);
	$errorStr .= validateXML($configXmlDoc, '/doc/form/@previewColumns', 2);
	$errorStr .= validateXML($configXmlDoc, '/doc/form/@autoPreview', Y_OR_N);
	return $errorStr;
}

function validateDB() {
}

function validateXML($doc, $xp, $v) {

	$xpath = new DOMXPath($doc);
	if ($xpath->evaluate("count({$xp})", $doc) != 1) return "[$xp] does not exist in the XML config file<br/>";
	if ($v == 0) return '';
	$dataset = $xpath->query("{$xp}/../@name");
	//$dataset = $xpath->query("/doc/page/@heading/../@permission");
	if ($dataset->item(0)) $name = $dataset->item(0)->value; else $name = '';
	//echo "$xp $name"; exit;
	$dataset = $xpath->query($xp);
	$value = $dataset->item(0)->value;

	if (strlen($value) == 0) return 'There is no value for ' . $xp . '<br/>';
	if ($v == 1) {
		if (! (preg_match('/[a-zA-Z_]\d*/', $value) && $value != 'null')) {
				return "$xp for $name must only contain letters or underscores.<br/>";
		}
	}
	elseif ($v == 2) {
		if (preg_match('/[^\n\r0-9a-zA-Z!@#$%^&*()_+-={}[\]|\\\\:;"\'<>?,.\/~` ]/', $value) && $value != 'null') {
				return "$xp for $name must only contain characters found on a normal keyboard.<br/>";
		}
	}
	elseif ($v == Y_OR_N) {
		if (preg_match('/[^yn]/', $value) && $value != 'null') {
				return "$xp for $name must only contain 'y' or 'n'.<br/>";
		}
	}
	elseif ($v == NUMBERS_ONLY) {
		if (preg_match('/[^0-9]/', $value) && $value != 'null') {
			return "$xp for $name must only contain numbers.<br/>";
		}
	}
	elseif ($v == VALIDATION_TYPE) {
		$arr = explode(',', "filename,url,email,sentence,integer,decimal,selection,character,date,tree,none");
		$found = false;
		for ($i = 0;$i < sizeof($arr); $i++) {
			//echo $arr[$i];
			if ($arr[$i] === $value) {
				$found = true;
				break;
			}
		}
		if ($found) return ''; else return "$xp for $name must be one of: filename, url, email, sentence, integer, decimal, selection, character, date, tree, none<br/>";

	}
	elseif ($v == MIN_OR_MAX_OR_NEW) {
		if ($value != 'min' && $value != 'max' && $value != 'new') {
				return "$xp for $name must only contain 'min' or 'max' or 'new'.<br/>";
		}
	}
	elseif ($v == W_OR_R_OR_H) {
		if (preg_match('/[^wrh]/', $value) && $value != 'null') {
				return "$xp for $name must only contain 'w' or 'r' or 'h'.<br/>";
		}
	}
	return '';
}

function buildSQL($doc, $linki) {
	$xpath = new DOMXPath($doc);
	$table = $xpath->evaluate("/doc/form/@name[1]")->item(0)->value;
	$colSet = $doc->getElementsByTagName("element");
	$query = "SET FOREIGN_KEY_CHECKS = 0; DROP TABLE IF EXISTS $table; ";
	//mysql_query($query) or die (mysql_error() . "[{$query}]");
	//exit;
	//$query .= "SET FOREIGN_KEY_CHECKS = 0; ";
	$query .= "CREATE TABLE $table (id int primary key auto_increment, ";
	$single = "CREATE TABLE $table (id int primary key auto_increment, ";
	$phrase = '';
	$tailPhrase = ', ';
	for ($i = 0; $i < $colSet->length; $i++) {
		$phrase = $colSet->item($i)->getAttribute("name");
		if ($colSet->item($i)->getAttribute("type") == "input" || $colSet->item($i)->getAttribute("type") == "textarea" || $colSet->item($i)->getAttribute("type") == "password" || $colSet->item($i)->getAttribute("type") == "grid") {
			if ($colSet->item($i)->getAttribute("validate") == "date") {
				$phrase .= " date";
			}
			elseif ($colSet->item($i)->getAttribute("validate") == "decimal") {
				$phrase .= " decimal(10, 2)";
			}
			elseif ($colSet->item($i)->getAttribute("type") == "grid") {
				$phrase .= " varchar(4)";
			}
			else {
				$phrase .= " varchar(" .  $colSet->item($i)->getAttribute("maxSize") . ")";
			}
			if ($colSet->item($i)->getAttribute("unique") == "y") {
				$phrase .= " unique";
			}
		}
		elseif ($colSet->item($i)->getAttribute("type") == "select" || $colSet->item($i)->getAttribute("type") == "radio" || $colSet->item($i)->getAttribute("type") == "file" || $colSet->item($i)->getAttribute("type") == "url" || $colSet->item($i)->getAttribute("type") == "checkbox" ) {
			$phrase .= " int";
			if ($colSet->item($i)->getAttribute("type") == "checkbox") {
				$phrase .= " default 0 not null";
			}
			if (($colSet->item($i)->getAttribute("type") == "select" || $colSet->item($i)->getAttribute("type") == "radio") && strpos($colSet->item($i)->getAttribute("source"), ",") == null) {
				$tailPhrase .= " index({$colSet->item($i)->getAttribute("name")}), foreign key({$colSet->item($i)->getAttribute("name")}) references {$colSet->item($i)->getAttribute("source")}(id), ";
			}
		}
		if ($i != ($colSet->length - 1)) {
			$phrase .= ', ';
		}
		//$xmlStr .= $phrase;
		$query .= $phrase;
		$single .= $phrase;
	}
	if (strlen($tailPhrase) >= 2) $tailPhrase = substr($tailPhrase, 0, strlen($tailPhrase) - 2);
	$query .= "{$tailPhrase}); SET FOREIGN_KEY_CHECKS = 1;";
	$single .= "{$tailPhrase})";

	$tableCreated = false;
	$sql = "select count(id) from $table";
	$result = mysqli_query($linki, $sql);
	if ($result) $count = mysqli_fetch_row($result)[0]; else $count = '';
	if ($count) {
		$query = "WARNING: $table exists with $count record(s).<br/>" . $query;
	}
	else {
		//mysqli_query($processParam->linki, "select 1; select 2;");
		mysqli_query($linki, "SET FOREIGN_KEY_CHECKS = 0");
		mysqli_query($linki, "DROP TABLE IF EXISTS $table");
		$tableCreated = mysqli_query($linki, $single);
		mysqli_query($linki, "SET FOREIGN_KEY_CHECKS = 1");
	}
	//mysqli_query($processParam->linki, $query);
	//echo $xmlStr . "<br/>";
	//echo $query . "<br/><br/>";
	//mysql_query($query) or die (mysql_error() . "[{$query}]");

	//$query .= "SET FOREIGN_KEY_CHECKS = 1";
	//$sql = "CREATE TABLE {$r->item(0)->value} (id int primary key auto_increment";
	//$sql .= ')';
	if (strpos($query, 'dummy') > -1) {
		return '';
	}
	elseif ($tableCreated) {
		return "The database table [$table] has been created.";
	}
	else {
		return $query;
	}
	//if ($v == 0) return '';
	//$dataset = $xpath->query($xp);
	//$value = $dataset->item(0)->value;
}

?>
