<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<!--xsl:output method="html"/-->
	<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD XHTML Basic 1.1//EN" doctype-system="http://www.w3.org/TR/xhtml-basic/xhtml-basic11.dtd"/>
	<xsl:template match="/doc">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<!--meta http-equiv="X-UA-Compatible" content="IE=9" /-->
				<!-- the above line seems to affect the incorrect login page -->
				<title>
					<xsl:value-of select="/doc/page/@title"/>
				</title>
				<script language="javascript" type="text/javascript" src="js_functions.js">
				</script>
				<style>
					body {
					/* background: url(images/NTemBackground.jpg) gray 0% 0% ; */
						background-color: black;
						text-align: center;
						font-family: arial;
						font-size: 10pt;
						font-weight: bold;
						/*border: 2px solid #000000;*/
					}

					div#main {
						margin: 0px auto;
						text-align: left;
						<xsl:if test="count(/doc/reportForm)=0 and count(/doc/customReport)=0">
							width: 1000px;
							/* border: 2px solid #000000; */
						</xsl:if>
						background-color: #eee;
						margin-top: 30px;
					}

					div#menu {
					/*background: url(images/greenVertSlice.gif) repeat-x; height: 75px;*/
					background-color: darkgreen;
					height: 70px;
					}
					input.menubutton {
						color: white;
						font-family: arial;
						font-weight: bold;
						font-size:16pt;
						background-color: #ccc;
						width:150px;
						margin: 20px 0 0 10px;
					}
					div.menuItem {
						width:160px;
						float: left;
					}
					div#logo {
						border: 10px groove #2ede64;
						/*text-align: left;*/
						width:200px;
						/*float: left;*/
						position: absolute;
					}
					div#heading {
						color: #000;
						font-family: arial;
						font-weight: bold;
						font-size:16pt;
						background-color: #ccc;
						width:150px;
						margin: 10px 0 0 10px;
						float: left;
						text-align: center;
						border: 2px solid green;
					}
					.label {
						/*background-color: #33CC33;*/
						background-color: #eff;
						width: 200px;
						float: left;
						margin: 0 10px 10px 0;
					}
					input, select, textarea, button {
						background-color: #cbf9cb;
						font-size:10pt;
						/*font-weight: bold;*/
						/*border: thick solid red;*/
					}
					.heading1 {
						font-size:12pt;
						font-weight: bold;
						font-family: arial;
						/*color: white;*/
						color: #cbf9cb;
						margin: 10px 0 0 10px;
						/*border: 2px solid green;*/
						float: left;
					}
					.labelValue {
						clear: both;
						margin-bottom: 5px;
					}
					input.switch {
						/* IE auto centres text grrr */
						border: none;
						margin: 0;
						padding: 0;
						text-align: left;
						text_decoration: underline;
					}	
					input.switch2 {
						/* IE auto centres text grrr */
						border: none;
						margin: 0;
						padding: 0;
						text-align: left;
						font-weight: bold;
					}	
					form {
						/* IE adds margin and padding to forms grrr */
						margin: 0;
						padding: 0;
					}
					.sameAsInputSwitch {
						background-color: #cbf9cb;
						font-size:10pt;
						font-family: arial;
						font-weight: normal; 
						text-align: left;
					}
					.sameAsInputSwitchButPale {
						background-color: #cbf9cb;
						font-size:10pt;
						font-family: arial;
						font-weight: normal; 
						color: #999;
						text-align: left;
					}
					.bg0 {
						border: none; 
						background-color: #eff; /* very pale blue */
					}
					.bg1 {
						border: none;
						background-color: #cbf9cb; /* pale green */
					}
					.bg2 {
						border: 2px solid green;
						background-color: #cbf9cb;
					}
					.bg3 {
						//border: 1px solid #aaa;
						background-color: #ccc;
					}
					.bg4 {
						border: 1px solid #999;
						background-color: darkgreen;
						color: white;
					}
					input.navButton {
						width: 35px;
						}
					.footer {
						background-color: #aaa; 
						height: 15px; 
					<xsl:if test="count(/doc/reportForm)=0 and count(/doc/customReport)=0">
						width: 1000px;
						/* border: 2px solid #000000; */
					</xsl:if>
					}
					#busy {
						padding: 30px;
						background-color: lightgreen;
						font-weight: bold;
						 position:absolute;
						 top:60px;
						 left:400px;
						 z-index: 900;
					}
					#navHistory {
						border: 1px solid #ccc;
						padding: 5px;
						background-color: lightyellow;
						 position: absolute;
						 top: 10px;
						 left: 10px;
						 z-index: 801;
						 overflow: auto;
						 /*height: 550px;*/
						 width: 100px;
					 }
					#preview {
						border: 1px solid #ccc;
						padding: 5px;
						background-color: lightyellow;
						 position: absolute;
						 top:25px;
						 right:10px;
						 z-index: 900;
						 overflow: auto;
						 height: 550px;
						 width: 300px;
						 font-size: 8pt;
						 white-space: nowrap;
						 text-align: left;
					 }
					 .nhButton {
					 	border: none;
						padding-right: 5px;
						margin-right: 5px;
						float: left;
						width: 90px;
					 }
					 .pvButton {
					 	border: none;
						padding-right: 5px;
						margin: 0 5px 2px 0;
						width: 20px;
						text-align: center;
					 }
					 table.grid {
						border: 1px solid green;
					 	margin: 10px 0 10px 0;
						border-collapse: collapse;
					 }
					 th {
					 	font-weight: normal;
					}
						


				</style>
			</head>
		<body>
			<div id="main">
				<div style="background-color: darkgreen; height: 23px">
					<span style="float:left; margin: 0; "><img src="./images/TLcurve.png" /></span>
					<span style="float:right; margin: 0; "><img src="./images/TRcurve.png"/></span>
				</div>
				<div style="clear: both"/>
				<div>
					<div style="margin-top: 0px; padding: 0px 0 0px 25px; color: #cbf9cb; background-color: darkgreen; font-family: arial; font-size: 16pt">WGCMA Spatial Reporting System<span style="font-size: 20px; padding: 10px 30px 10px 30px; margin: 20px; color: red; background-color: green">TEST</span></div>
					<xsl:apply-templates select="menu"/>
				</div>
				<div>
					<xsl:apply-templates select="login"/>
				</div>
				<div style="padding: 10px;">
					<div style="font-size: 12pt; margin-bottom: 10px;"> 
						<xsl:value-of select="/doc/page/@title"/>
						<xsl:if test="count(/doc/login)=0">
							<img id="busy" src="./images/clock.jpg" style="margin-left: 10px" />
						</xsl:if>
					</div>
					<xsl:if test="/doc/form/hidden[@name='filtering']">
						<div><h3 style="color:blue">Filtering on (not showing all records)</h3></div>
					</xsl:if>
					<xsl:apply-templates select="successMessages/msg"/>
					<xsl:apply-templates select="errorMessages/msg"/>
					<xsl:apply-templates select="debugMessages/msg"/>
					<xsl:apply-templates select="form|reportForm|customReport|erd"/>
					<xsl:if test="/doc/form/input[@name='search_term']">
						<xsl:choose>
							<xsl:when test="/doc/form/searchResult">
								<div style="margin-top:10px">
									<xsl:apply-templates select="/doc/form/searchResult"/>
								</div>
							</xsl:when>
							<xsl:otherwise>
								Search not started, or no results found. Type a new term, and click [Search].
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
					<xsl:apply-templates select="//hypertext"/>
					<hr/>
<xsl:if test="/doc/page[@title='Wine club meetings']">
<div>
<button onClick="writeViaAJAX(0,1);">Show messages</button> 
<div id="testingAJAX">
</div>
</div>
</xsl:if>
					<xsl:apply-templates select="switches"/>
					<hr/>
					<xsl:apply-templates select="//report"/>
					<xsl:apply-templates select="links"/>
				</div>
				<div style="background-color: darkgreen; height: 30px">
					<span class="heading1">Current user: <span style="color: lightgreen"><xsl:apply-templates select="/doc/information/info[@name='userName']"/></span></span>
				</div>
				<div style="background-color: darkgreen; height: 20px; width: 1000px">
					<span style="float:left; margin: 0"><img src="./images/BLcurve.png" /></span>
					<span style="float:right; margin: 0"><img src="./images/BRcurve.png"/></span>
				</div>
				<div style="clear: both"/>
			</div>
			<script><xsl:apply-templates select="/doc/form/script"/></script>
			<script><xsl:apply-templates select="/doc/script"/></script>
			<script><xsl:apply-templates select="/doc/reportForm/script"/></script>
			<div style="text-align: left"><xsl:apply-templates select="err|sql|warning"/></div>
		</body>
	</html>
	</xsl:template>

	<xsl:template match="erd">
		<img src="images/erd.png" />
	</xsl:template>

	<xsl:template match="customReport">
		<xsl:param name="reportId"><xsl:value-of select="@reportId"/></xsl:param>
		<form method="POST" action="pabulumba.php" name="customReport">
			<xsl:if test="/doc/customReport/table/@recordCount > 0">
				<input type="submit" value="Export all records to MS Excel" onclick="javascript: document.forms.customReport.reportAction.value='export';"/>
			</xsl:if>
			<xsl:apply-templates select="hidden"/>
			<input type="hidden" name="reportId" value="{$reportId}" />
		</form>
		<xsl:apply-templates select="table"/>
	</xsl:template>
	
	<xsl:template match="report">
		<xsl:param name="reportId"><xsl:value-of select="@reportId"/></xsl:param>
		<xsl:param name="reportTitle"><xsl:value-of select="."/></xsl:param>
		<xsl:param name="xml"><xsl:value-of select="@xml"/></xsl:param>
		<xsl:param name="xsl"><xsl:value-of select="@xsl"/></xsl:param>
		<form method="POST" action="pabulumba.php" name="customReportForm">
			<input type="submit" value="{$reportTitle} ({$reportId})" class="switch"/>
			<input type="hidden" name="xsl" value="{$xsl}" />
			<input type="hidden" name="reportId" value="{$reportId}" />
			<input type="hidden" name="action" value="customReport" />
		</form>
	</xsl:template>

	<xsl:template match="reportForm">
		<xsl:apply-templates select="debugMessages/msg"/>
		<form method="POST" action="pabulumba.php" name="reportForm">
			<input type="hidden" name="navigation" value="none|-" />
			<xsl:if test='filter=""'>
				<xsl:apply-templates select="filter" /><br/>
				<input type="submit" value="Display all records" onclick="javascript: document.forms.reportForm.reportAction.value='filter'"/>
			</xsl:if>
			<xsl:if test='not(filter="")'>
				<xsl:apply-templates select="filter" /><br/>
				<input type="submit" value="Filter results using above criteria" onclick="javascript: document.forms.reportForm.reportAction.value='filter'"/>
				<input type="button" value="Update selected records using above criteria" onclick="javascript: getBulkSelected(); document.forms.reportForm.reportAction.value='update'; var answer=confirm('Are you sure you want to update these records?'); if (answer) document.forms.reportForm.submit();"/>
			</xsl:if>
			<input type="submit" value="Export all records to MS Excel" onclick="javascript: document.forms.reportForm.reportAction.value='export'"/>
			<xsl:apply-templates select="hidden"/>
			<input type="hidden" id="bulk_selected" name="bulk_selected" />
		</form>
		<xsl:apply-templates select="table" />
		<button onclick="selectAll()">Click to select all records</button>
		<button onclick="clearAll()">Click to clear all selections</button>
	</xsl:template>

	<xsl:template match="form">
		<xsl:param name="id"><xsl:value-of select="hidden[@name='id']/@value"/></xsl:param>
		<xsl:param name="xml"><xsl:value-of select="hidden[@name='xml']/@value"/></xsl:param>
		<xsl:param name="xsl"><xsl:value-of select="hidden[@name='xsl']/@value"/></xsl:param>
		<xsl:param name="selectCriteria"><xsl:value-of select="hidden[@name='selectCriteria']/@value"/></xsl:param>
		<xsl:param name="minId"><xsl:value-of select="hidden[@name='minId']/@value"/></xsl:param>
		<xsl:param name="maxId"><xsl:value-of select="hidden[@name='maxId']/@value"/></xsl:param>
		<xsl:param name="previewColumns"><xsl:value-of select="@previewColumns"/></xsl:param>
		<xsl:param name="formName"><xsl:value-of select="/doc/form/@name"/></xsl:param>
		<xsl:param name="userId"><xsl:value-of select="/doc/information/info[@name='userId']"/></xsl:param>
		<xsl:param name="sendEmailOnSave"><xsl:value-of select="@sendEmailOnSave"/></xsl:param>
		<xsl:param name="prevValues"><xsl:value-of select="hidden[@name='prevValues']/@value"/></xsl:param>
		<form method="POST" enctype="multipart/form-data" action="pabulumba.php" name="inputForm">
			<xsl:if test="@showId='y'"><div class="labelValue"><span class="label">ID</span><xsl:value-of select="hidden[@name='id']/@value"/></div></xsl:if>
			<xsl:apply-templates select="url|file|password|input|select|textarea|radio|checkbox|table"/>
			<xsl:apply-templates select="hidden"/>
			<input type="hidden" name="navigation" value="" />
			<input type="hidden" name="sendEmailOnSave" value="{$sendEmailOnSave}" />
		</form>
		<div>
			<form method="POST" action="pabulumba.php" name="navForm">
				<input type="hidden" name="navigation" value=""/>
				<input type="hidden" name="action" value="display" />
				<input type="hidden" name="xml" value="{$xml}" />
				<input type="hidden" name="xsl" value="{$xsl}" />
				<input type="hidden" name="selectCriteria" value="{$selectCriteria}" />
				<input type="hidden" name="prevValues" value="{$prevValues}" />
				<xsl:if test="@showNavButtons='y'">
				<br/>
				<xsl:choose>
					<xsl:when test="$id=$minId or $id=0">
						<input type="button" disabled="disabled" value="&lt;&lt;" class="navButton" />
					</xsl:when>
					<xsl:otherwise>
						<input type="button" value="&lt;&lt;" class="navButton" onclick="javascript: document.forms.navForm.navigation.value = 'min|-'; document.forms.navForm.submit();" />
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="$id=$minId or $id=0">
						<input type="button" disabled="disabled" value="&lt;" class="navButton"/>
					</xsl:when>
					<xsl:otherwise>
						<input type="button" value="&lt;" class="navButton" onclick="javascript: document.forms.navForm.navigation.value = 'prev|' + {$id}; document.forms.navForm.submit();" /> 
					</xsl:otherwise>
				</xsl:choose>
				</xsl:if>
				<xsl:if test="@showSaveButton='y'">
					<xsl:if test="string-length(/doc/form/@sendEmailOnSave) > 0">
						<input type="checkbox" id="confirmEmail" name="confirmEmail" value="1" onclick="javascript: if (this.checked) document.getElementById('saveSendEmail').value='Save, and send email'; else document.getElementById('saveSendEmail').value='Save'" />Confirm sending email
					</xsl:if>
					<xsl:choose>
						<xsl:when test="/doc/page[@permission='r']">
							<input type="button" value="Save" disabled="disabled" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="not(/doc/form/input[@name='search_term'])">
									<xsl:choose>
										<xsl:when test="string-length(/doc/form/@sendEmailOnSave) > 0">
											<input type="button" id="saveSendEmail" value="Save" onclick="javascript: document.getElementById('busy').style.display = ''; document.forms.inputForm.navigation.value ='save|' + {$id}; if (this.value == 'Save') document.forms.inputForm.sendEmailOnSave.value =''; document.forms.inputForm.submit(); " />
										</xsl:when>
										<xsl:otherwise>
											<input type="button" value="Save" onclick="javascript: document.getElementById('busy').style.display = ''; document.forms.inputForm.navigation.value ='save|' + {$id}; document.forms.inputForm.submit(); " />
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<button type="button" onclick="javascript: document.getElementById('busy').style.display = ''; document.forms.inputForm.navigation.value ='save|' + {$id}; document.forms.inputForm.submit(); ">Search</button>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:if test="@showNavButtons='y'">
				<xsl:choose>
					<xsl:when test="$id=$maxId or $id=0">
						<input type="button" disabled="disabled" value="&gt;" class="navButton"/>
					</xsl:when>
					<xsl:otherwise>
						<input type="button" value="&gt;" class="navButton" onclick="javascript: document.forms.navForm.navigation.value = 'next|' + {$id}; document.forms.navForm.submit();" /> 
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="$id=$maxId or $id=0">
						<input type="button" disabled="disabled" value="&gt;&gt;" class="navButton" />
					</xsl:when>
					<xsl:otherwise>
						<input type="button" value="&gt;&gt;" class="navButton" onclick="javascript: document.forms.navForm.navigation.value = 'max|-'; document.forms.navForm.submit();" />
					</xsl:otherwise>
				</xsl:choose>
				</xsl:if>
				<xsl:if test="@showNewButton='y'">
				<xsl:choose>
					<xsl:when test="/doc/page[@permission='r'] or $id='0' or count(/doc/form/hidden[@name='filtering']) &gt; 0">
						<input type="button" value="New" disabled="disabled" />
					</xsl:when>
					<xsl:otherwise>
						<input type="button" value="New" onClick="javascript: document.forms.inputForm.action.value='new'; document.forms.inputForm.navigation.value ='new|-'; document.forms.inputForm.submit();"/>
					</xsl:otherwise>
				</xsl:choose>
				</xsl:if>
			</form>
		</div>
		<div>
			<xsl:if test="@showDeleteButton='y'">
			<xsl:choose>
				<xsl:when test="/doc/page[@permission='r'] or $id='0'">
					<input type="button" disabled="disabled" value="Delete"/>
				</xsl:when>
				<xsl:otherwise>
					<input type="button" value="Delete" onClick="javascript: var answer=confirm('Are you sure you want to delete this record?'); if (answer) {{ document.forms.inputForm.action.value='delete'; if (answer) document.forms.inputForm.navigation.value ='del|' + {$id}; document.forms.inputForm.submit(); }}"/>
				</xsl:otherwise>
			</xsl:choose>
			</xsl:if>
			<xsl:if test="@showXofXX='y'">
				<xsl:choose>
					<xsl:when test="$id='0'"> ** new ** </xsl:when> 
					<xsl:otherwise>
						&#160;<xsl:value-of select="/doc/form/hidden[@name='idPosition']/@value"/> of 
						<xsl:value-of select="/doc/form/hidden[@name='idCount']/@value"/>&#160;
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="@showDuplicateButton='y'">
				<xsl:choose>
					<xsl:when test="/doc/page[@permission='r'] or $id='0' or count(/doc/form/hidden[@name='filtering']) &gt; 0">
						<input type="button" disabled="disabled" value="Duplicate"/>
					</xsl:when>
					<xsl:otherwise>
						<input type="button" value="Duplicate" onClick="javascript: var answer=confirm('Are you sure you want to duplicate this record?'); if (answer) {{ document.forms.inputForm.action.value='duplicate'; if (answer) document.forms.inputForm.navigation.value ='dupl|' + {$id}; document.forms.inputForm.submit(); }}"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="not(/doc/form/@previewColumns='')">
				<!--input type="button" onClick="popupWindow = window.open('preview.php?form={$formName}&amp;selectCriteria=&amp;userId={$userId}&amp;previewColumns={$previewColumns}', 'popupWindow', 'alwaysRaised=yes,dependent=yes,height=400,width=1000,toolbar=no,menubar=no,scrollbars=yes,titlebar=no'); popupWindow.target = document.forms.navForm.navigation;" value="Preview"/-->
				<input type="button" id="showPreview" onClick="this.style.display='none'; document.getElementById('preview').style.display='';" value="Preview"/>
			</xsl:if>
			<!--xsl:if test="@showNavHistoryButton='y				<xsl:choose>
					<xsl:when test="/doc/page[@permission='r'] or $id='0'">
						<input type="button" disabled="disabled" value="Duplicate"/>
					</xsl:when>
					<xsl:otherwise>
						<input type="button" onClick="popupWindow = window.open('userNavigationHistory.php?userId={$userId}', 'popupWindow', 'alwaysRaised=yes,dependent=yes,height=600,width=320,toolbar=no,menubar=no,scrollbars=yes,titlebar=no'); popupWindow.xml = document.forms.navForm.xml; popupWindow.target = document.forms.navForm.navigation;" value="Navigation history"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if-->

		</div>
	</xsl:template>

	<xsl:template match="input">
		<xsl:param name="name"><xsl:value-of select="@name"/></xsl:param>
		<xsl:param name="value"><xsl:value-of select="@value"/></xsl:param>
		<xsl:param name="size"><xsl:value-of select="@size"/></xsl:param>
		<xsl:param name="permission"><xsl:value-of select="@permission"/></xsl:param>
		<xsl:param name="password"><xsl:value-of select="@password"/></xsl:param>
		<xsl:param name="javascript"><xsl:value-of select="@javascript"/></xsl:param>
		<xsl:param name="showWindow"><xsl:value-of select="@showWindow"/></xsl:param>
		<xsl:param name="calSeparator"><xsl:value-of select="@calSeparator"/></xsl:param>
		<xsl:param name="calFormat"><xsl:value-of select="@calFormat"/></xsl:param>
		<xsl:param name="calDateArr"><xsl:value-of select="@calDateArr"/></xsl:param>
		<xsl:param name="calDayNum"><xsl:value-of select="@calDayNum"/></xsl:param>
		<xsl:param name="calMonthNum"><xsl:value-of select="@calMonthNum"/></xsl:param>
		<xsl:param name="calYear"><xsl:value-of select="@calYear"/></xsl:param>
		<xsl:param name="calRange"><xsl:value-of select="@calRange"/></xsl:param>
		<xsl:param name="title"><xsl:value-of select="/doc/page/@title"/></xsl:param>
		<xsl:param name="source"><xsl:value-of select="@source"/></xsl:param>
		<xsl:param name="display"><xsl:value-of select="@display"/></xsl:param>
		<xsl:param name="inputOrReportFormParam"><xsl:value-of select="count(/doc/reportForm)"/></xsl:param>
		<!--xsl:variable name="formName">reportForm</xsl:variable-->
		<xsl:choose>			
			<xsl:when test="@name='funding' and /doc/page/@title='Quarterly Project Summary'">
				<div style="clear: both; margin-bottom: 10px">
					<strong>Financial Information</strong>
				</div>
			</xsl:when>
		</xsl:choose>			
		<xsl:if test="@showHistory='y'">
			<fieldset>
			<legend>History for <xsl:value-of select="@label"/></legend>
			<xsl:apply-templates select="history"/>
			<div class="labelValue"><span class="label"><xsl:value-of select="@label"/></span>
			<xsl:choose>
				<xsl:when test="$permission='r'"><input type="text" name="{$name}" value="{$value}" size="{$size}" readonly="readonly"/></xsl:when>
				<xsl:when test="$permission='h'"/>
				<xsl:otherwise><input type="text" name="{$name}" value="{$value}" size="{$size}" maxLength="{$size}"/></xsl:otherwise>
			</xsl:choose>
			</div>
			</fieldset>
		</xsl:if>
		<xsl:if test="not(@showHistory='y')">
			<div class="labelValue"><span class="label"><xsl:value-of select="@label"/></span>
			<xsl:choose>
				<xsl:when test="$permission='r'"><input type="text" name="{$name}" value="{$value}" size="{$size}" readonly="readonly"/></xsl:when>
				<xsl:when test="$permission='h'"/>
				<xsl:otherwise>
					<input type="text" name="{$name}" value="{$value}" size="{$size}" onchange="{$javascript}" maxLength="{$size}"/>
					<xsl:choose>

					<xsl:when test="@showWindow='tree'">
						<input type="button" onClick="popupWindow = window.open('tree6.php?source={$source}&amp;display={$display}&amp;return=value', 'popupWindow', 'alwaysRaised=yes,dependent=yes,height=560,width=540,toolbar=no,menubar=no,scrollbars=no,titlebar=no'); var inputOrReport = {$inputOrReportFormParam}; if (inputOrReport) popupWindow.target = document.reportForm.{$name}; else popupWindow.target = document.inputForm.{$name};" value="Tree"/>
					</xsl:when>
					<xsl:when test="@showWindow='calendar'">
						<input type="button" onClick="popupWindow = window.open('', 'popupWindow', 'alwaysRaised=yes,dependent=yes,height=260,width=250,toolbar=no,menubar=no,scrollbars=no,titlebar=no'); popupWindow.document.writeln(' &lt;html> &lt;head> &lt;style>.dayButtonStyle {{ width: 27px; font-weight: bold; margin: 0px 0 0px 0; padding: 0px 0px 0px 0px}} .dayNumButtonStyle {{ width: 27px; margin: 0px 0 0px 0; padding; 0px; }}&lt;/style> &lt;script> function select_item(item) {{ if ({$calFormat}==1) {{ re = /(\\d*\\/)(\\d*\\/)/; item = item.replace(re, &quot;\$2\$1&quot;); }} target.value = item; top.close(); return false; }} &lt;/script> &lt;/head> &lt;body style=\'background-color: #ccc\'> &lt;div style=\'text-align:center; width: 208px; border: 2px solid green; font-weight: bold; font-family: arial; margin-bottom: 7px;\'>&lt;span id=\'monthSpan\'>&lt;/span>, &lt;span id=\'yearSpan\'>&lt;/span>&lt;/div> &lt;input type=\'button\' onclick=\'drawCurrentMonth(document.getElementById(&quot;currentMonthOffset&quot;).value - 12)\' value=\'&amp;lt;&amp;lt;\' style=\'font-weight: bold; width: 50px\'/> &lt;input type=\'button\' onclick=\'drawCurrentMonth(document.getElementById(&quot;currentMonthOffset&quot;).value - 1)\' value=\'&amp;lt;\' style=\'font-weight: bold; width: 50px\'/> &lt;input type=\'button\' onclick=\'drawCurrentMonth(document.getElementById(&quot;currentMonthOffset&quot;).value * 1 + 1)\' value=\'&amp;gt;\' style=\'font-weight: bold; width: 50px\'/> &lt;input type=\'button\' onclick=\'drawCurrentMonth(document.getElementById(&quot;currentMonthOffset&quot;).value * 1 + 12)\' value=\'&amp;gt;&amp;gt;\' style=\'font-weight: bold; width: 50px\'/> &lt;br/> &lt;input type=\'button\' value=\'M\' class=\'dayButtonStyle\'/> &lt;input type=\'button\' value=\'T\' class=\'dayButtonStyle\'/> &lt;input type=\'button\' value=\'W\' class=\'dayButtonStyle\'/> &lt;input type=\'button\' value=\'T\' class=\'dayButtonStyle\'/> &lt;input type=\'button\' value=\'F\' class=\'dayButtonStyle\'/> &lt;input type=\'button\' value=\'S\' class=\'dayButtonStyle\'/> &lt;input type=\'button\' value=\'S\' class=\'dayButtonStyle\'/> &lt;br/> &lt;input type=\'button\' id=\'0\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'1\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'2\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'3\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'4\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'5\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'6\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/>&lt;br/> &lt;input type=\'button\' id=\'7\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'8\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'9\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'10\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'11\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'12\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'13\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/>&lt;br/> &lt;input type=\'button\' id=\'14\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'15\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'16\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'17\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'18\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'19\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'20\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/>&lt;br/> &lt;input type=\'button\' id=\'21\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'22\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'23\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'24\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'25\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'26\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'27\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/>&lt;br/> &lt;input type=\'button\' id=\'28\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'29\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'30\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'31\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'32\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'33\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'34\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/>&lt;br/> &lt;input type=\'button\' id=\'35\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'36\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'37\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'38\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'39\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'40\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'button\' id=\'41\' value=\'\' onclick=\'return select_item(this.value + &quot;{$calSeparator}&quot; + (document.getElementById(&quot;monthNumber&quot;).value * 1 + 1) + &quot;{$calSeparator}&quot; + document.getElementById(&quot;year&quot;).value)\' class=\'dayNumButtonStyle\'/> &lt;input type=\'hidden\' name=\'month\' id=\'month\' value=\'{$calMonthNum}\'/> &lt;input type=\'hidden\' name=\'year\' id=\'year\' value=\'{$calYear}\'/>&lt;br/> &lt;input type=\'hidden\' id=\'monthOffsetValue\' value=\'\'/> &lt;input type=\'hidden\' name=\'currentMonthOffset\' id=\'currentMonthOffset\' value=\'8\'/>&lt;br/> &lt;input type=\'hidden\' id=\'monthRef\'/> &lt;input type=\'hidden\' id=\'monthNumber\'/> &lt;script> monthArr = new Array(\'January\',\'February\',\'March\',\'April\',\'May\',\'June\',\'July\',\'August\',\'September\',\'October\',\'November\',\'December\');\n arr = new Array({$calDateArr});\n var originalYear = {$calYear};\n var originalMonth = {$calMonthNum};\n var rangeInYears = {$calRange};\n var dayNum = {$calDayNum};\n \n function drawCurrentMonth(n) {{\n if (n &lt; 0) n = 0;\n else if (n > rangeInYears * 12 * 2) n = rangeInYears * 12 * 2;\n document.getElementById(\'currentMonthOffset\').value = n;\n document.getElementById(\'year\').value = originalYear * 1 + Math.floor((document.getElementById(\'currentMonthOffset\').value - (rangeInYears * 12 - document.getElementById(\'month\').value + 1)) / 12);\n document.getElementById(\'yearSpan\').innerHTML = document.getElementById(\'year\').value;\n document.getElementById(\'monthOffsetValue\').value = (document.getElementById(\'currentMonthOffset\').value * 1 - rangeInYears * 12) % 12;\n document.getElementById(\'monthRef\').value = ((document.getElementById(\'monthOffsetValue\').value * 1 + document.getElementById(\'month\').value * 1) % 12) + 9;\n document.getElementById(\'monthNumber\').value = (document.getElementById(\'monthRef\').value * 1 + 2) % 12;\n document.getElementById(\'monthSpan\').innerHTML = monthArr[document.getElementById(\'monthNumber\').value];\n var dateCounter = 1;\n for (i = 0; i &lt; 42; i++) {{\n document.getElementById(i).style.display = \'\';\n document.getElementById(i).style.border=\'2px #ccc solid\';\n if (i >= arr[n * 2 + 1] &amp;&amp; dateCounter &lt;= arr[n * 2]) {{\n document.getElementById(i).value = dateCounter;\n document.getElementById(i).style.backgroundColor = \'#eee\';\n if ((n == rangeInYears * 12) &amp;&amp; (dateCounter == dayNum + 1)) {{\n document.getElementById(i).style.border=\'2px solid green\';\n }}\n dateCounter++;\n }}\n else {{\n document.getElementById(i).value = \' \';\n document.getElementById(i).style.backgroundColor = \'#ccc\'; }}\n }}\n var daysInMonth = arr[n * 2];\n var firstOfMonth = arr[n * 2 + 1];\n if (daysInMonth == 28 &amp;&amp; firstOfMonth == 0) numRowsToDraw = 4;\n else if (daysInMonth == 28) numRowsToDraw = 5;\n else if (daysInMonth == 29) numRowsToDraw = 5;\n else if (daysInMonth == 30 &amp;&amp; firstOfMonth &lt; 6) numRowsToDraw = 5;\n else if (daysInMonth == 31 &amp;&amp; firstOfMonth &lt; 5) numRowsToDraw = 5;\n else numRowsToDraw = 6;\n for (i = 41; i > 41 - ((6 - numRowsToDraw) * 7); i = i - 1) {{\n document.getElementById(i).style.display = \'none\';\n }}\n }}\n \n drawCurrentMonth(rangeInYears * 12);\n //if (window.addEventListener) {{\n //	window.addEventListener(\'load\', function() {{ alert(\'boo\'); }}, false);\n //	alert(\'javascript working...\');\n //}}\n //else {{\n //	window.attachEvent(\'onload\', function() {{ drawCurrentMonth(rangeInYears * 12 / 2); }})\n //}}\n &lt;/script> &lt;/body> &lt;/html> '); var inputOrReport = {$inputOrReportFormParam}; if (inputOrReport) popupWindow.target = document.reportForm.{$name}; else popupWindow.target = document.inputForm.{$name};" value="Calendar"/>
					</xsl:when>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
			</div>
		</xsl:if>
	</xsl:template>

	<xsl:template match="password">
		<xsl:param name="name"><xsl:value-of select="@name"/></xsl:param>
		<xsl:param name="value"><xsl:value-of select="@value"/></xsl:param>
		<xsl:param name="permission"><xsl:value-of select="@permission"/></xsl:param>
		<div class="labelValue"><span class="label"><xsl:value-of select="@label"/></span>
		<xsl:choose>
			<xsl:when test="$permission='r'"><input type="password" name="{$name}" value="{$value}" readonly="readonly"/></xsl:when>
			<xsl:when test="$permission='h'"/>
			<xsl:otherwise><input type="password" name="{$name}" value="{$value}" /></xsl:otherwise>
		</xsl:choose>
		</div>
	</xsl:template>

	<xsl:template match="textarea">
		<xsl:param name="name"><xsl:value-of select="@name"/></xsl:param>
		<xsl:param name="value"><xsl:value-of select="@value"/></xsl:param>
		<xsl:param name="rows"><xsl:value-of select="@rows"/></xsl:param>
		<xsl:param name="cols"><xsl:value-of select="@cols"/></xsl:param>
		<xsl:param name="showHistory"><xsl:value-of select="@showHistory"/></xsl:param>
		<xsl:param name="permission"><xsl:value-of select="@permission"/></xsl:param>
		<xsl:if test="@showHistory='y'">
			<fieldset>
			<legend>History for <xsl:value-of select="@label"/></legend>
			<xsl:apply-templates select="history"/>
			<div class="labelValue"><span class="label"><xsl:value-of select="@label"/></span>
			<xsl:choose>
				<xsl:when test="$permission='r'">
					<textarea rows="{$rows}" cols="{$cols}" name="{$name}" readonly="readonly"><xsl:value-of select="@value"/></textarea>
				</xsl:when>
				<xsl:when test="$permission='h'"/>
				<xsl:otherwise><textarea rows="{$rows}" cols="{$cols}" name="{$name}"><xsl:value-of select="@value"/></textarea></xsl:otherwise>
			</xsl:choose>
			</div>
			</fieldset>
		</xsl:if>
		<xsl:if test="not(@showHistory='y')">
			<div class="labelValue"><span class="label"><xsl:value-of select="@label"/></span>
			<xsl:choose>
				<xsl:when test="$permission='r'">
					<textarea rows="{$rows}" cols="{$cols}" name="{$name}" readonly="readonly"><xsl:value-of select="@value"/></textarea>
				</xsl:when>
				<xsl:otherwise><textarea rows="{$rows}" cols="{$cols}" name="{$name}"><xsl:value-of select="@value"/></textarea></xsl:otherwise>
			</xsl:choose>
			</div>
		</xsl:if>
	</xsl:template>

	<xsl:template match="file">
		<xsl:param name="name"><xsl:value-of select="@name"/></xsl:param>
		<xsl:param name="value"><xsl:value-of select="@value"/></xsl:param>
		<xsl:param name="permission"><xsl:value-of select="@permission"/></xsl:param>
		<div class="labelValue"><span class="label"><xsl:value-of select="@label"/></span>
			<input type="hidden" name="{$name}" value="{$value}"/>
			<xsl:choose>
				<xsl:when test="$permission='r'">
					<input name="uploadedFile" type="file" disabled="disabled" size="40" />
				</xsl:when>
				<xsl:otherwise>
					<input name="uploadedFile" type="file" size="40" />
				</xsl:otherwise>
			</xsl:choose>
			<div>
				<xsl:apply-templates select="fileName"/>
			</div>
		</div>
	</xsl:template>

	<xsl:template match="fileName">
		<xsl:param name="name"><xsl:value-of select="."/></xsl:param>
		<xsl:param name="path"><xsl:value-of select="@path"/></xsl:param>
		<xsl:param name="alias"><xsl:value-of select="@alias"/></xsl:param>
			<div style="margin-left: 220px">
			<input type="checkbox" style="margin-left: 10px" name='{$alias}' checked="checked" /><a href="./{$path}{$name}" target="_blank">
				<xsl:if test="not(@displayImages='n')">
					<xsl:choose>
						<xsl:when test="@displayImages='.zip'">
							<img style="margin-right:10px" height="60px" width="60px" src="./images/zip.png" />
						</xsl:when>
						<xsl:when test="@displayImages='.pdf'">
							<img style="margin-right:10px" height="60px" width="60px" src="./images/pdf.jpg" />
						</xsl:when>
						<xsl:when test="@displayImages='.xlsx'">
							<img style="margin-right:10px" height="60px" width="60px" src="./images/excel.jpg" />
						</xsl:when>
						<xsl:when test="@displayImages='.xls'">
							<img style="margin-right:10px" height="60px" width="60px" src="./images/excel.jpg" />
						</xsl:when>
						<xsl:when test="@displayImages='docx'">
							<img style="margin-right:10px" height="60px" width="60px" src="./images/word.jpg" />
						</xsl:when>
						<xsl:when test="@displayImages='.doc'">
							<img style="margin-right:10px" height="60px" width="60px" src="./images/word.jpg" />
						</xsl:when>
						<xsl:when test="@displayImages='.png'">
							<img style="margin-right:10px" height="60px" width="60px" src="./images/picture.png" />
						</xsl:when>
						<xsl:when test="@displayImages='JPEG'">
							<img style="margin-right:10px" height="60px" width="60px" src="./images/picture.png" />
						</xsl:when>
						<xsl:when test="@displayImages='jpeg'">
							<img style="margin-right:10px" height="60px" width="60px" src="./images/picture.png" />
						</xsl:when>
						<xsl:when test="@displayImages='.JPG'">
							<img style="margin-right:10px" height="60px" width="60px" src="./images/picture.png" />
						</xsl:when>
						<xsl:when test="@displayImages='.jpg'">
							<img style="margin-right:10px" height="60px" width="60px" src="./images/picture.png" />
						</xsl:when>
						<xsl:when test="@displayImages='.shp'">
							<img style="margin-right:10px" height="60px" width="60px" src="./images/shape.png" />
						</xsl:when>
						<xsl:when test="@displayImages='.SHP'">
							<img style="margin-right:10px" height="60px" width="60px" src="./images/shape.png" />
						</xsl:when>
						<xsl:when test="@displayImages='.GIF'">
							<img style="margin-right:10px" height="60px" width="60px" src="./images/picture.png" />
						</xsl:when>
						<xsl:when test="@displayImages='.gif'">
							<img style="margin-right:10px" height="60px" width="60px" src="./images/picture.png" />
						</xsl:when>
						<xsl:otherwise>
							<img style="margin-right:10px" height="60px" width="60px" src="./images/nonImageImage.png" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			<xsl:apply-templates /></a>
			</div>
	</xsl:template>

	<xsl:template match="url">
		<xsl:param name="name"><xsl:value-of select="@name"/></xsl:param>
		<xsl:param name="value"><xsl:value-of select="@value"/></xsl:param>
		<xsl:param name="size"><xsl:value-of select="@size"/></xsl:param>
		<xsl:param name="permission"><xsl:value-of select="@permission"/></xsl:param>
		<div class="labelValue"><span class="label"><xsl:value-of select="@label"/></span>
			<input type="hidden" name="{$name}" value="{$value}"/>
			<xsl:choose>
				<xsl:when test="$permission='r'">
					<input name="{$name}" type="text" disabled="disabled" size="{$size}" />
				</xsl:when>
				<xsl:otherwise>
					<input name="uploadedURL" value="{$value}" type="text" size="{$size}" />
				</xsl:otherwise>
			</xsl:choose>
			<div>
				<xsl:apply-templates select="urlName"/>
			</div>
		</div>
	</xsl:template>

	<xsl:template match="urlName">
		<xsl:param name="name"><xsl:value-of select="."/></xsl:param>
		<xsl:param name="alias"><xsl:value-of select="@alias"/></xsl:param>
			<div style="margin-left: 220px">
			<input type="checkbox" style="margin-left: 10px" name='{$alias}' checked="checked" />
				<a href="http://{$name}" target="_blank">
					<xsl:apply-templates />
				</a>
			</div>
	</xsl:template>

	<xsl:template match="select">
		<xsl:param name="name"><xsl:value-of select="@name"/></xsl:param>
		<xsl:param name="source"><xsl:value-of select="@source"/></xsl:param>
		<xsl:param name="display"><xsl:value-of select="@display"/></xsl:param>
		<xsl:param name="showWindow"><xsl:value-of select="@showWindow"/></xsl:param>
		<xsl:param name="javascript"><xsl:value-of select="@javascript"/></xsl:param>
		<xsl:param name="showHistory"><xsl:value-of select="@showHistory"/></xsl:param>
		<xsl:param name="formName"><xsl:value-of select="/doc/form/@name"/></xsl:param>
		<xsl:param name="inputOrReportFormParam"><xsl:value-of select="count(/doc/reportForm)"/></xsl:param>
		<xsl:if test="@name='provider' and /doc/page/@title='Quarterly Project Summary'">
			<div style="clear: both; margin-bottom: 10px">
				<strong>Project Managers Summary</strong>
			</div>
		</xsl:if>
		<xsl:if test="@showHistory='y'">
			<fieldset>
			<legend>History for <xsl:value-of select="@label"/></legend>
			<xsl:apply-templates select="history"/>
			<div class="labelValue"><span class="label"><xsl:value-of select="@label"/></span>
			<xsl:if test="@showSelectFilter='y'">
				<div style="float:right">
					<input type="text" id="{$name}_filter" />
					<input type="button" onclick="loadXMLDoc('{$name}', '{$name}_filter', '{$source}', '{$display}')" value="Filter" />
					<span style="font-weight: normal; font-size: 8pt">Original value: <xsl:value-of select="/doc/form/select[@name=$name]/option[@selected='selected']"/></span>
				</div>
			</xsl:if>
			<select name="{$name}" onchange="{$javascript}">
				<xsl:apply-templates select="option"/>
			</select>
			</div>
			</fieldset>
		</xsl:if>
		<xsl:if test="not(@showHistory='y')">
			<div class="labelValue"><span class="label"><xsl:value-of select="@label"/></span>
			<select name="{$name}" id="{$name}" onchange="{$javascript}">
				<xsl:apply-templates select="option"/>
			</select>
			<xsl:if test="@showWindow='tree'">
				<!--input type="button" onClick="popupWindow = window.open('tree6.php?source={$source}&amp;display={$display}', 'popupWindow', 'alwaysRaised=yes,dependent=yes,height=560,width=540,toolbar=no,menubar=no,scrollbars=no,titlebar=no'); var inputOrReport = {$inputOrReportFormParam}; if (inputOrReport) popupWindow.target = document.reportForm.{$name}; else popupWindow.target = document.inputForm.{$name};" value="Tree"/-->
				<input type="button" onClick="popupWindow = window.open('tree6.php?source={$source}&amp;display={$display}&amp;return=keyAndValue', 'popupWindow', 'alwaysRaised=yes,dependent=yes,height=560,width=540,toolbar=no,menubar=no,scrollbars=no,titlebar=no'); var inputOrReport = {$inputOrReportFormParam}; if (inputOrReport) popupWindow.target = document.reportForm.{$name}; else popupWindow.target = document.inputForm.{$name};" value="Tree"/>
			</xsl:if>
			<xsl:if test="@showSelectFilter='y'">
				<div style="float:right">
					<input type="text" id="{$name}_filter" />
					<input type="button" onclick="return loadXMLDoc('{$name}', '{$name}_filter', '{$source}', '{$display}')" value="Filter" />
					<span style="font-weight: normal; font-size: 8pt">Original value: <xsl:value-of select="/doc/form/select[@name=$name]/option[@selected='selected']"/></span>
				</div>
			</xsl:if>
			</div>
		</xsl:if>
		<div style="clear: both;"/>
	</xsl:template>

	<xsl:template match="checkbox">
		<xsl:param name="id"><xsl:value-of select="@id"/></xsl:param>
		<xsl:param name="name"><xsl:value-of select="@name"/></xsl:param>
		<xsl:param name="value"><xsl:value-of select="@value"/></xsl:param>
		<xsl:param name="javascript"><xsl:value-of select="@javascript"/></xsl:param>
		<xsl:param name="permission"><xsl:value-of select="@permission"/></xsl:param>
		<xsl:if test="@name='effluent'">
			<div style="clear: both; margin-bottom: 10px">
				<strong>Management Practices:</strong>
			</div>
		</xsl:if>
		<div class="labelValue">
			<xsl:if test="not(@name='bulk_select')">
				<span class="label"><xsl:value-of select="@label"/></span>
			</xsl:if>
		<xsl:choose>
			<xsl:when test="$permission='r'">
				<xsl:if test="@value=1"><input type="checkbox" id="{$id}" name="{$name}" value="1" checked="checked" disabled="disabled" /></xsl:if>
				<xsl:if test="not(@value=1)"><input type="checkbox" id="{$id}" name="{$name}" value="1" disabled="disabled" /></xsl:if>
			</xsl:when>
			<xsl:when test="$permission='h'"/>
			<xsl:otherwise>
				<xsl:if test="@value=1"><input type="checkbox" id="{$id}" name="{$name}" value="1" checked="checked" onchange="{$javascript}" /></xsl:if>
				<xsl:if test="not(@value=1)"><input type="checkbox" id="{$id}" name="{$name}" value="1" /></xsl:if>
			</xsl:otherwise>
		</xsl:choose>
		</div>
	</xsl:template>

	<xsl:template match="radio">
		<xsl:param name="name"><xsl:value-of select="@name"/></xsl:param>
		<xsl:param name="value"><xsl:value-of select="@value"/></xsl:param>
		<div class="labelValue"><span class="label"><xsl:value-of select="@label"/></span>
			<div style="float:left">
				<xsl:apply-templates select="radiooption"/>
			</div>
			<div style="clear: both"/>
		</div>
	</xsl:template>

	<xsl:template match="option">
				<xsl:param name="value"><xsl:value-of select="@value"/></xsl:param>
				<xsl:if test="@selected"><option value="{$value}" selected="selected"><xsl:value-of select="."/></option></xsl:if>
				<xsl:if test="not(@selected)"><option style="font-size: 10pt" value="{$value}"><xsl:value-of select="."/></option></xsl:if>
	</xsl:template>

	<xsl:template match="radiooption">
				<xsl:param name="value"><xsl:value-of select="@value"/></xsl:param>
				<xsl:param name="name"><xsl:value-of select="../@name"/></xsl:param>
				<xsl:if test="@selected">
					<input type="radio" id="{$name}{$value}" name="{$name}" value="{$value}" checked="checked" /><label for="{$name}{$value}"><xsl:apply-templates /></label><br/>
				</xsl:if>
				<xsl:if test="not(@selected)">
					<input type="radio" id="{$name}{$value}" name="{$name}" value="{$value}" /><label for="{$name}{$value}"><xsl:apply-templates /></label><br/>
				</xsl:if>
	</xsl:template>
	<xsl:template match="hidden">
		<xsl:param name="name"><xsl:value-of select="@name"/></xsl:param>
		<xsl:param name="value"><xsl:value-of select="@value"/></xsl:param>
		<input type="hidden" id="{$name}" name="{$name}" value="{$value}"/>
	</xsl:template>

        <xsl:template match="title">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="links">
		<div style="margin: 20px 0 20px 0"><xsl:apply-templates select="link"/></div>
	</xsl:template>

	<xsl:template match="link">
		<xsl:param name="value"><xsl:value-of select="@value"/></xsl:param>
		<a href="{$value}"><xsl:value-of select="@label"/></a><br/>
	</xsl:template>

	<xsl:template match="errorMessages/msg">
		<h3 style="color:red"><xsl:apply-templates/></h3>
	</xsl:template>

	<xsl:template match="successMessages/msg">
		<h3 style="color:green"><xsl:apply-templates/></h3>
	</xsl:template>

	<xsl:template match="debugMessages/msg">
		<h3 style="color:blue"><xsl:apply-templates/></h3>
	</xsl:template>

	<xsl:template match="information">
		<span style="color:green"><xsl:apply-templates/></span>
	</xsl:template>

	<xsl:template match="table">
		<table class="grid">
			<xsl:apply-templates select="tr"/>
		</table>
		<xsl:if test="@recordCount">
			<table>
				<tr>
					<td>Record count: </td>
					<td><xsl:value-of select="@recordCount" /></td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>

	<xsl:template match="tr">
		<tr>
			<xsl:apply-templates select="th|td"/>
		</tr>
	</xsl:template>

	<xsl:template match="th">
		<xsl:param name="colspan"><xsl:value-of select="@colspan"/></xsl:param>
		<th style="border:2px solid green; background-color: #cbf9cb; text-align: center; padding-right: 10px" colspan="{$colspan}">
			<xsl:apply-templates/>
		</th>
	</xsl:template>
	
	<xsl:template match="img">
		<xsl:param name="src"><xsl:value-of select="@src"/></xsl:param>
		<img src="{@src}" width="18px" />
	</xsl:template>

	<xsl:template match="br">
		<br/>
	</xsl:template>

	<xsl:template match="td">
		<xsl:param name="style"><xsl:value-of select="@style"/></xsl:param>
		<td nowrap="nowrap" class="{@style}" style="padding-right: 10px">
			<xsl:apply-templates/>
		</td>
	</xsl:template>
	
	
	<xsl:template match="inputCheckbox">
		<xsl:param name="name"><xsl:value-of select="@name"/></xsl:param>
		<xsl:param name="value"><xsl:value-of select="@value"/></xsl:param>
		<xsl:if test='@checked'><input type="checkbox" name="{$name}" value="{$value}" checked="checked" /></xsl:if>
		<xsl:if test='not(@checked)'><input type="checkbox" name="{$name}" value="{$value}" /></xsl:if>
	</xsl:template>

	<xsl:template match="inputSelect">
		<xsl:param name="name"><xsl:value-of select="@name"/></xsl:param>
		<xsl:param name="source"><xsl:value-of select="@source"/></xsl:param>
		<xsl:param name="display"><xsl:value-of select="@display"/></xsl:param>
		<xsl:param name="inputOrReportFormParam"><xsl:value-of select="count(/doc/reportForm)"/></xsl:param>
		<xsl:param name="showWindow"><xsl:value-of select="@showWindow"/></xsl:param>
		<!--select name="{$name}" onchange="{$javascript}"-->
		<select name="{$name}">
			<xsl:apply-templates select="option"/>
		</select>
		<xsl:if test="@showWindow='tree'">
			<input type="button" onClick="popupWindow = window.open('tree6.php?source={$source}&amp;display={$display}&amp;return=keyAndValue', 'popupWindow', 'alwaysRaised=yes,dependent=yes,height=560,width=540,toolbar=no,menubar=no,scrollbars=no,titlebar=no'); var inputOrReport = {$inputOrReportFormParam}; if (inputOrReport) popupWindow.target = document.reportForm.{$name}; else popupWindow.target = document.inputForm.{$name};" value="Tree"/>
		</xsl:if>
	</xsl:template>

	<xsl:template match="inputCell">
		<xsl:param name="name"><xsl:value-of select="@name"/></xsl:param>
		<xsl:param name="value"><xsl:value-of select="@value"/></xsl:param>
		<xsl:param name="size"><xsl:value-of select="@size"/></xsl:param>
		<xsl:param name="permission"><xsl:value-of select="@permission"/></xsl:param>
		<xsl:param name="password"><xsl:value-of select="@password"/></xsl:param>
		<xsl:param name="style"><xsl:value-of select="@style"/></xsl:param>
		<xsl:choose>
			<xsl:when test="$permission='r'">
				<input type="text" name="{$name}" class="{@style}" value="{$value}" size="{$size}" readonly="readonly"/>
			</xsl:when>
			<xsl:when test="$permission='h'">
				<input type="hidden" name="{$name}" class="{@style}" value="{$value}" size="{$size}" readonly="readonly"/>
			</xsl:when>
			<xsl:otherwise><input class="{@style}" type="text" name="{$name}" value="{$value}" size="{$size}" maxLength="{$size}"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="formButton">
		<xsl:param name="xml"><xsl:value-of select="@xml"/></xsl:param>
		<xsl:param name="xsl"><xsl:value-of select="@xsl"/></xsl:param>
		<xsl:param name="id"><xsl:value-of select="@id"/></xsl:param>
		<form method="POST" action="pabulumba.php" style="float: left">
			<input type="hidden" name="navigation" value="disp|{$id}" />
			<input type="hidden" name="id" value="{$id}" />
			<input type="hidden" name="xml" value="{$xml}" />
			<input type="hidden" name="xsl" value="{$xsl}" />
			<input type="hidden" name="action" value="display" />
			<!--input type="submit" value="{$id}" /-->
			<input type="submit" value="Go" />
		</form>
	</xsl:template>
	
	<xsl:template match="gridButton">
		<xsl:param name="xml"><xsl:value-of select="@xml"/></xsl:param>
		<xsl:param name="xsl"><xsl:value-of select="@xsl"/></xsl:param>
		<xsl:param name="id"><xsl:value-of select="@id"/></xsl:param>
		<!--form method="POST" action="pabulumba.php" style="float: left">
			<input type="hidden" name="navigation" value="disp|{$id}" />
			<input type="hidden" name="id" value="{$id}" />
			<input type="hidden" name="xml" value="{$xml}" />
			<input type="hidden" name="xsl" value="{$xsl}" />
			<input type="hidden" name="action" value="display" />
			<input type="submit" value="{$id}" /

				TODO which of the following values in the js are actually required?
				
				-->
				<input type="button" value="Go" onclick="javascript: document.getElementById('busy').style.display = ''; document.forms.inputForm.navigation.value ='disp|' + {$id}; document.forms.inputForm.action.value ='display'; document.forms.inputForm.xml.value = '{$xml}'; document.forms.inputForm.xsl.value = '{$xsl}'; document.forms.inputForm.submit(); " />
			<!--input type="button" value="Jmp" onclick="javascript: document.getElementById('busy').style.display = ''; document.forms.inputForm.navigation.value ='disp|' + {$id}; alert('boo'); " /-->
		<!--/form-->
	</xsl:template>
	
	<xsl:template match="menu">
		<div id="menu">
			<xsl:apply-templates select="menuItem"></xsl:apply-templates>
		</div>
	</xsl:template>
	
	<xsl:template match="hypertext">
		<xsl:apply-templates select="h|p"/>
	</xsl:template>

	<xsl:template match="h">
		<h3 style="background-color: #cbf9cb;"><xsl:apply-templates /></h3>
	</xsl:template>

	<xsl:template match="p">
		<p><xsl:apply-templates /></p>
	</xsl:template>

	
	<xsl:template match="switches">
		<div style="margin: 10px 0 0 0">
			<xsl:apply-templates select="switch" />
		</div>
	</xsl:template>
	
	<xsl:template match="switch">
		<xsl:param name="xml"><xsl:value-of select="@xml"/></xsl:param>
		<xsl:param name="navigation"><xsl:value-of select="@navigation"/></xsl:param>
		<xsl:param name="xsl"><xsl:value-of select="@xsl"/></xsl:param>
		<xsl:param name="id"><xsl:value-of select="@id"/></xsl:param>
		<xsl:param name="action"><xsl:value-of select="@action"/></xsl:param>
		<xsl:param name="selectCriteria"><xsl:value-of select="@selectCriteria"/></xsl:param>
		<xsl:param name="orderCriteria"><xsl:value-of select="@orderCriteria"/></xsl:param>
		<xsl:param name="aggregateOn"><xsl:value-of select="@aggregateOn"/></xsl:param>
		<xsl:param name="aggregateFunctions"><xsl:value-of select="@aggregateFunctions"/></xsl:param>
		<xsl:param name="value"><xsl:value-of select="."/></xsl:param>
		<xsl:param name="pageTitle"><xsl:value-of select="/doc/page/@title"/></xsl:param>
		<div>
		<form method="POST" action="pabulumba.php">
			<input type="hidden" name="navigation" value="{$navigation}" />
			<input type="hidden" name="action" value="{$action}" />
			<input type="hidden" name="id" value="{$id}" />
			<input type="hidden" name="xml" value="{$xml}" />
			<input type="hidden" name="xsl" value="{$xsl}" />
			<input type="hidden" name="selectCriteria" value="{$selectCriteria}" />
			<input type="hidden" name="orderCriteria" value="{$orderCriteria}" />
			<input type="hidden" name="aggregateOn" value="{$aggregateOn}" />
			<input type="hidden" name="aggregateFunctions" value="{$aggregateFunctions}" />
			<input type="hidden" name="title" value="{$value}" />
			<xsl:choose>
				<xsl:when test="@permission='r' and $id='0'">
					<span class="sameAsInputSwitchButPale"><xsl:value-of select="."/> (no records) </span>
				</xsl:when>
				<xsl:when test="@permission='r'">
					<span class="sameAsInputSwitchButPale"><xsl:value-of select="."/> (read only) </span>
				</xsl:when>
				<xsl:when test="@permission='h'">
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="$value='Next complete Job Details for this landholder' or $value='Next complete details of Property Plans OR' or ($value='Onground Works' and not($pageTitle='Main' or $pageTitle='Reports' or $pageTitle='Maintenance')) or $value='Complete details of Onground Works' or $value='Complete details of Property Plans' or $value='Add Parcel Details'">
							<input type="submit" class="switch2" value="{$value}" onClick="document.getElementById('busy').style.display = '';" />
						</xsl:when>
						<xsl:otherwise>
							<input type="submit" class="switch" value="{$value}" onClick="document.getElementById('busy').style.display = '';" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="@processParam1='y'">
				<input style="margin-left: 10px" type="text" size="5" name="processParam1" />
			</xsl:if>
		</form>
		</div>
	</xsl:template>
	
	<xsl:template match="err">
		<div style="color: red">
			<xsl:value-of select="."/>
		</div>
	</xsl:template>

	<xsl:template match="sql">
		<div style="color: green">
			<xsl:value-of select="."/>
		</div>
	</xsl:template>

	<xsl:template match="warning">
		<div style="color: blue">
			<xsl:value-of select="."/>
		</div>
	</xsl:template>

	<xsl:template match="menuItem">
		<xsl:param name="xml"><xsl:value-of select="@xml"/></xsl:param>
		<xsl:param name="xsl"><xsl:value-of select="@xsl"/></xsl:param>
		<xsl:param name="selectCriteria"><xsl:value-of select="@selectCriteria"/></xsl:param>
		<xsl:param name="id"><xsl:value-of select="@id"/></xsl:param>
		<xsl:param name="value"><xsl:value-of select="."/></xsl:param>
		<form method="POST" action="pabulumba.php">
		<div class="menuItem">
			<input type="hidden" name="navigation" value="none|-" />
			<input type="hidden" name="action" value="display" />
			<input type="hidden" name="id" value="{$id}" />
			<input type="hidden" name="xml" value="{$xml}" />
			<input type="hidden" name="xsl" value="{$xsl}" />
			<input type="hidden" name="selectCriteria" value="{$selectCriteria}" />
			<xsl:choose>
			<xsl:when test="@permission='w'">
				<xsl:if test="/doc/form/hidden[@name='xml']/@value=$xml or (/doc/reportForm/hidden[@name='action']='report' and $xml='reports')">
					<input type="submit" class="menubutton" style="background-color: lightgreen" value="{$value}" />
				</xsl:if>
				<xsl:if test="not(/doc/form/hidden[@name='xml']/@value=$xml or (/doc/reportForm/hidden[@name='action']='report' and $xml='reports'))">
					<input type="submit" class="menubutton" value="{$value}" onClick="document.getElementById('busy').style.display = '';" />
				</xsl:if>
			</xsl:when>
			<xsl:when test="@permission='r'">
				<input type="submit" class="menubutton" value="{$value}" disabled="disabled" />
			</xsl:when>
			</xsl:choose>
		</div>
		</form>
	</xsl:template>
	
	<xsl:template match="history">
		<xsl:param name="name"><xsl:value-of select="../@name"/></xsl:param>
		<div style="width: 40px; margin-bottom: 20px;"><img src="images/plus.png" style="float: left" onClick="javascript: document.getElementById('{$name}').style.display = '';" /><img src="images/minus.png" style="float: right" onClick="javascript: document.getElementById('{$name}').style.display = 'none';"/></div>
		<div id="{$name}" style="display: none">
			<xsl:apply-templates select="hist"/>
		</div>
	</xsl:template>

	<xsl:template match="hist">
		<p style="font-weight: normal; font-size: 8pt"><xsl:apply-templates /></p> 
	</xsl:template>

	<xsl:template match="searchResult">
		<xsl:param name="xml"><xsl:value-of select="@table"/></xsl:param>
		<xsl:param name="xsl"><xsl:value-of select="/doc/form/hidden[@name='xsl']"/></xsl:param>
		<xsl:param name="value"><xsl:value-of select="./id"/></xsl:param>
		<div>
		<xsl:apply-templates select="formButton" />
		<form method="POST" action="pabulumba.php">
			<input type="hidden" name="action" value="display" />
			<input type="hidden" name="id" value="{$value}" />
			<input type="hidden" name="xml" value="{$xml}" />
			<input type="hidden" name="xsl" value="{$xsl}" />
			<xsl:if test="$value=''">
				<div style="margin-top:10px"><font color="red">No search term was provided</font></div><br/>
			</xsl:if>
			<xsl:if test="not($value='')">
				<div style="margin-top:10px"><xsl:apply-templates select="context"/><xsl:apply-templates select="searchTerm" /></div><br/>
			</xsl:if>
		</form>
		</div>
	</xsl:template>

	<xsl:template match="context">
		<span style="color: #aaa"><xsl:apply-templates /></span> 
	</xsl:template>

	<xsl:template match="searchTerm">
		<span style="color: black; background-color: yellow"><xsl:apply-templates /></span> 
	</xsl:template>

	<xsl:template match="filter">
		<xsl:apply-templates select="select" />
		<xsl:apply-templates select="input" />
		<xsl:apply-templates select="checkbox" />
	</xsl:template>

	<xsl:template match="navHistory">
		<div id="navHistory">
			<xsl:apply-templates select="nhItem"/>
		</div> 
	</xsl:template>

	<xsl:template match="nhItem">
		<xsl:param name="id"><xsl:value-of select="@id"/></xsl:param>
		<xsl:param name="target"><xsl:value-of select="@target"/></xsl:param>
		<xsl:param name="value"><xsl:value-of select="."/></xsl:param>
		<input style="font-size: 8pt" class="nhButton" type="button" value="{$value}" onclick="goButton({$id},'{$target}');" />
		<br/>
	</xsl:template>

	<xsl:template match="preview">
		<div id="preview"><input type="button" value='X' style="font-size: 10pt; float: right; background-color: red; font-weight: bold" onclick="document.getElementById('preview').style.display='none';document.getElementById('showPreview').style.display='';" /><div style="float: left; font-size: 10pt;">Preview - <xsl:value-of select="/doc/page/@title"/></div><div style="clear: both" />
			<xsl:apply-templates select="pItem"/>
		</div> 
	</xsl:template>

	<xsl:template match="pItem">
		<xsl:param name="id"><xsl:value-of select="@id"/></xsl:param>
		<xsl:param name="target"><xsl:value-of select="../@target"/></xsl:param>
		<xsl:param name="value"><xsl:value-of select="."/></xsl:param>
		<!--input style="font-size: 8pt" class="nhButton" type="button" value="Go" onclick="javascript: document.getElementById('busy').style.display = ''; document.forms.inputForm.navigation.value ='disp|{$id}'; document.forms.inputForm.action.value ='display'; document.forms.inputForm.xml.value = '{$target}'; document.forms.inputForm.xsl.value = 'pabulumba'; document.forms.inputForm.submit(); " /> <xsl:value-of select="."/-->
		<input style="font-size: 8pt" class="pvButton" type="button" value="Go" onclick="goButton({$id},'{$target}'); " /> <xsl:value-of select="."/>
		<br/>
	</xsl:template>

	<xsl:template match="login">
		<xsl:value-of select="@msg"/>
		
		<form method="POST" action="pabulumba.php">
			<table border="0" style="margin-top:20px">
				<tr>
					<td>Username: </td><td><input name="login_username" type="text"/></td>
				</tr>
				<tr>
					<td>Password: </td><td><input name="login_password" type="password"/></td>
				</tr>
				<tr style="height: 30px">
					<td></td><td align="center"><input type="submit" value="Login"/></td>
				</tr>
			</table>
			<table>
				<tr>
					<input type="hidden" name="navigation" value="none|-" />
					<input type="hidden" name="action" value="display" />
					<input type="hidden" name="id" value="0" />
					<input type="hidden" name="xml" value="switchboard" />
					<input type="hidden" name="xsl" value="pabulumba" />
					<input type="submit" style="display: none" value="" />
				</tr>
			</table>
		</form>
	</xsl:template>

</xsl:stylesheet>
