<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<!--xsl:output method="html"/-->
	<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD XHTML Basic 1.1//EN" doctype-system="http://www.w3.org/TR/xhtml-basic/xhtml-basic11.dtd"/>
	<xsl:template match="/doc">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<title>
					<xsl:value-of select="/doc/page/@title"/>
				</title>
				<script language="javascript" type="text/javascript">
				</script>
				<style>
					table, tr, th, td {
						border: thin solid black;
						border-collapse: collapse;
						margin: auto;
					}
					table {
						margin-bottom: 20px;
					}
					div.main {
						border: thick solid black; 
						width: 478px; 
						background-color: #eee;
					}
					h1 {
						text-align: center;
					}
				</style>
			</head>
		<body>
			<div class="main">
			<a href="./pabulumba.php"><img src="./images/community.png"/></a>
			<h1><xsl:value-of select="/doc/page/@title"/></h1>
			<div>
				<table><tr><th>Attendees</th></tr>
					<xsl:apply-templates select="/doc/form[1]/table[@name='attendees_grid']/tr/td/inputCell"/>
				</table>
			</div>
			</div>

		</body>
	</html>
	</xsl:template>

	<xsl:template match="inputCell">
		<xsl:if test="string-length(@value) > 0">
			<tr><td>
				<xsl:value-of select="@value"/>
			</td></tr>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
