<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<!--xsl:output method="html"/-->
	<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD XHTML Basic 1.1//EN" doctype-system="http://www.w3.org/TR/xhtml-basic/xhtml-basic11.dtd"/>
	<xsl:template match="/doc">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<title>
					<xsl:value-of select="/doc/page/@title"/>
				</title>
				<script language="javascript" type="text/javascript">
				</script>
				<style>
					table, tr, th, td, body {
						border: thin solid black;
						border-collapse: collapse;
						margin: auto;
						font-family: arial;
						font-size:8pt;
					}
					table {
						margin-bottom: 20px;
					}
					div.main {
						border: thick solid black; 
						background-color: #eee; 
						page-break-after: always;
						font-family: arial;
						font-size:11pt;
					}
					h1 {
						text-align: center;
					}
					input.switch {
						/* IE auto centres text grrr */
						border: none;
						margin: 0;
						padding: 0;
						text-align: left;
						text_decoration: underline;
						background-color: #eee;
					}	
				</style>
			</head>
		<body>
			<div class="main">
				<h1><xsl:value-of select="/doc/page/@title"/></h1>
				<div>
					<xsl:apply-templates select="/doc/reportForm/table"/>
				</div>
			</div>
			<xsl:apply-templates select="switches"/>
		</body>
	</html>
	</xsl:template>

	<xsl:template match="table">
		<table>
		<xsl:apply-templates select="tr"/>
		</table>
	</xsl:template>

	<xsl:template match="tr">
		<tr>
		<xsl:apply-templates select="th|td"/>
		</tr>
	</xsl:template>

	<xsl:template match="th">
		<th>
		<xsl:value-of select="."/>
		</th>
	</xsl:template>

	<xsl:template match="td">
		<td>
			<xsl:apply-templates select="table|text()"/>
		</td>
	</xsl:template>

	<!--xsl:template match="inputCell">
		<xsl:if test="string-length(@value) > 0">
			<tr><td>
				<xsl:value-of select="@value"/>
			</td></tr>
		</xsl:if>
	</xsl:template-->
	<xsl:template match="switches">
		<div style="margin: 10px 0 0 0">
			<xsl:apply-templates select="switch" />
		</div>
	</xsl:template>
	
	<xsl:template match="switch">
		<xsl:param name="xml"><xsl:value-of select="@xml"/></xsl:param>
		<xsl:param name="navigation"><xsl:value-of select="@navigation"/></xsl:param>
		<xsl:param name="xsl"><xsl:value-of select="@xsl"/></xsl:param>
		<xsl:param name="printXsl"><xsl:value-of select="@printXsl"/></xsl:param>
		<xsl:param name="id"><xsl:value-of select="@id"/></xsl:param>
		<xsl:param name="action"><xsl:value-of select="@action"/></xsl:param>
		<xsl:param name="selectCriteria"><xsl:value-of select="@selectCriteria"/></xsl:param>
		<xsl:param name="orderCriteria"><xsl:value-of select="@orderCriteria"/></xsl:param>
		<xsl:param name="aggregateOn"><xsl:value-of select="@aggregateOn"/></xsl:param>
		<xsl:param name="aggregateFunctions"><xsl:value-of select="@aggregateFunctions"/></xsl:param>
		<xsl:param name="value"><xsl:value-of select="."/></xsl:param>
		<xsl:param name="pageTitle"><xsl:value-of select="/doc/page/@title"/></xsl:param>
		<div>
		<form method="POST" action="pabulumba.php">
			<input type="hidden" name="navigation" value="{$navigation}" />
			<input type="hidden" name="action" value="{$action}" />
			<input type="hidden" name="id" value="{$id}" />
			<input type="hidden" name="xml" value="{$xml}" />
			<input type="hidden" name="xsl" value="{$xsl}" />
			<input type="hidden" name="printXsl" value="{$printXsl}" />
			<input type="hidden" name="selectCriteria" value="{$selectCriteria}" />
			<input type="hidden" name="orderCriteria" value="{$orderCriteria}" />
			<input type="hidden" name="aggregateOn" value="{$aggregateOn}" />
			<input type="hidden" name="aggregateFunctions" value="{$aggregateFunctions}" />
			<input type="hidden" name="title" value="{$value}" />
				Return to report: 
			<xsl:choose>
				<xsl:when test="@permission='r' and $id='0'">
					<span class="sameAsInputSwitchButPale"><xsl:value-of select="."/> (no records) </span>
				</xsl:when>
				<xsl:when test="@permission='r'">
					<span class="sameAsInputSwitchButPale"><xsl:value-of select="."/> (read only) </span>
				</xsl:when>
				<xsl:when test="@permission='h'">
				</xsl:when>
				<xsl:otherwise>
					<input type="submit" class="switch" value="{$value}" onClick="document.getElementById('busy').style.display = '';" />
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="@processParam1='y'">
				<input style="margin-left: 10px" type="text" size="5" name="processParam1" />
			</xsl:if>
		</form>
		</div>
	</xsl:template>

</xsl:stylesheet>
