<?php
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//    pabulumba: a tiny content management system
//    (Originally known as `pmdb`)
//    Copyright (C) 2015 Paul Morris
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses>.
//
//    View the full GNU General Public License at <http://www.pabulumba.com/manual/gpl-3.0.txt>
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//    pabulumba.php VERSION 0.1.0
//
//    Interpreter of pabulumba XML configuration files
//
//    To jump directly to a label, do a case-sensitive search for:
//
//    EXECUTE_EVERY_TIME
//    DELETE_
//    DUPLICATE_
//    NEW
//    PROCESSES
//    DISPLAY
//    UPDATE_
//	validate_against_rules
//  	write_grid_values
//  	insert_new_value
//  	update_existing_value
//    STANDARD_REPORTS
//      write_grid_value
//    CUSTOM_REPORTS
//    SPECIAL_REPORTS
//    XML_OUTPUT
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//    CHANGE LOG
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//    SQL error numbering to next use: ERR110
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//}}}


// used for measuring how long pabulumba took to run a particular task.  The command that writes to the db
// is close to the end of this file

$time_start = microtime(true);

// database.php contains the connection strings for the db.  It is in a separate file to avoid overwriting
// the site-specific strings when upgrading this file

include_once("./config/database.php");

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//    ERRORS
//    only have error reporting turned on while testing or on intranets
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

error_reporting(E_ALL);
ini_set('display_errors', '1');

//{{{ Setup variables, NavIds, Login form and logic

// global variables

$errorMsg = '';
$successMsg = '';
$debugMsg = '';
$query = '';
$nextId = 0;
$minId = 0;
$maxId = 0;
$nextAction = '';
$recordCount = 0;
$conditions = '';
$gridCount = 0;
$userId = '';
$phpSessionId = '';
$ruleCounter = 0;
$ruleArr = array();

// grab the details from the login 'form'

if (isset($_POST['login_username'])) $username = $_POST['login_username'];
else $username = '';
if (isset($_POST['login_password'])) $password = $_POST['login_password'];
else $password = '';

// open the database

$linki = open_db();

// grab all global settings and define constants

$query = "select id,date_separator,date_format,file_upload_path,dest_id_on_duplication,debug_logging,duplicate_history,duplicate_files,duplicate_grids,select_filter_threshold,show_deleted,display_images,sum_prefix,count_prefix,average_prefix,average_round,canvas_size_erd,timeout,max_length_file_name,pabulumba_instance_id,user_logging,config_source,xsl_template,xsl_source,show_nav_history,max_nav_history,show_preview,max_preview,show_page_process_time,test_mode,test_email_address,from_email_address,use_rules, language, sentence_pattern,md5_password, login_attempts_limit from setting where id = 1";
$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR043 - $query ] "));
$row = mysqli_fetch_row($result);

define("DATE_SEPARATOR", $row[1]);
define("DATE_FORMAT", $row[2]);
define("FILE_UPLOAD_PATH", $row[3]);
//define("DEST_ID_ON_DUPLICATION", $row[4]);
define("DEBUG_LOGGING", $row[5]);
//define("DUPLICATE_HISTORY", $row[6]);
//define("DUPLICATE_FILES", $row[7]);
//define("DUPLICATE_GRIDS", $row[8]);
define("SELECT_FILTER_THRESHOLD", $row[9]);

// I suspect SHOW_DELETED is redundant, and can be used for next setting required
// I can't at this stage ever think why that might not be required
//
define("SHOW_DELETED", $row[10]);
define("DISPLAY_IMAGES", $row[11]);

define("SUM_PREFIX", $row[12]);
define("COUNT_PREFIX", $row[13]);
define("AVERAGE_PREFIX", $row[14]);
define("AVERAGE_ROUND", $row[15]);
define("CANVAS_SIZE_ERD", $row[16]);
// no need for constant; the setting is referenced directly in SQL code below (search for setting.timeout)
// define("TIMEOUT", $row[17]);
define("MAX_LENGTH_FILE_NAME", $row[18]);
$PABULUMBA_INSTANCE_ID = $row[19];

if (strlen($PABULUMBA_INSTANCE_ID) < 32) {
	$PABULUMBA_INSTANCE_ID = getNewRandomString(32);
	$query = "update setting set pabulumba_instance_id = '{$PABULUMBA_INSTANCE_ID}' where id = 1";
	mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR060- $query ] "));
	define("PABULUMBA_INSTANCE_ID", $PABULUMBA_INSTANCE_ID);
}
else {
	define("PABULUMBA_INSTANCE_ID", $row[19]);
}

define("USER_LOGGING", $row[20]);
define("CONFIG_SOURCE", $row[21]);
define("XSL_TEMPLATE", $row[22]);
define("XSL_SOURCE", $row[23]);
define("SHOW_NAV_HISTORY", $row[24]);
define("MAX_NAV_HISTORY", $row[25]);
define("SHOW_PREVIEW", $row[26]);
define("MAX_PREVIEW", $row[27]);
define("SHOW_PAGE_PROCESS_TIME", $row[28]);
define("TEST_MODE", $row[29]);
define("TEST_EMAIL_ADDRESS", $row[30]);
define("FROM_EMAIL_ADDRESS", $row[31]);
define("USE_RULES", $row[32]);
define("LANGUAGE", $row[33]);
define("SENTENCE_PATTERN", $row[34]);
define("MD5_PASSWORD", $row[35]);
define("LOGIN_ATTEMPTS_LIMIT", $row[36]);

// these must be the same as in the `action' table; not read to save time

define("LOGIN",1);
define("LOGIN_FAIL",2);
define("LOGOUT",3);
define("CREATE",4);
define("READ",5);
define("UPDATE",6);
define("DELETE",7);
define("LOGICAL_DELETE",8);
define("REPORT",9);
define("DUPLICATE",10);


/*

0: Apply Permission to Target when Select element value = Current for Role/s
4: Apply Permission to Switch when Select element value = Current for Role/s
3: Restrict Select element options to Current and Proposed when Select element value = Current for Role/s
2: Apply SQL when Select same as Proposed for Role/s
1: Apply SQL for Role/s
   
*/

define('ELEMENT_PERMISSION', 1);
define('SWITCH_PERMISSION', 2);
define('TRANSITION', 3);
define('SQL_ON_TRANSITION', 4);
define('SQL', 5);

//if (SHOW_DELETED) {
$showDeleted = true;

//}
//else {
//	$showDeleted = false;
//}


// if coming from the login 'form', attempt to log in and set some session variables

if (isset($_POST['login_username']) && isset($_POST['login_password'])) { 
	if (MD5_PASSWORD === '2') {
		$query = "select user.id, full_name from user where LOWER(username) = '" . strtolower($username) . "' and password = md5(concat(salt,'$password')) and login_attempts < " . LOGIN_ATTEMPTS_LIMIT;
	}
	else {
		$query = "select user.id, full_name from user where LOWER(username) = '" . strtolower($username) . "' and password = '$password' and login_attempts < " . LOGIN_ATTEMPTS_LIMIT;
	}
	$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR097 - ' . $query . ']'));
	if (mysqli_num_rows($result) == 1) {
		$row = mysqli_fetch_row($result);
		$tmp = $row[0];
		session_start();
		$query = "update user set last_login = now(), session_id = '" . session_id() . "' where id = " . $tmp;
		mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR096 - ' . $query . ']'));
		$_SESSION['userId' . PABULUMBA_INSTANCE_ID] = $tmp;
		$userId = $_SESSION['userId' . PABULUMBA_INSTANCE_ID];

		//  if commenting out debug lines, don't comment this one

		$_SESSION['debugMsg'] = '';
		$phpSessionId = session_id();
		if (USER_LOGGING) {
			$logInsertQuery = "insert into log (action_time, user, action_id, deleted) values (now(), {$tmp}, " . LOGIN . ", 0)";
			mysqli_query($linki, $logInsertQuery) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR075 - ' . $logInsertQuery . ']'));
		}
	}
	else {
		$query = 'update user set login_attempts = login_attempts + 1 where LOWER(username) = \'' . strtolower($username) . '\''; 
		mysqli_query($linki, $query); // or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR075 - ' . $logInsertQuery . ']'));
		header("Content-type: application/xml");
		echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?xml-stylesheet href=\"config/" . XSL_TEMPLATE . ".xsl\" type=\"text/xsl\"?>";
		echo "\n<doc><page title=\"Login\"/><login msg='Username/password combination incorrect or login attempts exceeded'/></doc>";
		if (USER_LOGGING) {
			$logInsertQuery = "insert into log (action_time, user, action_id, deleted) values (now(), 0, " . LOGIN_FAIL . ", 0)";
			mysqli_query($linki, $logInsertQuery);
		}
		exit();
	}
} 

// first time ever to the site, so create a session (writing the cookie), then redirect back to the login page

elseif (!isset($_POST['login_username']) && !isset($_POST['login_password']) && !isset($_COOKIE['PHPSESSID'])) { 
	session_start();
	header("Content-type: application/xml");
	echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?xml-stylesheet href=\"config/" . XSL_TEMPLATE . ".xsl\" type=\"text/xsl\"?>";
	echo "\n<doc><page title=\"Login\"/><login msg=''/></doc>";
	exit();
}
// otherwise we assume user could be logged in, so look for userId and sessionId

else {
	session_start();
	if (isset($_SESSION['userId' . PABULUMBA_INSTANCE_ID])) {
		$userId = $_SESSION['userId' . PABULUMBA_INSTANCE_ID];
		if (isset($_COOKIE['PHPSESSID'])) $phpSessionId = $_COOKIE['PHPSESSID'];
	}
}

// check to see if the user is logged in, and has performed some system action in the last (system setting) interval

$query = "select count(user.id) from user, setting where user.id = '$userId' and user.session_id = '$phpSessionId' and user.last_login > date_sub(now(), INTERVAL setting.timeout MINUTE)";

$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR098 - ' . $query . ']'));
$row = mysqli_fetch_row($result);
if (($tmp = $row[0]) <= 0) {
	header("Content-type: application/xml");
	echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?xml-stylesheet href=\"config/" . XSL_TEMPLATE . ".xsl\" type=\"text/xsl\"?>";
	echo "\n<doc><page title=\"Login\"/><login msg=''/></doc>";
	exit();
}

//  if commenting out debug lines, don't comment this one

$_SESSION['debug'] = DEBUG_LOGGING - 1;
$msg = '';

if ($_SESSION['debug']) $_SESSION['debugMsg'] = logIt($linki, '#############################################################');
else $_SESSION['debugMsg'] = '';

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//
//    EXECUTE_EVERY_TIME
//
//    occurs on the user - this should be on logging in
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

// TODO put this into a session vble?
$query = 'select message_number, label from message where deleted = 0 and language = \'' . LANGUAGE . '\'';
$result = mysqli_query($linki, $query);
$messageArr = array();
while ($row = mysqli_fetch_row($result)) {
	$messageArr[$row[0]] = $row[1]; 
}

$user = new User($userId, $linki);

if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "User has just been created: " . $user->userName);

// get the name of the xsl config file

if (XSL_SOURCE == 1) {
	$xsl = XSL_TEMPLATE;
}
else {
	if (isset($_POST['xsl'])) {
		$xsl = $_POST['xsl'];
	}
	else {
		$xsl = XSL_TEMPLATE;
	}
}

if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'XSL: ' . $xsl);

// get the action to be performed, such as display, or report, or erd

if (isset($_POST['action'])) $action = $_POST['action'];
else $action = 'display';

// TODO else displayErrorPage($linki, $userId, 'No action indicated. Please add an action to the config file intended to be used.');

if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, '$action = ' . $action . ' on being set by the POSTed value');

// get the filter to be appended to the SQL

if (isset($_POST['selectCriteria'])) $selectCriteria = $_POST['selectCriteria'];
else $selectCriteria = '';
$selectCriteria = preg_replace('/\[CURRENT_USER_ID\]/', $userId, $selectCriteria);

if ($action!='customReport') {

// get the name of the xml config file
	
if (isset($_POST['xml'])) $xml = $_POST['xml'];
else {
	$xml = 'main';
	$_POST['navigation'] = 'max|-';
}	

if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "selectCriteria: $selectCriteria");


if (! isset($_SESSION['config'])) {
	$query = "select id, configText from config where deleted = 0";
	$result = mysqli_query($linki, $query);
	$configArr = array();
	while ($row = mysqli_fetch_row($result)) {
		$_SESSION['config'][$row[0]] = $row[1];
	}
}


// load the configuration file

$configXmlDoc = new DOMDocument();
getConfigData($configXmlDoc,"{$xml}.xml",1, $linki);
$menuXmlDoc = new DOMDocument();
getConfigData($menuXmlDoc,"menu.xml",2, $linki);


if ($user->userRoleRefNo == 100) {


$newElement = $menuXmlDoc->createElement('menuItem','SysAdmin');
$newAttribute = $menuXmlDoc->createAttribute('xml');
$newAttribute->value = 'sysadmin';
$newElement->appendChild($newAttribute);
$newAttribute = $menuXmlDoc->createAttribute('xsl');
$newAttribute->value = 'pabulumba';
$newElement->appendChild($newAttribute);
$newAttribute = $menuXmlDoc->createAttribute('permission');
$newAttribute->value = 'whhhhhhhhh';
$newElement->appendChild($newAttribute);
$newNodeList = $menuXmlDoc->getElementsByTagName("menu");
$newNodeList->item(0)->appendChild($newElement);
}

if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Number of forms: " . $configXmlDoc->getElementsByTagName("form")->length);

$form = $configXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("name");
if ($configXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("duplicateFiles") == "n") {
	define("DUPLICATE_FILES", 1);
}
else {
	define("DUPLICATE_FILES", 2);
}
if ($configXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("duplicateHistory") == "n") {
	define("DUPLICATE_HISTORY", 1);
}
else {
	define("DUPLICATE_HISTORY", 2);
}
if ($configXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("duplicateGrids") == "n") {
	define("DUPLICATE_GRIDS", 1);
}
else {
	define("DUPLICATE_GRIDS", 2);
}
if ($configXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("duplicateURL") == "n") {
	define("DUPLICATE_URL", 1);
}
else {
	define("DUPLICATE_URL", 2);
}

if ($configXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("actionOnDuplication") == "stay") {
	define("DEST_ID_ON_DUPLICATION", 1);
}
else {
	define("DEST_ID_ON_DUPLICATION", 2);
}

$formUsesRules = $configXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("useRules");

if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Form name: " . $form);

// test to see if form exists; if  not, fail gracefully

$query = "select count(id) from $form";
$row = mysqli_fetch_row(mysqli_query($linki, $query));

if ($row[0]) {
	if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "A database record exists for this XML form.");
}
else {
	if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "No db record exists for this XML form.");
}

// get the id of the record we are looking for

if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "NavIds-1");
//$_SESSION['debugMsg'] .= logIt($linki, 'First nav ids');
$navIds = new NavigationIds($form, $user, $selectCriteria, $linki);


// obtain all the XML nodelists required from the XML config file

$elementSet = $configXmlDoc->getElementsByTagName("element");
$menuItemSet = $menuXmlDoc->getElementsByTagName("menuItem");
$switchSet = $configXmlDoc->getElementsByTagName("switch");
$linkSet = $configXmlDoc->getElementsByTagName("link");
$hypertextSet = $configXmlDoc->getElementsByTagName("hypertext");
$reportSet = $configXmlDoc->getElementsByTagName("report");
$valueArr = array();
for ($i = 0; $i < $elementSet->length; $i++) {
	$valueArr[$elementSet->item($i)->getAttribute("name")] = '';
}

//  if a 

$switchesUseRules = ($switchSet->length > 0) ? $configXmlDoc->getElementsByTagName("switches")->item(0)->getAttribute("useRules"): 'n';

if (USE_RULES == 2 && ($formUsesRules == 'y' || $switchesUseRules == 'y')) {

/*

	Examples of rules

|    1 | permit_plant |         0 |       0 | Plant items must only appear once in the Permit/Plant datagrid      | select count(id) from permit_plant
 where permit = [CURRENT_ID] and plant = [PROPOSED_VALUE] | -           |          2 |
|    1 | to_date      |         0 |       0 | The Required date must be earlier than the Surrender date           | select [PROPOSED_VALUE:from_date]
>= [PROPOSED_VALUE:to_date]                               | -           |          2 |
|    1 | job_desc     |         0 |       0 | Job Description must not have an 'f' in it                          | select not [PROPOSED_VALUE:job_des
c] like '%f%'                                             | -           |          2 |
|    4 | permit_state |         4 |       0 | NULL                                                                | NULL
*/


	$query = "select ru.id, ru.type, ru.element_name, from_value, to_value, reason, sql_or_regexp, sql_text, sql_text_2, rr.element_name, permission from rule ru inner join rule_role rr on ru.id = rr.rule inner join role ro on rr.role = ro.id where form_name = '{$form}' and role_ref_no = {$user->userRoleRefNo} and ru.deleted = 0 and rr.deleted = 0 and ro.deleted = 0";
	//echo $query; exit;
	$result = mysqli_query($linki, $query);
	//$_SESSION['debugMsg'] .= logIt($linki, $query);
	if (mysqli_num_rows($result) == 0) {
		//$errorMsg .= '<msg>A rule is required</msg>';
		$errorMsg .= "<msg>{$messageArr[8]}</msg>";
	}
	else {
		//$matchFound = false;
		//$prevVals = explode('|', $_POST['prevValues']);
		//$prevValCounter = 0;
		while ($row = mysqli_fetch_row($result)) {
			$ruleArr[$ruleCounter++] = new Rule($row[0], $row[1], $row[2], $row[3], $row[4], $row[5], $row[6], $row[7], $row[8], $row[9], $row[10]);
			//$ruleArr[$ruleCounter++] = new Rule($row[0], $row[1], $row[2], $row[3], $row[4], $row[5]);
			//$ruleArr[$ruleCounter++] = new Rule($row[0], $row[1], $row[2], $row[3]);
		}
	}
}
if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Number of elements in form: " . $elementSet->length);
//$prevValue = array();
$prevValuesViaDb = '';
//}}}

//{{{ Delete, Duplicate, New, Search

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//
//    DELETE_
//
//    occurs on the user clicking the Delete button
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

if ($action == 'delete') {
	if (isset($_POST['navigation'])) {
		$navigation = explode('|', $_POST['navigation']);
		$navAction = $navigation[0];
		$navId = $navigation[1];
	}
	else {
		echo "System problem - no navigation action set"; exit;
	}

	$query = "delete from $form where id = $navId";
	$result = mysqli_query($linki, $query);
	if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Delete Query: " . $query);
	if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Result: " . $result);
	if ($result == 1) {
		$query = "delete from history where record_id = '$navId' and form_name = '$form'";
		mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR044 - $query ] "));
		$query = "delete from file where record_id = '$navId' and form_name = '$form'";
		mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR045 - $query ] "));
		$query = "delete from url where record_id = '$navId' and form_name = '$form'";
		mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR105 - $query ] "));
		//-------------------------------
		// TODO this next code has never been tested, because needs new delete options (Force keep trying, or just deprecate)
		// We end up in a vicious circle, because, by definition, if grid data exists, a form record attached cannot be removed due
		// to foreign key references.
		/*
		$xpath = new DOMXPath($configXmlDoc);
		$xpQuery = "/doc/form/element[@type='grid']";
		$gridElementSet = $xpath->query($xpQuery);
		for ($j = 0; $j < $gridElementSet->length; $j++) {
			$source = $gridElementSet->item($j)->getAttribute('source');
			$filter = $gridElementSet->item($j)->getAttribute('filterColumn');
			$query = "delete from $source where $filter = $navId";
			$_SESSION['debugMsg'] .= logIt($linki, "Delete from grids query: " . $query);
			//mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR099 - ' . $query . ']'));
		}
		*/
		//-------------------------------
		if (USER_LOGGING) {
			$logInsertQuery = "insert into log (action_time, user, form_name, record_id, action_id, deleted) values (now(), $userId, '$xml', $navId, " . DELETE . ", 0)";
			mysqli_query($linki, $logInsertQuery) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR073 - ' . $logInsertQuery . ']'));
		}
	}
	else {
		// TODO need to clean up history, file, and url records if form entry logically deleted
		$query =  "update $form set deleted = 1 where id = $navId";
		$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR002 - $query ] "));
		if (USER_LOGGING) {
			$logInsertQuery = "insert into log (action_time, user, form_name, record_id, action_id, deleted) values (now(), $userId, '$xml', $navId, " . LOGICAL_DELETE . ", 0)";
			mysqli_query($linki, $logInsertQuery) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR077 - ' . $logInsertQuery . ']'));
		}
	}

	if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "NavIds-2");
	$navIds = new NavigationIds($form, $user, $selectCriteria, $linki);
	$action = 'display';
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//
//    DUPLICATE_
//
//    occurs on the user clicking the Duplicate button
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

elseif ($action == 'duplicate') {
	if (isset($_POST['navigation'])) {
		$navigation = explode('|', $_POST['navigation']);
		$navAction = $navigation[0];
		$navId = $navigation[1];
	}
	else {
		echo "System problem - no navigation action set"; exit;
	}
	$insertQuery = buildDuplicateQuery($navId, $form, $elementSet);
	if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Duplicate query - " . $insertQuery);
	$result = mysqli_query($linki, $insertQuery);
	if ($result) {
		$result = mysqli_query($linki, "select last_insert_id()") or die(displayErrorPage($linki, $userId, mysqli_error($linki)));
		$row = mysqli_fetch_row($result);
		$dupId = $row[0];
		if (USER_LOGGING) {
			$logInsertQuery = "insert into log (action_time, user, form_name, record_id, action_id, notes, deleted) values (now(), $userId, '$xml', $navId, " . DUPLICATE . ", '{$dupId}', 0)";
			mysqli_query($linki, $logInsertQuery) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR074 - ' . $logInsertQuery . ']'));
		}
		if (DUPLICATE_HISTORY == 2) {
			$query = "insert into history (action_time, user, record_id, form_name, element_name, old_value, new_value) (select action_time, user, $dupId, form_name, element_name, old_value, new_value from history where form_name = '$form' and record_id = $navId)";
			mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR046 - ' . $query . ']'));
		}
		if (DUPLICATE_FILES == 2) {
			$query = "insert into file (form_name, record_id, file_name) (select form_name, $dupId, file_name from file where form_name = '$form' and record_id = $navId)";
			mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR047 - ' . $query . ']'));
		}
		if (DUPLICATE_URL == 2) {
			$query = "insert into url (form_name, record_id, url_name) (select form_name, $dupId, url_name from url where form_name = '$form' and record_id = $navId)";
			mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR107 - ' . $query . ']'));
		}
		if (DUPLICATE_GRIDS == 2) {
			$xpath = new DOMXPath($configXmlDoc);
			$xpQuery = "/doc/form/element[@type='grid']";
			$gridElementSet = $xpath->query($xpQuery);
			for ($j = 0; $j < $gridElementSet->length; $j++) {
				$xpQuery = "/doc/form/element[@type='grid'][$j+1]/field";
				$childNodeList = $xpath->query($xpQuery);
				$source = $gridElementSet->item($j)->getAttribute('source');
				$filter = $gridElementSet->item($j)->getAttribute('filterColumn');
				$query = "insert into $source ($filter,";
				$fieldList = '';
				for ($k = 0; $k < $childNodeList->length; $k++) {
					if ($childNodeList->item($k)->nodeType == XML_ELEMENT_NODE) {
						$query .= $childNodeList->item($k)->getAttribute('name') . ',';
						$fieldList .= $childNodeList->item($k)->getAttribute('name') . ',';
					}
				}
				$query .= " deleted) select '$dupId', {$fieldList}0 from $source where $filter = $navId";
				mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR099 - ' . $query . ']'));
			}
		}
		//if (DEST_ID_ON_DUPLICATION == 2) {
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "NavIds-3");
		$navIds = new NavigationIds($form, $user, $selectCriteria, $linki);
		//}
	}
	else {
		$errorMsg .= getDuplicateKeyErrorMsg(mysqli_error($linki));
	}
	$action = 'display';
}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//
//    NEW
//
//    occurs when the user click the New button to create a new record
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

elseif ($action == 'new') {
	$action = 'display';
	$showDeleted = false;
}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//
//    PROCESSES
//
//    Processes can be defined by the user, if they are written as a PHP function and inserted into the 
//    ~/processes/folder and passed the ProcessParam class containing the required variables
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

elseif (substr($action, 0, 7) === 'process') {
	include_once('./processes/' . substr($action, 7) . '.php');
	$processFunction = substr($action, 7);

	if (isset($_POST['processParam1'])) {
		$processParam1 = $_POST['processParam1'];
	}
	else {
		$processParam1 = '';
	}
	$processParam = new ProcessParam($user, $processParam1, $navIds, false, $form, $linki);

	// PHP supports the concept of variable functions. This means that if a variable name has parentheses appended to it, PHP will look for a function with the same name as whatever the variable evaluates to, and will attempt to execute it. 
	// http://php.net/manual/en/functions.variable-functions.php

	$processFunction($processParam);

	if ($processParam->jumped) $navIds = $processParam->navIds;

	$action = 'display';
}
elseif ($action == 'search') {
	$action = 'display';
}
} // end of "if action != customReport"
//}}}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//
//    DISPLAY
//
//    This is where the fields get set from either the db or the form, depending upon the referencing page.
//    
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

//{{{ Display
if ($action == 'display') {
	$nextAction = 'update';
	if ($form != 'dummy') {
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "NavIds 243: " . $_POST['navigation']);

		// If a brand new record has been requested...

	if ($_POST['navigation'] == 'new|-') {
		for ($i = 0; $i < $elementSet->length; $i++) {
			if ($elementSet->item($i)->getAttribute("type") == 'grid') {
				getGridValues($valueArr, $configXmlDoc, $elementSet, $gridCount, $i, 0, $userId, $linki);
			}
			else {
				if (strlen($elementSet->item($i)->getAttribute("default")) > 0) {
					if ($elementSet->item($i)->getAttribute("default") == '[CURRENT_DATE]') {
						$valueArr[$elementSet->item($i)->getAttribute("name")] = formatDateFor('displayExPost','t');
					}
					else {
						$valueArr[$elementSet->item($i)->getAttribute("name")] = $elementSet->item($i)->getAttribute("default");
					}
				}
				else {
					$valueArr[$elementSet->item($i)->getAttribute("name")] = '';
				}
			}
		}
	}
	else {

		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "NavIds 244: " . $_POST['navigation']);
		$query = "select ";

		// get each field name from the form

		for ($i = 0; $i < $elementSet->length; $i++) {
			$query .= $elementSet->item($i)->getAttribute("name") . ', ';
		}
		$query = substr($query, 0, strlen($query) - 2);
		$query .= " from $form where id = '$navIds->id' $selectCriteria";

		// Next line may have been required at some stage; not sure if still necesssary; replacing with `select 1'
		//if ($elementSet->length == 0) $query = "select id from setting where id = 1";
		if ($elementSet->length == 0) $query = "select 1";
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Display query: " . $query);
		$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR005 - $query ] "));
		$row = mysqli_fetch_row($result);

		// get the value for each field in an associative array
		// this is used to pass the names and values into the xml string created later

		if (mysqli_num_rows($result) > 0) {
			for ($i = 0; $i < $elementSet->length; $i++) {
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Stepping through the elementSet of names: " . $elementSet->item($i)->getAttribute("name"));
				if ($elementSet->item($i)->getAttribute("type") == 'textarea') {
					$valueArr[$elementSet->item($i)->getAttribute("name")] = str_replace("\r\n", "&#013;&#010;", htmlspecialchars($row[$i]));
				}
				else if ($elementSet->item($i)->getAttribute("type") == 'grid') {
					getGridValues($valueArr, $configXmlDoc, $elementSet, $gridCount, $i, $navIds->id, $userId, $linki);
				}
				else {
					if ($elementSet->item($i)->getAttribute("validate") == 'date' && $elementSet->item($i)->getAttribute("type") == 'input') {
						if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Date value b4: {$row[$i]}");
						$valueArr[$elementSet->item($i)->getAttribute("name")] = formatDateFor('displayExDb', $row[$i]);
						if ($_SESSION['debug']) {
//							$_SESSION['debugMsg'] .= logIt($linki, "Date value after: {$valueArr[$elementSet->item($i)->getAttribute("name")]}");
						}
					}
					else {
						if ($elementSet->item($i)->getAttribute("type") == 'select') {
							$valueArr[$elementSet->item($i)->getAttribute("name")] = $row[$i];
							$prevValuesViaDb .= $row[$i] . '|';
						}
						else {
							$valueArr[$elementSet->item($i)->getAttribute("name")] = htmlspecialchars(stripslashes($row[$i]));
						}
					}
				}
			}
			if (USER_LOGGING) {
				$logInsertQuery = "insert into log (action_time, user, form_name, record_id, action_id, deleted) values (now(), {$userId}, '$xml', $navIds->id, " . READ . ", 0)";
				mysqli_query($linki, $logInsertQuery) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR080 - ' . $logInsertQuery . ']'));
			}
		}
		elseif ($navIds->idCount == 0){
			$errorMsg .= "<msg>{$messageArr[7]}</msg>";
		}
		else {
			// first check to see if there are simply no records in the table as yet
			// "The requested ID does not exist";
			$errorMsg .= "<msg>{$messageArr[1]}</msg>";
			//$_POST['navigation'] = "max|-";
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "NavIds 245: " . $_POST['navigation']);
//			$_SESSION['debugMsg'] .= logIt($linki, "NavIds 345: " . $navIds->idCount);
			// TODO have changed from the above to below to stop the message appearing when there are simply no records,
			// and to always show a New, so Save doesn't get hit every single time by me!!!
			// This may affect when deleting a record
			// TODO go to messages and create a new record, then delete it - it will not go back to the last record
			//$_POST['navigation'] = "new|-";
			$navIds = new NavigationIds($form, $user, $selectCriteria, $linki);
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "NavIds 246: " . $navIds->id);
		}
		mysqli_free_result($result);
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "End of Display");
	}
	}
	else {
		if (USER_LOGGING) {
			$logInsertQuery = "insert into log (action_time, user, form_name, action_id, deleted) values (now(), {$userId}, '$xml', " . READ . ", 0)";
			mysqli_query($linki, $logInsertQuery) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR080 - ' . $logInsertQuery . ']'));
		}
	}

}
//}}}
//{{{ Update
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//
//    UPDATE_
//
//    This is where the current record gets saved when the user clicks Save
//    
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

elseif ($action == 'update') {
	$pagePermission = '';
	$permission = '';
	$errorMsg = '';
	$maxFileSize = 0;
	$insertQuery = "insert into $form (";
	$updateQueryClause = '';
	$insertQueryFieldNames = '';
	$insertQueryFieldNamesClause = '';
	$insertQueryValues = '';
	$insertQueryValuesClause = '';
	$gridCount = 0;
	$gridInfoArr = array();
	$historyInsertQuery = array();
	$historyInsertQueryCounter = 0;
	$numRowsUpdated = -1;
	$updateQuery = "update $form set ";
	$emailSent = false;
	$emailSent = false;
	$gridUpdated = false;
	$prevValuesViaUpdate = '';
	if ($_SESSION['debug']) {

//  if commenting out debug lines, don't comment next three debug lines

		$_SESSION['debugMsg'] .= logIt($linki, "Entering update with an id of:" . $navIds->id);
		if ($navIds->newRecord) {
			$_SESSION['debugMsg'] .= logIt($linki, "This is a new record");
		}
		else {
			$_SESSION['debugMsg'] .= logIt($linki, "This is NOT a new record");
		}
	}

	// validate_against_rules

	if (USE_RULES == 2&& $formUsesRules == 'y') {
/*

0: Apply Permission to Target when Select element value = Current for Role/s
1: Apply SQL for Role/s
2: Apply SQL when Select same as Current for Role/s
3: Restrict Select element options to Current and Proposed when Select element value = Current for Role/s
4: Apply Permission to Switch when Select element value = Current for Role/s
   
*/
	$matchFound = false;
	$sqlReturnVal = true;
	$prevVals = explode('|', $_POST['prevValues']);
	$prevValCounter = 0;

	//  run through the cartesian product of the element set and the rule set to see if any element matches any rule name

	for ($i = 0; $i < $elementSet->length; $i++) {
		for ($j = 0; $j < $ruleCounter; $j++) {
//						$_SESSION['debugMsg'] .= logIt($linki, "Element: $i Rule: $j ruleCounter: $ruleCounter " . $elementSet->item($i)->getAttribute("name") . ' v ' . $ruleArr[$j]->elementName);
			// if it does match the name...
			// TODO can I hashmap this cartesian product in some way?
			if ($ruleArr[$j]->elementName == $elementSet->item($i)->getAttribute("name")) {
						//$_SESSION['debugMsg'] .= logIt($linki, 'Current value of ' . $elementSet->item($i)->getAttribute("name") . ' is ' . $_POST[$elementSet->item($i)->getAttribute("name")] . ' PrevVal: ' . $prevVals[$prevValCounter] . ' Rule type: ' . $ruleArr[$j]->ruleType);
						//$_SESSION['debugMsg'] .= logIt($linki, $_POST['navigation'] . '-' . SQL );
						// TODO test this, but if you jump out, you might miss a rule while trying to be efficient
				//if ($_POST['navigation'] == 'save|0' || $ruleArr[$j]->ruleType == ELEMENT_PERMISSION || $ruleArr[$j]->ruleType == SWITCH_PERMISSION ) {
//						$_SESSION['debugMsg'] .= logIt($linki, 'Rule type: ' . $ruleArr[$j]->ruleType);
				if ($_POST['navigation'] == 'save|0') {
					$matchFound = true;
					break;
				}
				// target permission is not processed here
				elseif ($ruleArr[$j]->ruleType == ELEMENT_PERMISSION || $ruleArr[$j]->ruleType == SWITCH_PERMISSION ) {
//						$_SESSION['debugMsg'] .= logIt($linki, '.');
						$matchFound = true;
						//continue;
						//break 2;
				}
				elseif ($ruleArr[$j]->ruleType == SQL || ($ruleArr[$j]->ruleType == SQL_ON_TRANSITION && ($ruleArr[$j]->toValue == $_POST[$elementSet->item($i)->getAttribute("name")] && $ruleArr[$j]->fromValue == $prevVals[$prevValCounter]))) {
					if (strlen($ruleArr[$j]->sqlText) > 0) {
						$matchFound = true;
						$tmpStr = $ruleArr[$j]->sqlText;
						$tmpStr2 = " {$ruleArr[$j]->sqlText2} ";
						$ts = '';
						$tmpStr = str_replace('[CURRENT_ID]', $navIds->id, $tmpStr);
						$tmpStr = str_replace('[CURRENT_VALUE]', $prevVals[$prevValCounter], $tmpStr);
						//$_SESSION['debugMsg'] .= logIt($linki, 'CURRENT VALUE: ' . $prevVals[$prevValCounter] . '|' . $elementSet->item($i)->getAttribute("name"));
/*
						//  the PROPOSED_VALUE:.*?:\d construct matches a grid reference - all entries in that column

						if (preg_match('/\[PROPOSED_VALUE:.*?:\d\]/', $tmpStr)) {
							//$_SESSION['debugMsg'] .= logIt($linki, 'matches a grid');
							$gridValue = true;
							$a = 0;
							while ($gridValue) {
								$tmpStr2 = $ruleArr[$j]->sqlText2;
								$tmpStr2 = str_replace('[CURRENT_ID]', $navIds->id, $tmpStr2);
								preg_match_all('/\[PROPOSED_VALUE:(.*?)\]/', $tmpStr2, $matches);
								for ($k = 0; $k < sizeof($matches[1]); $k++) {
									$tmpArr = explode(':', $matches[1][$k]);
									$_SESSION['debugMsg'] .= logIt($linki, 'posted value: ' . "{$tmpArr[0]}_{$a}_{$tmpArr[1]}");
									if (isset($_POST["{$tmpArr[0]}_{$a}_{$tmpArr[1]}"])) {
										$gridValue = true;
										$tmp =  $_POST["{$tmpArr[0]}_{$a}_{$tmpArr[1]}"];
										$_SESSION['debugMsg'] .= logIt($linki, 'tmp: ' . $tmp . ' AND gridValue = true' . ' a: ' . $a);
									}
									else {
										$gridValue = false;
										break;
									}
									if ($elementSet->item($i)->getAttribute("validate") == 'date') {
										$tmp = formatDateFor('databaseExPost',$tmp);
									}
									$tmpStr2 = preg_replace('/\[PROPOSED_VALUE:.*?\]/', "'" . $tmp . "'", $tmpStr2, 1);
									//$_SESSION['debugMsg'] .= logIt($linki, 'tmpStr2.2: ' . $tmpStr2);
								}       
								if ($gridValue) {
									$ts .= ' '. $tmpStr2 . ' and ';
									$_SESSION['debugMsg'] .= logIt($linki, 'ts.3' . $ts);
								}
								$a++;
							}       
							$ts .= '1=1';
							$_SESSION['debugMsg'] .= logIt($linki, 'ts.2' . $ts);
						}
*/
						//  Replace any single labels with their posted values in the SQL statement

						//elseif (preg_match('/\[PROPOSED_VALUE:.*?\]/', $tmpStr)) {
						if (preg_match_all('/\[PROPOSED_VALUE:(.*?)\]/', $tmpStr, $matches)) {
							for ($k = 0; $k < sizeof($matches[1]); $k++) {
							//$_SESSION['debugMsg'] .= logIt($linki, "k: $k" . '/\[PROPOSED_VALUE:.*?\]/' . '/' . "'" . $_POST[$matches[1][$k]] . "'" . '/' . $tmpStr);
								if (isset($_POST[$matches[1][$k]])) {
									$tmpStr = preg_replace('/\[PROPOSED_VALUE:.*?\]/', "'" . $_POST[$matches[1][$k]] . "'", $tmpStr, 1);
								}
							} 
						  	$ts = $tmpStr;
						}
						else {
						  	$ts = $tmpStr;
						}

						if (! strpos($ts, 'PROPOSED_VALUE')) { 


						if (preg_match('/\[PROPOSED_VALUE:.*?:\d\]/', $tmpStr2)) {
							//$_SESSION['debugMsg'] .= logIt($linki, 'matches a grid');
								//$tmpStr2 = $ruleArr[$j]->sqlText2;
								$tmpStr2 = str_replace('[CURRENT_ID]', $navIds->id, $tmpStr2);
								preg_match_all('/\[PROPOSED_VALUE:(.*?)\]/', $tmpStr2, $matches);
								if (sizeof($matches[1]) > 1) {
									$errorMsg .= "<msg>There must only be one repeating SQL condition</msg>";
								}
								for ($k = 0; $k < sizeof($matches[1]); $k++) {
									$tmpArr = explode(':', $matches[1][$k]);
									$gridValue = true;
									$a = 0;
									while ($gridValue) {
									//$_SESSION['debugMsg'] .= logIt($linki, 'posted value: ' . "{$tmpArr[0]}_{$a}_{$tmpArr[1]}");
									if (isset($_POST["{$tmpArr[0]}_{$a}_{$tmpArr[1]}"])) {
										$gridValue = true;
										$tmp =  $_POST["{$tmpArr[0]}_{$a}_{$tmpArr[1]}"];
										//$_SESSION['debugMsg'] .= logIt($linki, 'tmp: ' . $tmp . ' AND gridValue = true' . ' a: ' . $a);
										if ($elementSet->item($i)->getAttribute("validate") == 'date') {
											$tmp = formatDateFor('databaseExPost',$tmp);
										}
										//$ts .= ' ' . preg_replace('/\[PROPOSED_VALUE:.*?\]/', "'" . $tmp . "'", $tmpStr2, 1) . ' ';
										$ts .= ' ' . preg_replace('/\[PROPOSED_VALUE:' . $tmpArr[0] . '.*?\]/', "'" . $tmp . "'", $tmpStr2, 1) . ' ';
										//$ts .= " $tmpStr2 ";
									$a++;
									}
									else {
										$gridValue = false;
										break;
									}
									}       
								}       
							if (strtolower(substr(rtrim($ts), -4)) === ' and') {
								$ts .= '1=1';
							}
							elseif (strtolower(substr(rtrim($ts), -3)) === ' or') {
								$ts .= '1=2';
							}
							//$_SESSION['debugMsg'] .= logIt($linki, 'ts.2' . $ts);
						}

							if ($ruleArr[$j]->sqlOrRegexp == 1) {
								//$_SESSION['debugMsg'] .= logIt($linki, 'About to run: ' . "$ts");
								$result = mysqli_query($linki, $ts) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR103 - ' . $ts . ']')); $row = mysqli_fetch_row($result); $sqlReturnVal = $row[0];
								if ($sqlReturnVal > 0) {
									$errorMsg .= "<msg>{$ruleArr[$j]->reason}</msg>";
								}
							}
							elseif ($ruleArr[$j]->sqlOrRegexp == 2) {
								$regexp = $ruleArr[$j]->sqlText;
								if ($regexp{0} === $regexp{strlen($regexp) - 1}) {
									$sqlReturnVal = preg_match($ruleArr[$j]->sqlText, $_POST[$elementSet->item($i)->getAttribute("name")]);
								}
								else {
									$regexp = '/' . $ruleArr[$j]->sqlText . '/';
								}
								if ($sqlReturnVal > 0) {
									$errorMsg .= "<msg>{$ruleArr[$j]->reason}</msg>";
								}
							}
							elseif ($ruleArr[$j]->sqlOrRegexp == 3) {
								//$_SESSION['debugMsg'] .= logIt($linki, 'About to run UPDATE: ' . "$ts");
								if (mysqli_query($linki, $ts)) {
									//$_SESSION['debugMsg'] .= logIt($linki, 'run');
									$successMsg .= "<msg>{$ruleArr[$j]->reason}</msg>";
								}
								else {
								//$_SESSION['debugMsg'] .= logIt($linki, 'no_run');
									// TODO put into messages
									$errorMsg .= "<msg>There is a problem with the UPDATE SQL statement in rule #{$ruleArr[$j]->id}</msg>";
								}

							}
						}
					}
				}
				elseif ($ruleArr[$j]->ruleType == TRANSITION) {
					$matchFound = true;
					//$_SESSION['debugMsg'] .= logIt($linki, '.');
					// TODO something wrong here; matchFound never gets set.
					if ($ruleArr[$j]->fromValue == $prevVals[$prevValCounter]) {
						// ... and the proposed value matches the rule
						if ($ruleArr[$j]->toValue == $_POST[$elementSet->item($i)->getAttribute("name")] || $ruleArr[$j]->fromValue == $_POST[$elementSet->item($i)->getAttribute("name")]) {
						}
					}
				}
			}
		}
		if ($elementSet->item($i)->getAttribute("type") == 'select') $prevValCounter++;
	} // end of looping through the element set to see if a rule applies

	if (! $matchFound) {
		// TODO put this into messages
		$errorMsg .= "<msg>{$messageArr[10]}</msg>";
		//$errorMsg .= '<msg>At least one rule is required for this form.</msg>';
	}
	}
/*
				if ($ruleArr[$j]->elementName == $elementSet->item($i)->getAttribute("name")) {
					if ($_POST['navigation'] == 'save|0') {
						$matchFound = true;
						break;
					}
					else {
						if ($ruleArr[$j]->fromValue == 0 && $ruleArr[$j]->toValue == 0 ) {
						}
						elseif ($ruleArr[$j]->fromValue == $prevVals[$prevValCounter]) {
							// ... and the proposed value matches the rule
							if ($ruleArr[$j]->toValue == $_POST[$elementSet->item($i)->getAttribute("name")] || $ruleArr[$j]->fromValue == $_POST[$elementSet->item($i)->getAttribute("name")]) {
								if (strlen($ruleArr[$j]->sqlText) > 0) {
									$tmpStr = $ruleArr[$j]->sqlText;
									$tmpStr = str_replace('[CURRENT_ID]', $navIds->id, $tmpStr);
									$tmpStr = str_replace('[PROPOSED_VALUE]', $_POST[$elementSet->item($i)->getAttribute("name")], $tmpStr);
									//$result = mysqli_query($linki, $ruleArr[$j]->sqlText);
									//$sqlReturnVal = mysqli_fetch_row($result)[0];
								}
								$matchFound = true;
							}
						}
					}
				}
				}*/
		//}
	//}
	/*
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Previous values:" . $prevVals[$prevValCounter] . ':' . $_POST[$elementSet->item($i)->getAttribute("name")]);
			while ($row = mysqli_fetch_row($result)) {
				$ruleArr[$ruleCounter++] = new Rule($row[0], $row[1], $row[2], $row[3], $row[4], $row[5], $row[6]);
				if ($row[7] == 1) {
					//$result2 = mysqli_query($linki, $row[6]);
					//if (mysqli_fetch_row($result2)[0] == 1) $errorMsg .= '<msg>' . $row[5] . ' ' . $row[5] . '</msg>';
				}
				else {
				// if the current user's role matches the rule...
				//echo ($user->userRoleRefNo); exit;

				if ($user->userRoleRefNo == $row[0]) {
					// if the choice is Cannot
					if ($row[1] == 0) {
						// if the element name matches...
						if ($row[2] == $elementSet->item($i)->getAttribute("name")) {
							// if the previous value matches the rule...
							if ($row[3] == $prevVals[$prevValCounter]) {
								// if the proposed value matches the rule...
								if ($row[4] == $_POST[$elementSet->item($i)->getAttribute("name")]) {
									//$errorMsg .= '<msg>' . $row[5] . ' ' . $row[5] . '</msg>';
									break;
								}
							}
						}
					}
				}
				}
			}
			$prevValCounter++;
		}
	}
*/




	
	//$lastInsertedGridValues = '';
	//$gridIdentifierStr = getNewRandomString(8);
	$delayedInsertStatement = array();
	$delayedInsertStatementIdx = 0;

	for ($i = 0; $i < $elementSet->length; $i++) {
		$insertQueryFieldNamesClause = $elementSet->item($i)->getAttribute("name");
		$pagePermission = checkPermission('page', $pagePermission, $user, $configXmlDoc->getElementsByTagName("page")->item(0)->getAttribute("permission"));
		$permission = checkPermission('element', $pagePermission, $user, $elementSet->item($i)->getAttribute("permission"));
		$updateQueryClause = $elementSet->item($i)->getAttribute("name") . " = ";
		$postedValue = null;
		if (isset($_POST[$elementSet->item($i)->getAttribute("name")])) {
			$postedValue = stripslashes($_POST[$elementSet->item($i)->getAttribute("name")]);
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "The posted value:" . $postedValue);
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Type of form element (set):" . $elementSet->item($i)->getAttribute("type"));

			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Keep history? : " . $elementSet->item($i)->getAttribute("keepHistory"));
			if ($elementSet->item($i)->getAttribute("keepHistory") == 'y') {
				$oldValue = '';
				if ($_POST['navigation'] != 'save|0') {
					$query = "select {$elementSet->item($i)->getAttribute('name')} from $form where id = $navIds->id";
					//echo $query; exit;
					$result = mysqli_query($linki, $query);
					if (mysqli_num_rows($result) > 0) {
						$row = mysqli_fetch_row($result);
						$oldValue = $row[0];
					}
				}
				//$_SESSION['debugMsg'] .= logIt($linki, "History old val for {$elementSet->item($i)->getAttribute("name")}: $oldValue");
				//$_SESSION['debugMsg'] .= logIt($linki, "History cur val for {$elementSet->item($i)->getAttribute("name")}: $postedValue");
				//$_SESSION['debugMsg'] .= logIt($linki, "History type for {$elementSet->item($i)->getAttribute("name")}: {$elementSet->item($i)->getAttribute("type")}");
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "History old val for {$elementSet->item($i)->getAttribute("name")}: $oldValue");
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "History cur val for {$elementSet->item($i)->getAttribute("name")}: $postedValue");
				if ($elementSet->item($i)->getAttribute("contiguousHistory") == 'y' || ($oldValue != $postedValue && $elementSet->item($i)->getAttribute("type") != 'select') || ($elementSet->item($i)->getAttribute("type") == 'select' && (($oldValue != '' && $postedValue == '-693') || ($oldValue == '' && $postedValue != '-693')))) {

					// only validate if coming from an input, textarea, or select field

					if ($elementSet->item($i)->getAttribute("type") == 'input' || $elementSet->item($i)->getAttribute("type") == 'textarea') {
						$temp = validate($postedValue, $elementSet->item($i)->getAttribute("validate"), $elementSet->item($i)->getAttribute("mandatory"), $elementSet->item($i)->getAttribute("maxSize"), $elementSet->item($i)->getAttribute("label"), $messageArr);
					}
					else if ($elementSet->item($i)->getAttribute("type") == 'select') {
					       	if ($elementSet->item($i)->getAttribute("mandatory") == 'y') {
							$temp = validate($postedValue, "selection", "y", "99", $elementSet->item($i)->getAttribute("label"), $messageArr);
					       	}
					}
					else {
						$temp = '';
					}
					if (strlen($temp) == 0) {
						// store up any commands necessary to insert into history
						// when the page is eventually successfully validated
						$temp = $navIds->id;
						if ($_POST['navigation'] == 'save|0') {
							$temp = 'value_to_be_replaced_with_last_insert_id';
						}
						$historyInsertQuery[$historyInsertQueryCounter++] = "insert into history (action_time, user, record_id, form_name, element_name, old_value, new_value) values (now(), '{$user->userId}', '{$temp}', '$form', '{$elementSet->item($i)->getAttribute('name')}', '" . mysqli_real_escape_string($linki, $oldValue) . "', '" . mysqli_real_escape_string($linki, $postedValue) . "')";
						if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "History insert query: " . mysqli_real_escape_string($linki, $historyInsertQuery[$historyInsertQueryCounter - 1]));
						// What about lookup for select columns?
						//mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR006 - ' . $query . ']'));
					}
					else {
						if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "History failed query: " . mysqli_real_escape_string($linki, $query . "/" . $temp));
					}
				}
			}

			if ($elementSet->item($i)->getAttribute("type") == 'grid') {
				$gridName = $elementSet->item($i)->getAttribute("name");
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, " ================== Start: " . strtoupper($gridName) . " ================= ");
				$gridValuesCompulsory = false;
				$gridValuesExist = false;
				$gridXmlDoc[$gridCount] = new DOMDocument();
				getConfigData($gridXmlDoc[$gridCount],"{$elementSet->item($i)->getAttribute("source")}.xml",3, $linki);
				$gridElementSet = $gridXmlDoc[$gridCount]->getElementsByTagName("element");
				$xpath = new DOMXPath($configXmlDoc);
				$xpQuery = "/doc/form/element[@name='{$elementSet->item($i)->getAttribute("name")}']/field";
				$fieldTree = $xpath->query($xpQuery);
				$fieldTreeAttributes = array();

				//  For each sub-element to be displayed within the grid element, check to see if it matches an element
				//  from the source of the grid data, and if so, grab the relevant attributes

				for ($j = 0; $j < $fieldTree->length; $j++) {

					for ($k = 0; $k < $gridElementSet->length; $k++) {
						if ($gridElementSet->item($k)->getAttribute("name") === $fieldTree->item($j)->getAttribute("name")) {
							$fieldTreeAttributes[$j] = array();
							$fieldTreeAttributes[$j]["validate"] = $gridElementSet->item($k)->getAttribute("validate");
							$fieldTreeAttributes[$j]["maxSize"] = $gridElementSet->item($k)->getAttribute("maxSize");
							$fieldTreeAttributes[$j]["label"] = $gridElementSet->item($k)->getAttribute("label");
							$fieldTreeAttributes[$j]["type"] = $gridElementSet->item($k)->getAttribute("type");
							$fieldTreeAttributes[$j]["filterByUser"] = $gridElementSet->item($k)->getAttribute("filterByUser");
							$fieldTreeAttributes[$j]["default"] = $gridElementSet->item($k)->getAttribute("default");
							if ($fieldTreeAttributes[$j]["filterByUser"] == 'y') $gridValuesCompulsory = true;
						}
					}
				}
				$xpQuery = "/doc/form/element[@name='{$elementSet->item($i)->getAttribute("name")}']/row";
				$rowTree = $xpath->query($xpQuery);
				$rowCount = $elementSet->item($i)->getAttribute("autoRowNumber") == 0 ? $rowTree->length : $elementSet->item($i)->getAttribute("autoRowNumber");
				$colCount = $fieldTree->length;
				$gridInfoArr[$gridCount] = new GridInfo($gridName, $colCount);

				// write_grid_values: update grid statements etc

				$gridRowNum = 0;
				// TODO the gridRowNum value is currently used to place the potential new value of a grid entry into the array
				// It's possible that this could be replaced with a _new_, but then it might not be able to be looped through
				// when creating the XML output - this must be checked

				for ($j = 0; $j < $rowCount; $j++) {
					// if reached max number of entries in grid, so jump out
					if (! isset($_POST["{$gridName}_{$j}_0"])) break;
					if (isset($_POST["{$gridName}_{$j}_delete"])) {
						$deleteQuery = "delete from {$elementSet->item($i)->getAttribute("source")} where id = {$_POST["{$gridName}_{$j}_delete"]}";
						if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Delete from grid query: " . mysqli_real_escape_string($linki, $deleteQuery));
						mysqli_query($linki, $deleteQuery) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR090 - ' . $deleteQuery . ']'));
					}
					else {
						$gridValuesExist = true;
						$query = "update {$elementSet->item($i)->getAttribute("source")} set ";
						$valueArr["{$gridName}_{$j}_0"] = stripslashes($_POST["{$gridName}_{$j}_0"]);
								//$_SESSION['debugMsg'] .= logIt($linki, "colCount: {$colCount} g: $g");
						for ($k = 1; $k <= $colCount; $k++) {
							// if autoRowNumber is set to 0, use the value of the attributes of `display', else number the rows
							$label = $elementSet->item($i)->getAttribute("autoRowNumber") == 0 ? $rowTree->item($j)->getAttribute("display") : $j + 1;
							if ($fieldTreeAttributes[$k - 1]["type"] == "input") {
								if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Input value returned by POST: {$_POST["{$gridName}_{$j}_{$k}"]}");
								if ($fieldTreeAttributes[$k - 1]["validate"] == 'date') {
									$valueArr["{$gridName}_{$j}_{$k}"] = formatDateFor('displayExPost', $_POST["{$gridName}_{$j}_{$k}"]);
								}
								else {
									$valueArr["{$gridName}_{$j}_{$k}"] = stripslashes($_POST["{$gridName}_{$j}_{$k}"]);
								}
								//if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Input value after formatting: " . addslashes($valueArr['grid_' . $gridCount . '_' . $j . '_' . $k]));
								$temp = validate($valueArr["${gridName}_{$j}_{$k}"], $fieldTreeAttributes[$k - 1]["validate"], "y", $fieldTreeAttributes[$k - 1]["maxSize"], "{$fieldTreeAttributes[$k - 1]["label"]} : {$label}", $messageArr);
								if (strlen($temp) > 0) {
									$errorMsg .= '<msg>' . $temp . '</msg>';
									$gridInfoArr[$gridCount]->incrErrorCount();
								}
							}
							elseif ($fieldTreeAttributes[$k - 1]["type"] == "select" || $fieldTreeAttributes[$k - 1]["type"] == "radio") {
								$valueArr["{$gridName}_{$j}_{$k}"] = $_POST["{$gridName}_{$j}_{$k}"];
							}
							elseif ($fieldTreeAttributes[$k - 1]["type"] == "checkbox") {
								$valueArr["{$gridName}_{$j}_{$k}"] = isset($_POST["{$gridName}_{$j}_{$k}"]) ? 1 : 0;
							}
							if ($fieldTreeAttributes[$k - 1]["validate"] == 'date') {
								$tmpVal = formatDateFor('databaseExPost',$valueArr["{$gridName}_{$j}_{$k}"]);
								$query .= "{$fieldTree->item($k - 1)->getAttribute("name")} = '{$tmpVal}', ";
								$valueArr["{$gridName}_{$j}_{$k}"] = $tmpVal;
							}
							else {
								// TODO surely this write isn't necessary where the select value cannot change?
								$query .= "{$fieldTree->item($k - 1)->getAttribute("name")} = '" . addslashes($valueArr["{$gridName}_{$j}_{$k}"]) . "', ";
							}

						}
						$query = substr($query, 0, strlen($query) - 2);
						$query .= " where id = {$valueArr["{$gridName}_{$j}_0"]}";
						
						if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "grid query: " . addslashes($query));

						// update existing grid records

						// TODO write these values into a temporary table and update once, rather than in a loop

						if (strlen($errorMsg) == 0) {
							$gridUpdated = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR036 - ' . $query . ']'));
						}
				//assert($g == $j, 'g does not match j');
						$gridRowNum++;
				//$_SESSION['debugMsg'] .= logIt($linki, "g: $g");
					}
				}
				// TODO investigate to see if choosing the second DDL and leaving the first blank causes an error
				if (isset($_POST["{$gridName}_new_1"])) {
					if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "new: {$gridName}_new_1: " . $_POST["{$gridName}_new_1"] . " gridRowNum: $gridRowNum");
					//$_SESSION['debugMsg'] .= logIt($linki, "new: {$gridName}_new_1: " . $_POST["{$gridName}_new_1"] . " gridRowNum: $gridRowNum");
					$query = "insert into {$elementSet->item($i)->getAttribute("source")} (";
					$valueList = '';
					$concatenatedPostedValues = '';
					for ($k = 1; $k <= $colCount; $k++) {
						//$_SESSION['debugMsg'] .= logIt($linki, "G anthing other than 0?: {$gridRowNum}");
						$valueArr["{$gridName}_{$gridRowNum}_{$k}"] = stripslashes($_POST["{$gridName}_new_{$k}"]);
						$concatenatedPostedValues .= $valueArr["{$gridName}_{$gridRowNum}_{$k}"];
						$query .= "{$fieldTree->item($k - 1)->getAttribute("name")}, ";
					}
					// if anything has been returned from the page
					if (strlen($concatenatedPostedValues) > 0) {
						if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Concatenated posted values : $concatenatedPostedValues");
						for ($k = 1; $k <= $colCount; $k++) {
							$temp = "";
							if ($fieldTreeAttributes[$k - 1]["type"] == 'input') {
								if ($fieldTreeAttributes[$k - 1]["validate"] == 'date') {
									if ($fieldTreeAttributes[$k - 1]["default"] == '[CURRENT_DATE]') {
										$valueArr["{$gridName}_{$gridRowNum}_{$k}"] = formatDateFor('displayExPost', 't');
									}
									else {
										$valueArr["{$gridName}_{$gridRowNum}_{$k}"] = formatDateFor('displayExPost', $valueArr["{$gridName}_{$gridRowNum}_{$k}"]);
									}
								}
								if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "About to validate: {$gridName}_{$gridRowNum}_{$k} with value of: {$valueArr["{$gridName}_{$gridRowNum}_{$k}"]}");
								$temp = validate($valueArr["{$gridName}_{$gridRowNum}_{$k}"], $fieldTreeAttributes[$k - 1]["validate"], "y", $fieldTreeAttributes[$k - 1]["maxSize"], "{$fieldTreeAttributes[$k - 1]["label"]} : New", $messageArr);
								if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "temp: $temp");
								if ($fieldTreeAttributes[$k - 1]["validate"] == 'date') {
									$valueArr["{$gridName}_{$gridRowNum}_{$k}"] = formatDateFor('databaseExPost', $valueArr["{$gridName}_{$gridRowNum}_{$k}"]);
								}
							}
							else {
								$temp = validate($valueArr["{$gridName}_{$gridRowNum}_{$k}"], 'selection', "y", 10, "{$fieldTreeAttributes[$k - 1]["label"]} : New", $messageArr);
							}
							$valueList .= '\'' . htmlspecialchars(addslashes($valueArr["{$gridName}_{$gridRowNum}_{$k}"])) . "', ";
							if (strlen($temp) > 0) {
								$errorMsg .= "<msg>{$temp} (grid {$elementSet->item($i)->getAttribute("label")})</msg>";
								$gridInfoArr[$gridCount]->incrErrorCount();
							}
						}
						if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Posted Navigation: " . $_POST['navigation']);

						if ($_POST['navigation'] == 'save|0') {
							$valueList .= 'value_to_be_replaced_with_last_insert_id';
						}
						else {
							$valueList .= $navIds->id;
						}
						$query .= "{$elementSet->item($i)->getAttribute("filterColumn")}, deleted) values ({$valueList}, 0)";
						if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "grid insert query: " . addslashes($query) . $_POST['navigation']);
						//if (strlen($errorMsg) == 0) 
						// if there are no errors with the current grid update statement...
						if (! $gridInfoArr[$gridCount]->errorCount) {
							$delayedInsertStatement[$delayedInsertStatementIdx++] = $query;
							//$delayedInsertStatement[$delayedInsertStatementIdx++] = $gridCount;
							$delayedInsertStatement[$delayedInsertStatementIdx++] = $gridName;
							if ($_POST['navigation'] != 'save|0') {
								$gridUpdated = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR081 - ' . $query . ']'));
								$result = mysqli_query($linki, "select last_insert_id()");
								$row = mysqli_fetch_row($result);
								$valueArr["{$gridName}_{$gridRowNum}_0"] = $row[0];
							}
							// TODO I think the next 2 are in the wrong spot; maybe not sure
							//$_SESSION['debugMsg'] .= logIt($linki, "Val row[0]: $row[0] (grid: $gridName _ $gridRowNum _ 0)");
							// TODO need tobe sure that commenting out next 3 lines is actually going to work, and
							// not stop something else from working.

							//for ($k = 1; $k <= $colCount; $k++) {
							//	$valueArr["{$gridName}_new_{$k}"] = '';
							//}
						}
					}
					// if nothing gets returned by the page, reset the DDL for the grids
					else {
						// TODO not sure if this is necessary now
						//for ($k = 1; $k <= $colCount; $k++) {
						//	$valueArr["{$gridName}_new_{$k}"] = '';
						//}
						//$fieldTreeAttributes[$j]["filterByUser"]
						//if (strlen($temp) > 0) $errorMsg .= '<msg>' . $temp . '</msg>';
			// TODO put this into messages
						//if ($gridValuesCompulsory && !$gridValuesExist) $errorMsg .= "<msg>Values must be chosen for grid {$elementSet->item($i)->getAttribute("label")}</msg>";
						if ($gridValuesCompulsory && !$gridValuesExist) $errorMsg .= "<msg>{$messageArr[11]} {$elementSet->item($i)->getAttribute("label")}</msg>";
					}
					// TODO if one grid works, it should write that value, yes? Hmmm - how does it remember what the val is? No, just store the value back in new again...
					// if an error is thrown, put the selected DDL value back in
					//if (strlen($errorMsg) > 0) {
					for ($k = 1; $k <= $colCount; $k++) {
						if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "On error values: " . $_POST["{$gridName}_new_{$k}"]);
						//$_SESSION['debugMsg'] .= logIt($linki, "On error values: " . $_POST["{$gridName}_new_{$k}"]);
						//$_SESSION['debugMsg'] .= logIt($linki, "On error values (att): " . $_POST["attendees_new_{$k}"]);
						//$valueArr["{$gridName}_new_{$k}"] = stripslashes($_POST["{$gridName}_new_{$k}"]);
						$valueArr["stored_{$gridName}_new_{$k}"] = stripslashes($_POST["{$gridName}_new_{$k}"]);
					}
					//}
				}

				$gridCount++;
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, " ================== Finish: " . strtoupper($gridName) . " ================= ");

			}
			if ($elementSet->item($i)->getAttribute("type") == 'file') {
				$maxFileSize = $elementSet->item($i)->getAttribute("maxSize");
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Found the attribute of type FILE and its value is $postedValue" );
				// check to see if any files exist in db
				if ($navIds->id != '') { // this is required on opening a form on a brand new table
				$query = "select count(id) from file where record_id = $navIds->id and form_name = '" . $form . "'";
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "File query: " . addslashes($query));
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Values of action and nextAction: $action | $nextAction ");
				$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR007 - $query ] "));
				// if no files exist in db
				$row = mysqli_fetch_row($result);
				if (!$row[0]) {
					$postedValue = '0';
					if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Setting file value to $postedValue");
				}
				}
				if (strlen($_FILES['uploadedFile']['name']) > 0) {
					$postedValue = '1';
					if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Setting file value to $postedValue");
					if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "uploaded file exists");
				}
				else {
					if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "no uploaded file");
				}
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "POSTED File value is now $postedValue");
			}
			else if ($elementSet->item($i)->getAttribute("type") == 'url') {
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Found the attribute of type url and its 'postedvalue' is $postedValue" );
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Found the attribute of type url and its POST value is " . $_POST['uploadedURL']);
				// check to see if any url exist in db
				if (strlen($navIds->id) > 0) {
				$query = "select count(id) from url where record_id = $navIds->id and form_name = '" . $form . "'";
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "URL query: " . addslashes($query));
				$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR067 - $query ] "));
				// if no files exist in db
				$row = mysqli_fetch_row($result);
				if (!$row[0]) {
					$postedValue = '0';
				}
				else {
					$postedValue = '1';
				}
				}
				else {
					$postedValue = '0';
				}
				if (strlen($_POST['uploadedURL']) > 0) {
					$temp = "";
					$temp = validate($_POST['uploadedURL'], $elementSet->item($i)->getAttribute("validate"), $elementSet->item($i)->getAttribute("mandatory"), $elementSet->item($i)->getAttribute("maxSize"), $elementSet->item($i)->getAttribute("label"), $messageArr);
					if (strlen($temp) > 0) {
		// TODO put this into messages
						$errorMsg .= '<msg>' . $temp . '</msg>';
					}
					else {
						$postedValue = '1';
						if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Setting url value to $postedValue");
						if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "uploaded url exists");
						//$result = mysqli_query($linki, "select last_insert_id()");
						//$lastId = mysqli_fetch_row($result)[0];
						//$_SESSION['debugMsg'] .= logIt($linki, "navigation: {$_POST['navigation']}");
						//$_SESSION['debugMsg'] .= logIt($linki, "Id at this point: $navIds->id");
						if ($_POST['navigation'] == 'save|0') {
							$query = "insert into url (form_name, record_id, url_name) values ('{$form}', 'value_to_be_replaced_with_last_insert_id', '" . $_POST['uploadedURL'] . "')";
							$delayedInsertStatement[$delayedInsertStatementIdx++] = $query;
							$delayedInsertStatement[$delayedInsertStatementIdx++] = 'dummy';
						}
						else {
							$query = "insert into url (form_name, record_id, url_name) values ('{$form}', $navIds->id, '" . $_POST['uploadedURL'] . "')";
							mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR071 - ' . $query . ']'));
						}
						//if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "insert url query: $query");
					}
				}
				else {
					if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "no uploaded url");
				}
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "POSTED url value is now $postedValue");
				 
			}
			else if ($elementSet->item($i)->getAttribute("type") == 'select') {
				$prevValuesViaUpdate .= $postedValue . '|';
			       	if ($elementSet->item($i)->getAttribute("mandatory") == 'y') {
					$temp = validate($postedValue, "selection", "y", "99", $elementSet->item($i)->getAttribute("label"), $messageArr);
					if (strlen($temp) > 0) $errorMsg .= '<msg>' . $temp . '</msg>';
				}
			}
			else if ($elementSet->item($i)->getAttribute("type") == 'password') {
				if (MD5_PASSWORD === '2') {
					$salt = getNewRandomString(32);
					$query = "update user set salt = '$salt' where id = {$user->userId}";
					mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR108 - ' . $query . ']'));
					$postedValue = md5($salt . $postedValue);
				}
			}
		}
		else {
			if ($elementSet->item($i)->getAttribute("type") == 'checkbox' && $postedValue == '') $postedValue = '0';
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Name and type of form element (unset):" . $elementSet->item($i)->getAttribute("name") . "/" . $elementSet->item($i)->getAttribute("type"));
			//$_SESSION['debugMsg'] .= logIt($linki, "select {$elementSet->item($i)->getAttribute('name')} from $form where id = $navIds->id");
			// TODO there must be a way to get around calling this for every checkbox which is not ticked...
			// TODO work out what this really does...
			if ($elementSet->item($i)->getAttribute("type") != 'checkbox') {
				$query = "select {$elementSet->item($i)->getAttribute('name')} from $form where id = $navIds->id";
				$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR0102 - $query ] "));
				$row = mysqli_fetch_row($result);
				$postedValue = $row[0];
			}
		}
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'POSTed name: ' . $elementSet->item($i)->getAttribute("name") . " : " . $postedValue);
		// THIS SECTION __REPLACES__ POSTED VALUES, SUCH AS NEGATIVE SELECTION VALUES AND EMPTY STRINGS
		// It does no error checking
		// if the posted value is empty, and the field is not mandatory, replace with NULL
		// else replace the date value with the formatted date, or just use the actual value
		
		if ($postedValue == '' && $elementSet->item($i)->getAttribute("mandatory") != "y") {
			$updateQueryClause .= 'null';
			$insertQueryValuesClause = 'null';
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "blank value and not mandatory in " . $elementSet->item($i)->getAttribute("name")  . ". updatequeryclause: " . $updateQueryClause );
		}
		else {
			if ($elementSet->item($i)->getAttribute("type") == "input" && $elementSet->item($i)->getAttribute("validate") == "date") {
				$dateStr = "'" . formatDateFor('databaseExPost', $postedValue) . "'";
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Formatted date db: " . mysqli_real_escape_string($linki, $dateStr));
				$updateQueryClause .= $dateStr;
				$insertQueryValuesClause = $dateStr;
				$postedValue = formatDateFor('displayExPost', $postedValue);
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Formatted date dsply: " . mysqli_real_escape_string($linki, $postedValue));
			}
			else if ($elementSet->item($i)->getAttribute("type") == 'select' && $postedValue == '-693') {
				$updateQueryClause .= "null";
				$insertQueryValuesClause = "null";
			}
			else {
				$updateQueryClause .= "'" . mysqli_real_escape_string($linki, $postedValue) . "'";
				$insertQueryValuesClause = "'" . mysqli_real_escape_string($linki, $postedValue) . "'";
			}
		}
		$valueArr[$elementSet->item($i)->getAttribute("name")] = htmlspecialchars($postedValue);

		if ($permission != 'h' && ($elementSet->item($i)->getAttribute("type") == 'input' || $elementSet->item($i)->getAttribute("type") == 'textarea')) {
			$temp = validate($valueArr[$elementSet->item($i)->getAttribute("name")], $elementSet->item($i)->getAttribute("validate"), $elementSet->item($i)->getAttribute("mandatory"), $elementSet->item($i)->getAttribute("maxSize"), $elementSet->item($i)->getAttribute("label"), $messageArr);
		}
		else $temp = '';
	       	if (strlen($temp) > 0) $errorMsg .= '<msg>' . $temp . '</msg>';
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Error str here: [" . mysqli_real_escape_string($linki, $temp) . "]");
			$updateQueryClause .= ", ";
			$insertQueryFieldNamesClause .= ", ";
			$insertQueryValuesClause .= ", ";

		if ($permission != 'h') {
			$updateQuery .= $updateQueryClause;
			$insertQueryFieldNames .= $insertQueryFieldNamesClause;
			$insertQueryValues .= $insertQueryValuesClause;
		}
			// if the field is hidden, and yet mandatory for other users, the default value must be applied,
			// which means there must always be a default value offered for a hidden and mandatory field
		else if ($permission == 'h' && $elementSet->item($i)->getAttribute("mandatory") == 'y') {
			$insertQueryFieldNames .= $insertQueryFieldNamesClause;
			$tmp = $elementSet->item($i)->getAttribute("default");
			if ($elementSet->item($i)->getAttribute("validate") == 'date') {
				$tmp = formatDateFor('databaseExPost', $tmp);
			}
			$insertQueryValues .= "'{$tmp}', ";
		}
		else if ($postedValue == '' &&  substr($updateQuery, 0, 13) == 'update search') {
			$updateQuery .= $updateQueryClause;
		}

	} // end of looping through the field names

	// if all the element permissions are set to 'h', then there will be no clause to append to $updateQuery,
	// and it will try to run as, e.g. 'update ticket set '
	if (substr($updateQuery, -4) != 'set ') {
	$updateQuery = substr($updateQuery, 0, strlen($updateQuery) - 2);
	$insertQueryFieldNames = substr($insertQueryFieldNames, 0, strlen($insertQueryFieldNames) - 2);
	$insertQueryValues = substr($insertQueryValues, 0, strlen($insertQueryValues) - 2);

	if ($navIds->newRecord) {
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "New record in update:" . mysqli_real_escape_string($linki, $updateQuery));
		$navIds->id = 0;
		$navIds->idPosition = 0;
		$navIds->idCount++;
	}
	$updateQuery .= " where id = $navIds->id";
	if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "id during search: " . $navIds->id);


	if (isset($_POST['navigation'])) {
		$navigation = explode('|', $_POST['navigation']);
		$navAction = $navigation[0];
		if ($form == 'search' && !isset($navigation[1])) {
			$navId = 1;
		}
		else {
			$navId = $navigation[1];
		}
	}
	else {
		echo "System problem - no navigation action set"; exit;
	}
	//<F5>$errorMsg .= "<msg>$form $user->userRoleRefNo</msg>";
	//$successMsg .= "<msg>$form $user->userRoleRefNo</msg>";
	/*$errorMsg = '';
	for ($i = 0; $i < $elementSet->length; $i++) {
		$errorMsg .= $elementSet->item($i)->getAttribute("name");
	}
	$errorMsg .= "<msg>$errorMsg</msg>";

	new setting for whether checking is carried out or not, and all code should be wrapped by this boolean
		new setting for whether relevant rules are displayed at the top of the form or not
		Try to grey out or read-only the value which cannot be selected (the toValue)?
		Remove the values not appropriate? Put a [irrelevant] next to them?

	get the form name and see if there are any rules which relate to this form
	grab all the rules at that time, then cycle through the name attributes to see if any match

	table called rules:

	This role can|cannot change form name, field name to value-y because reason displayed
	$user-userRoleRefNo
	can/not
       	$form
	$name attribute
	valueArr[name]	

	Grunt cannot change payscales, grunts to better-paid because not allowed

	create table rule(id int primary key auto_increment, role int, choice int, form_name varchar(40), elementName varchar(40), toValue int, reason varchar(100));  







	 */




	// if id == 0, then do an insert, else do an update

	$uploadFilesOK = false;
	if ($navId == 0) {

		// insert_new_value
		
		$insertQuery .= $insertQueryFieldNames . ") values (" . $insertQueryValues . ")";
		if (strlen($errorMsg) == 0) {
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Insert query: " . mysqli_real_escape_string($linki, $insertQuery));
			$result = mysqli_query($linki, $insertQuery); // or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR008 - Error on inserting new record: $insertQuery ]"));
			if ($result) {

				//  It may initially look as though this code is unnecessary, but on inserting a new record, the recordID
				//  is `0'. If history is turned on for which record, that recordId needs to be updated to the new recordId
				//  (last inserted).  It could be made a little smarter, but to save how much time?


				//$_SESSION['debugMsg'] .= logIt($linki, 'New nav ids after insert of new value');
				//$_SESSION['debugMsg'] .= logIt($linki, 'Length of delayed insert statement:' . sizeof($delayedInsertStatement));
				//$navIds = new NavigationIds($form, $user, $selectCriteria);
			//$_SESSION['debugMsg'] .= logIt($linki, "All after insert: " . mysqli_result(mysqli_query("select concat(min(distinct user.id), '.', max(distinct user.id), '.', count(distinct user.id)) from user inner join user_group on user.id = user_group.user where group_table = 15"),0,0));
				$result = mysqli_query($linki, "select last_insert_id()");
				$row = mysqli_fetch_row($result);
				$id = $row[0];
				// this next line is necessary because if the new user is not allocated a group, the maxId (filtered by grid user)
				// will be the last grid user created
				//$navIds->id = $id;

				for ($i = 0; $i < $delayedInsertStatementIdx; $i+=2) {
					$query = str_replace('value_to_be_replaced_with_last_insert_id', $id, $delayedInsertStatement[$i]);
//				$_SESSION['debugMsg'] .= logIt($linki, "GridQuery: $query " . $_POST['navigation'] . " {$delayedInsertStatementIdx}");
				$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR100 - ' . $query . ']'));
				// TODO this will have to be looked at carefully - maybe cycle through the grid elemetns again :-(
				//$valueArr['grid_' . $delayedInsertStatement[$i+1] . '_0_0'] = mysqli_fetch_row(mysqli_query($linki, 'select last_insert_id()'))[0];
				$row = mysqli_fetch_row(mysqli_query($linki, 'select last_insert_id()'));
				$valueArr["{$delayedInsertStatement[$i+1]}_0_0"] = $row[0];
				//print_r($valueArr); exit;
//				$_SESSION['debugMsg'] .= logIt($linki, "Last insert into grid: {$delayedInsertStatement[$i+1]}" . mysqli_result(mysqli_query($linki, 'select last_insert_id()'),0,0));
				}
				// update the history if required

				for ($i = 0; $i < $historyInsertQueryCounter; $i++) {
					if (strlen($historyInsertQuery[$i]) > 0) {
						$historyInsertQuery[$i] = str_replace('value_to_be_replaced_with_last_insert_id', $id, $historyInsertQuery[$i]);
						mysqli_query($linki, $historyInsertQuery[$i]) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR093 - ' . $historyInsertQuery[$i] . ']'));
					}
				}

				// getting the Nav Ids after the grid updates because if filtering by grid values is on,
				// a value may be inserted into the filter tables which is then joined to the current table

				$navIds = new NavigationIds($form, $user, $selectCriteria, $linki);
				$query = "update history set record_id = $id where user = '{$user->userId}' and record_id = 0";
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "History insert on new query: $query");
				$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR010 - ' . $query . ']'));
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Result of history insert on new query: $result");
				//$tmpArr = explode(',', $lastInsertedGridValues);
				//for ($i = 0; $i < sizeof($tmpArr) - 1; $i+=3) {
				//	$query = "update {$tmpArr[$i]} set {$tmpArr[$i + 1]} = $id where id = {$tmpArr[$i + 2]}";
				//}
				//$result = mysqli_query($linki, $query) or die(mysqli_error($linki) . " [ERR082 - $query ]");
				$uploadFilesOK = true;
				if (USER_LOGGING) {
					//$logInsertQuery = "insert into log (action_time, user, form_name, record_id, action_id, deleted) values (now(), $userId, '$form', $id, " . CREATE . ", 0)";
					$logInsertQuery = "insert into log (action_time, user, form_name, record_id, action_id, deleted) values (now(), $userId, '$xml', $id, " . CREATE . ", 0)";
					mysqli_query($linki, $logInsertQuery) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR072 - ' . $logInsertQuery . ']'));
				}
				if (isset($_POST['sendEmailOnSave']) && strlen($_POST['sendEmailOnSave']) > 0) {

					sendEmailOnSave($elementSet, $navIds->id, $form, $user, $linki);
					$emailSent = true;
				}
			}
			else {
				$errorMsg .= getDuplicateKeyErrorMsg(mysqli_error($linki));
				//if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Error message called from UPDATE");
				//$_SESSION['debugMsg'] .= logIt($linki, "Error message (" . mysqli_error($linki) . ") called from UPDATE");
				//$_SESSION['debugMsg'] .= logIt($linki, "GridInfo errorCount @1: " . $gridInfoArr[$gridCount]);
				replaceAllNewGridValues($gridInfoArr, $gridCount, $valueArr, $linki);
				//for ($i = 0; $i < $gridCount; $i++) {  
				//	for ($j = 1; $j <= $gridInfoArr[$i]->colCount; $j++) {  
				//		$valueArr[$gridInfoArr[$i]->name . "_new_{$j}"] = $valueArr["stored_" . $gridInfoArr[$i]->name . "_new_{$j}"];
				//	}
				//}
			}
		}
		// if there is an error, we need to put ALL the new grid values back into the _new_ values
		else {
//			$_SESSION['debugMsg'] .= logIt($linki, "..");
			//$_SESSION['debugMsg'] .= logIt($linki, "GridInfo errorCount @2: " . $gridInfoArr[$gridCount]);
			replaceAllNewGridValues($gridInfoArr, $gridCount, $valueArr, $linki);
		}
	} // end of `if $navId == 0', i.e. a new record
	else {
		// if there are no mistakes...
		if (strlen($errorMsg) == 0) {

			// update the history if required

			for ($i = 0; $i < $historyInsertQueryCounter; $i++) {
				if (strlen($historyInsertQuery[$i]) > 0) {
					//$query = str_replace('value_to_be_replaced_with_last_insert_id', $id, $historyInsertQuery[$i]);
					mysqli_query($linki, $historyInsertQuery[$i]) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR042 - ' . $historyInsertQuery[$i] . ']'));
								//$_SESSION['debugMsg'] .= logIt($linki, "History update query2: " . mysqli_real_escape_string($linki, $historyInsertQuery[$i]));
				}
			}

			// update_existing_value

			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Update query: " . mysqli_real_escape_string($linki, $updateQuery));
//			$_SESSION['debugMsg'] .= logIt($linki, "Update query: " . mysqli_real_escape_string($linki, $updateQuery));
			$result = mysqli_query($linki, $updateQuery); // or die(displayErrorPage($linki, $userId, mysqli_error($linki) . "[ERR011 - $updateQuery ]"));
			if (isset($_POST['sendEmailOnSave']) && strlen($_POST['sendEmailOnSave']) > 0) {
				sendEmailOnSave($elementSet, $navIds->id, $form, $user, $linki);
				$emailSent = true;
			}
			$numRowsUpdated = mysqli_affected_rows($linki);
			if (!$result) {
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "No result for Update query");
				$errorMsg .= getDuplicateKeyErrorMsg(mysqli_error($linki));
			}
			else {
				$uploadFilesOK = true;
				if (USER_LOGGING) {
					//$logInsertQuery = "insert into log (action_time, user, form_name, record_id, action_id, deleted) values (now(), $userId, '$form', $navIds->id, " . UPDATE . ", 0)";
					$logInsertQuery = "insert into log (action_time, user, form_name, record_id, action_id, deleted) values (now(), $userId, '$xml', $navIds->id, " . UPDATE . ", 0)";
					mysqli_query($linki, $logInsertQuery) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR012 - ' . $logInsertQuery . ']'));
				}
			}
		}
		else {
			//$_SESSION['debugMsg'] .= logIt($linki, "GridInfo errorCount @3: " . '$gridInfoArr[$gridCount]');
			replaceAllNewGridValues($gridInfoArr, $gridCount, $valueArr, $linki);
		}
	}
	if (isset($_FILES['uploadedFile']['name']) && $uploadFilesOK) {
		if (strlen($_FILES['uploadedFile']['name']) > 0) {
			$file = $_FILES['uploadedFile']['name'];
			$fileSize = $_FILES['uploadedFile']['size'];
			$tempFile = $_FILES['uploadedFile']['tmp_name'];
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'File name exists as upload');

			// check to see if the file extension is permitted
			$query = "select extension_name from file_extension";
		
			$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR013 - $query ] "));
			// TODO check to see if extensionArr is EVER used
			$extensionArr = array();
			$fileExtensionOK = false;
			while ($row = mysqli_fetch_row($result)) {
				if (substr($file, -strlen($row[0])) == $row[0]) $fileExtensionOK = true;
			}
	
			// replace any spaces in the file name with underscores
			$file = str_replace(' ', '_', $file);


			// validate the name of the file
			$temp = validate($file, 'filename', 'y', MAX_LENGTH_FILE_NAME, '', $messageArr);
			if (strlen($temp) > 0) $fileNameOK = false; else $fileNameOK = true;
			$fileSizeOK = false;
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'File sizes: ' . $fileSize . "|" . $maxFileSize);
			if ($fileSize <= $maxFileSize) $fileSizeOK = true;
			if ($fileNameOK) {
			if ($fileExtensionOK && $fileSizeOK) {
				$query = "insert into file (form_name, record_id, file_name) values ('{$form}', $navIds->id, '')";
				mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR065 - ' . $query . ']'));
				$result = mysqli_query($linki, "select last_insert_id()");
				$row = mysqli_fetch_row($result);
				$last_insert_id = $row[0];
				$query = "select count(id) from file where file_name = '$file'";
				$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR066 - ' . $query . ']'));
				$row = mysqli_fetch_row($result);
				$count = $row[0];
				if ($count > 0) {
					$file = "[Duplicate_name_{$last_insert_id}]_$file";
				}
				$target_path = FILE_UPLOAD_PATH; //$fileUploadPath;

				$target_path .= basename($file);
				$result = move_uploaded_file($tempFile, $target_path);
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'File move result'. $result);
				if ($result) {
					$query = "update file set file_name = '$file' where id = $last_insert_id";
					mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR014 - ' . $query . ']'));
				}
				else {
					if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'File not moved');
		// TODO put this into messages
					$errorMsg = "<msg>{$messageArr[12]}</msg>";
					//$errorMsg = "<msg>This file was not uploaded due to its size. Check current settings.</msg>";
				}
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'File moved successfully?: ' . $_FILES['uploadedFile']['name'] . " : " . $result);
			}
			else if ($fileExtensionOK) {
		// TODO put this into messages
				$errorMsg = "<msg>{$messageArr[12]}</msg>";
				//$errorMsg = "<msg>The file was not uploaded due to its size. Check current settings.</msg>";
			}
			else if ($fileSizeOK) {
				$errorMsg = "<msg>{$messageArr[13]}</msg>";
				//$errorMsg = "<msg>The file was not uploaded due to its extension. Check file extension table for current settings.</msg>";
			}
			}
			else {
				$errorMsg = "<msg>$temp</msg>";
			}
		}
	}
	}
	$nextAction = 'update';
	// taking this out; TODO not sure if it is requried any more
	//$successMsg = '';
	if (strlen($errorMsg) == 0) {
		if ($numRowsUpdated == 0 && ! $gridUpdated) {
			// TODO setting forthis error message?  check the file/url deleteFlag and AND NOT to the previous IF
			//$errorMsg = '<msg>No data was changed as a result of this Save operation. It is possible that someone else deleted this exact record while it was open here. Try moving to the previous record and back again to see if it still exists. It is also possible that Save was clicked just in case...</msg>';
			//$errorMsg .= '<msg>It is also possible that Save was clicked just in case the data had changed :-)</msg>';
		}
		else {
			if ($emailSent) {
				$successMsg = "<msg>{$messageArr[14]}</msg>";
				//$successMsg = '<msg>Record saved, and email sent</msg>';
			}
			else {
				$successMsg .= "<msg>{$messageArr[15]}</msg>";
				//$successMsg .= '<msg>Record saved</msg>';
			}
		}
	}
}
//}}}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//    STANDARD_REPORTS
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//{{{ Output - Report
if ($action=='report') {
	$xpath = new DOMXPath($configXmlDoc);
	$xpQuery = "/doc/form/element[@type='grid']";
	$numGrids = $xpath->query($xpQuery)->length;
	//if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "ordercriteria $reportAction $orderCriteria");
	//$_SESSION['debugMsg'] .= logIt($linki, "number of grids: $numGrids");
	$pagePermission = '';
	$pagePermission = checkPermission('page', $pagePermission, $user, $configXmlDoc->getElementsByTagName("page")->item(0)->getAttribute("permission"));
	$fieldCount = array();
	$gridCount = 0;
	//$totalRecordCount = 0;
	if (isset($_POST['title'])) $title = $_POST['title'];
	else $title = '';
	$xmlStr = array();
   	$xmlStrIdx = 0;
	$exportStr = array();
	$difStr = array();
	$exportIdx = 0;
	$difIdx = 0;
	//$query = "select {$form}.id, ";
	$query2 = "select {$form}.id, ";
	$query3 = '';
	$joinClause = '';
	$gridIdentifierStr = getNewRandomString(8);

	if (isset($_POST['reportAction'])) $reportAction = $_POST['reportAction'];
	else $reportAction = 'none';

	if (isset($_POST['printXsl'])) $printXsl = $_POST['printXsl'];
	else $printXsl = 'pabulumba';

	if (isset($_POST['fileType'])) $fileType = $_POST['fileType'];
	else $fileType = 'dif';
	if ($fileType != 'dif' && $fileType != 'xls') $fileType = 'dif';

	if ($reportAction == 'print_all' || $reportAction == 'print_selected') {
		$xsl = $printXsl;
	}

	$xmlStr[$xmlStrIdx++] = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><?xml-stylesheet href=\"config/{$xsl}.xsl\" type=\"text/xsl\" ?>";

	// For some reason, the xml declaration triggers something in the syntax highlighting that does this! Please leave next line alone.
	// \<?

	$xmlStr[$xmlStrIdx++] = "\n<doc>\n\t<page title=\"{$title}\" />";
	$xmlStr[$xmlStrIdx++] = buildMenu($menuItemSet, $user, '', $linki);
	if (isset($_POST['selectCriteria'])) $selectCriteria = $_POST['selectCriteria'];
	else $selectCriteria = '';
	if (isset($_POST['orderCriteria'])) $orderCriteria = $_POST['orderCriteria'];
	else $orderCriteria = '';
	// cannot use aggregates if grids exist, hence the && ! $numGrids
	if (isset($_POST['aggregateOn']) && ! $numGrids) $aggregateOn = $_POST['aggregateOn'];
	else $aggregateOn = '';
	// cannot use aggregates if grids exist, hence the && ! $numGrids
	if (isset($_POST['aggregateFunctions']) && ! $numGrids) $aggregateFunctions = $_POST['aggregateFunctions'];
	else $aggregateFunctions = '';
	if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "ordercriteria $reportAction $orderCriteria");
	$phrase = "\n\t<reportForm action='pabulumba.php' method='POST'>\n\t\t<hidden name='id' value=\"0\" />\n\t\t<hidden id='reportAction' name='reportAction' value=\"{$reportAction}\" />\n\t\t<hidden name='xml' value=\"{$xml}\" />\n\t\t<hidden name='xsl' value=\"{$xsl}\" />\n\t\t<hidden name='printXsl' value=\"{$printXsl}\" />\n\t\t<hidden name='fileType' value=\"{$fileType}\" />\n\t\t<hidden name='action' value='report' />\n\t\t<hidden name='selectCriteria' value='{$selectCriteria}' />\n\t\t<hidden name='orderCriteria' value='{$orderCriteria}' />\n\t\t<hidden name='aggregateOn' value='{$aggregateOn}' />\n\t\t<hidden name='aggregateFunctions' value='{$aggregateFunctions}' />\n\t\t<hidden name='title' value='{$title}' />\n\t\t";

	$phrase .= buildFilter($elementSet, $showDeleted, $valueArr, $user, $form, $configXmlDoc, $linki, $reportAction);
	$exportStr[$exportIdx++] = '<?xml version="1.0" encoding="UTF-8"?><?mso-application progid="Excel.Sheet"?>
		<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet"
			xmlns:x="urn:schemas-microsoft-com:office:excel"
			xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet"
			xmlns:html="http://www.w3.org/TR/REC-html40">
		<ss:Styles>
			<ss:Style ss:ID="1">
				<ss:Font ss:Color="#009966" ss:Bold="1"/>
				<ss:Interior ss:Color="#cbf9cb" ss:Pattern="Solid"/>
			</ss:Style>
		</ss:Styles>
		<Worksheet ss:Name="' . $form . '"><Table>';

	$difStr[$difIdx++] = "TABLE\n0,1\n\"Sheet1\"\nVECTORS\n0,{$elementSet->length}\n\"\"\nTUPLES\n";
	$difStr[$difIdx] = "";
	$difSnapshot = $difIdx++;
	$difStr[$difIdx++] = "\"\"\nDATA\n0,0\n\"\"\n";

	$newPhrase = '<?xml version="1.0" encoding="UTF-8"?>' . $phrase . '</reportForm>';
	$mydoc = new DOMDocument();
	$mydoc->loadXML($newPhrase);
	$filteredOptions = $mydoc->getElementsByTagName('filteredOptions')->item(0)->nodeValue;
	$xmlStr[$xmlStrIdx++] = $phrase;
	$filterTableCondition = ' where 1=1';
	$hiddenOffset= 0;
	if (isset($_POST['bulk_selected']) && strlen($_POST['bulk_selected']) > 0) {
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, $_POST['bulk_selected']); 
	}

	if ($reportAction == 'filter' || $reportAction == 'export' || $reportAction == 'print_all' || $reportAction == 'print_selected' ) {
		// recordCountIndex is where the first <table> is inserted; this is because it needs to first obtain the #records in the output
		$recordCountIndex = $xmlStrIdx;
		$xmlStr[$xmlStrIdx++] = "";
		$exportStr[$exportIdx++] = "\n<Row>";
		$difStr[$difIdx++] = "-1,0\nBOT\n";
		$criteria = '';
		$snapshotIdx = 0;
		$snapshotDifIdx = 0;
		$snapshotExportIdx = 0;
		$gridNum = 0;
		$gridRefTableCount = 0;
		for ($i = 0; $i < $elementSet->length; $i++) {
			// TODO next line (the i up to the max (4 here)) can be manipulated to show a column selection, see also TODO around ln 2234 for
			// the next place to change this to make it all work
			// if ($i > 4) continue;
			$permission = checkPermission('element', $pagePermission, $user, $elementSet->item($i)->getAttribute("permission"));
			//if ($permission == 'h'|| ($elementSet->item($i)->getAttribute("type") == "grid" && isset($_POST['excludeGridData']))) OPENBRACE
			if ($permission == 'h') {
				$hiddenOffset++;
			}
			else {

			// Draw the labels for the grid headings

			if ($aggregateOn && $elementSet->item($i)->getAttribute("type") == "grid") {
				$hiddenOffset++;
			}
			elseif ($elementSet->item($i)->getAttribute("type") == "grid") {
				$exportStr[$exportIdx] = "\n\t" . '<Cell ss:StyleID="1"><Data ss:Type="String">' . $elementSet->item($i)->getAttribute("label");
				$snapshotExportIdx = $exportIdx++;
				$xmlStr[$xmlStrIdx] = "\n\t\t\t\t<th>" . $elementSet->item($i)->getAttribute("label") . "<br/>$gridIdentifierStr" . $gridNum . '</th>';
				$snapshotIdx = $xmlStrIdx++;

				$difStr[$difIdx] = "1,0\n\"{$elementSet->item($i)->getAttribute("label")} {$gridIdentifierStr}{$gridNum}\"\n";
				$snapshotDifIdx = $difIdx++;
			}
			else {
				$xmlStr[$xmlStrIdx++] = "\n\t\t\t\t<th>" . $elementSet->item($i)->getAttribute("label") . '</th>';
				$exportStr[$exportIdx++] = "\n\t" . '<Cell ss:StyleID="1"><Data ss:Type="String">' . $elementSet->item($i)->getAttribute("label") . '</Data></Cell>';
				$difStr[$difIdx++] = "1,0\n\"{$elementSet->item($i)->getAttribute("label")}\"\n";
			}
			//$query .= $form . '.' . $elementSet->item($i)->getAttribute("name") . ', ';

			// Create the SQL query by creating all the joins and grid, file, and URL connections/substitutions

			if (($elementSet->item($i)->getAttribute("type") == 'input') && ($elementSet->item($i)->getAttribute("validate") == 'date')) {
				//$query2 .= formatDateFor('displayExDb', $form.$elementSet->item($i)->getAttribute("name")) . ', ';
				//$dateSeparator = getDateSeparator();
				//if (DATE_FORMAT == 0) {
				//	$formatStr = "%e{$dateSeparator}%m{$dateSeparator}%Y";
				//}
				//elseif (DATE_FORMAT == 1) {
				//	$formatStr = "%m{$dateSeparator}%e{$dateSeparator}%Y";
				//}
				//$query2 .= "date_format({$form}.{$elementSet->item($i)->getAttribute("name")}, '$formatStr'), ";
				$query2 .= "date_format({$form}.{$elementSet->item($i)->getAttribute("name")}, '" . getSQLDateFormatStr() . "'), ";
			}
			elseif ($elementSet->item($i)->getAttribute("type") == 'input' ||
				$elementSet->item($i)->getAttribute("type") == 'textarea' ||
				$elementSet->item($i)->getAttribute("type") == 'password') {
				$query2 .= "{$form}.{$elementSet->item($i)->getAttribute("name")}, ";
			}
			elseif ($elementSet->item($i)->getAttribute("type") == 'url') {
				$query2 .= " '{$gridIdentifierStr}', url.id, url.url_name, ";
				$joinClause .= " left join url on {$form}.id = url.record_id";
			}
			elseif ($elementSet->item($i)->getAttribute("type") == 'file') {
				//$query2 .= "'{$fileIdentifierStr}{$fileNum}', ";
				//$query2 .= "{$form}.{$elementSet->item($i)->getAttribute("name")}, ";
				$query2 .= " '{$gridIdentifierStr}', file.id, file.file_name, ";
				$joinClause .= " left join file on {$form}.id = file.record_id";
				$fieldCount[$gridCount] = 1;
				$gridCount++;
				//$tmp = $i + 1;
				//$filesExistAt .= "{$tmp},";
				//$fileNum++;
				$fieldCount[$gridCount] = 1;
				$gridCount++;
			}
			elseif ($elementSet->item($i)->getAttribute("type") == 'checkbox') {
				$query2 .= "case when {$form}.{$elementSet->item($i)->getAttribute("name")} = 1 then 'Y' else 'N' end, ";
			}
			elseif ($aggregateOn && $elementSet->item($i)->getAttribute("type") == "grid") {
			}
			elseif ($elementSet->item($i)->getAttribute("type") == "grid") {
				$source = $elementSet->item($i)->getAttribute("source");
				$query2 .= "'{$gridIdentifierStr}', {$source}.id, ";
				// If it's a lookup, it needs to get the value!!!! 
				$filterColumn = $elementSet->item($i)->getAttribute("filterColumn");
				$joinClause .= " left join $source on {$form}.id = {$source}.{$filterColumn}";
				//$joinClause .= " left join (select * from $source where $form = $source.$filterColumn limit 1) $source on {$form}.id = {$source}.{$filterColumn}";
				$xpath = new DOMXPath($configXmlDoc);
				$xpQuery = "/doc/form/element[@name='{$elementSet->item($i)->getAttribute("name")}']/field";
				$fieldTree = $xpath->query($xpQuery);
				$fieldCount[$gridCount] = $fieldTree->length;
				$gridXmlDoc[$gridCount] = new DOMDocument();
				getConfigData($gridXmlDoc[$gridCount],"{$elementSet->item($i)->getAttribute("source")}.xml",4, $linki);
				$xpath = new DOMXPath($gridXmlDoc[$gridCount]);
				$xpQuery = '/doc/form/element[@filterByUser="y"]';
				$dataset = $xpath->query($xpQuery);
				$filterByUser = $dataset->length;
				$gridElementSet = $gridXmlDoc[$gridCount]->getElementsByTagName("element");
				$xpath = new DOMXPath($configXmlDoc);
				$fieldTreeAttributes = array();
				$gridLabelList = '[';
				$exportLabelList = '';
				$tmpStr = $exportStr[$snapshotExportIdx];
				$exportStr[$snapshotExportIdx] = '';;
				for ($j = 0; $j < $fieldTree->length; $j++) {
					$fieldTreeAttributes[$j]["type"] = 'type=none';
					for ($k = 0; $k < $gridElementSet->length; $k++) {
						if ($gridElementSet->item($k)->getAttribute("name") == $fieldTree->item($j)->getAttribute("name")) {
							$fieldTreeAttributes[$j] = array();
							$fieldTreeAttributes[$j]["validate"] = $gridElementSet->item($k)->getAttribute("validate");
							$fieldTreeAttributes[$j]["maxSize"] = $fieldTree->item($j)->getAttribute("maxSize");
							$fieldTreeAttributes[$j]["label"] = $gridElementSet->item($k)->getAttribute("label");
							if ($gridElementSet->item($k)->getAttribute("filterByUser") == 'y') {
								// TODO replace `user' x 2 in next line with filterColumn from grid definition
								//$filterTableCondition = " inner join {$source} $gridIdentifierStr on user.id = {$gridIdentifierStr}.user where {$gridIdentifierStr}.{$gridElementSet->item($k)->getAttribute("name")} in (select {$gridElementSet->item($k)->getAttribute("name")} from {$gridElementSet->item($k)->getAttribute("name")}_user where user = {$user->userId})";
								$filterTableCondition = " where {$gridElementSet->item($k)->getAttribute("name")}.id in (select {$gridElementSet->item($k)->getAttribute("name")} from {$gridElementSet->item($k)->getAttribute("name")}_user where user = {$user->userId})";
							}
							$gridLabelList .= $fieldTreeAttributes[$j]["label"] . ' | ';
							$exportStr[$snapshotExportIdx] .=  $tmpStr . ': ' . $fieldTreeAttributes[$j]["label"] . '</Data></Cell>';
							$fieldTreeAttributes[$j]["type"] = $gridElementSet->item($k)->getAttribute("type");
							$fieldTreeAttributes[$j]["name"] = $gridElementSet->item($k)->getAttribute("name");
							if ($gridElementSet->item($k)->getAttribute("type") == "select" || $gridElementSet->item($k)->getAttribute("type") == "radio") {
								$fieldTreeAttributes[$j]["display"] = $gridElementSet->item($k)->getAttribute("display");
								$fieldTreeAttributes[$j]["source"] = $gridElementSet->item($k)->getAttribute("source");
							}
						}
					}
				}
				$gridLabelList = substr($gridLabelList, 0, strlen($gridLabelList) - 2);
				$gridLabelList .= ']';
				$gridLabelList = str_replace(' ', '_', $gridLabelList);
				$gridLabelList = str_replace('_]', ']', $gridLabelList);
				//$_SESSION['debugMsg'] .= logIt($linki, "$gridLabelList");
				$xmlStr[$snapshotIdx] = str_replace("$gridIdentifierStr$gridNum", $gridLabelList, $xmlStr[$snapshotIdx]);
				$difStr[$snapshotDifIdx] = str_replace("$gridIdentifierStr$gridNum", $gridLabelList, $difStr[$snapshotDifIdx]);
				//$exportStr[$snapshotExportIdx] .= $exportLabelList;
				
				$gridTempTableCount = 0;
				for ($j = 0; $j < $fieldTree->length; $j++) {
					if ($fieldTreeAttributes[$j]["type"] == 'select' || $fieldTreeAttributes[$j]["type"] == 'radio') { 
						if (strpos($fieldTreeAttributes[$j]["source"], ',') > -1) {
							$options = explode(',', $fieldTreeAttributes[$j]["source"]);
							$query3 = "create temporary table if not exists grid_join{$gridTempTableCount} (id int, data varchar(100))";
							//mysqli_query($query3) or die(mysqli_error($linki) . " [ERR051 - $query3 ]");
							mysqli_query($linki, $query3) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR051 - ' . $query3 . ']'));
							$query3 = "insert into grid_join{$gridTempTableCount} values ";
							for ($k = 1; $k <= count($options); $k++) {
								$query3 .= '(' . $k . ', \'' . $options[$k - 1] . '\'), ';
							}
							$query3 = substr($query3, 0, strlen($query3) - 2);
							mysqli_query($linki, $query3) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR052 - ' . $query3 . ']'));
							$query2 .= " grid_join{$gridTempTableCount}.data, ";
							$joinClause .= " left join grid_join{$gridTempTableCount} on {$source}.{$fieldTreeAttributes[$j]['name']} = grid_join{$gridTempTableCount}.id";
							$gridTempTableCount++;
						}
						else {
							$query2 .= " grid_{$fieldTreeAttributes[$j]["source"]}{$gridRefTableCount}.{$fieldTreeAttributes[$j]["display"]}, ";
							$joinClause .= " left join {$fieldTreeAttributes[$j]['source']} grid_{$fieldTreeAttributes[$j]['source']}{$gridRefTableCount} on {$source}.{$fieldTreeAttributes[$j]['name']} = grid_{$fieldTreeAttributes[$j]['source']}{$gridRefTableCount}.id";
							$gridRefTableCount++;
						}
					}	
					elseif ($fieldTreeAttributes[$j]["type"] == 'checkbox') { 
						$query2 .= " case when {$source}.{$fieldTreeAttributes[$j]["name"]} = 1 then 'Y' else 'N' end, ";
					}
					else {
						if ($fieldTreeAttributes[$j]["validate"] == 'date') {
							//$query2 .= "date_format({$form}.{$elementSet->item($i)->getAttribute("name")}, '" . getSQLDateFormatStr() . "'), ";
							$query2 .= " DATE_FORMAT({$source}.{$fieldTreeAttributes[$j]["name"]}, '" . getSQLDateFormatStr() . "'), ";
						}
						else {
							$query2 .= " {$source}.{$fieldTreeAttributes[$j]["name"]}, ";
						}
					}
				}
				$gridCount++;
			}
			elseif ($elementSet->item($i)->getAttribute("type") == 'select' ||
				$elementSet->item($i)->getAttribute("type") == 'radio') {
					if ($elementSet->item($i)->getAttribute("filterByUser") == 'y') {
						$criteria .= " and {$elementSet->item($i)->getAttribute("name")} in (select {$elementSet->item($i)->getAttribute("name")} from {$elementSet->item($i)->getAttribute("name")}_user where user = {$user->userId})";
					}
				$query2 .= " join{$i}.";
				$options = array();

				// If there is a foreign key to a comma-separated list, the query needs to join to it,
				// so requires a temporary table
	
				if (strpos($elementSet->item($i)->getAttribute("source"), ',') > -1) {
					$options = explode(',', $elementSet->item($i)->getAttribute("source"));
					// TODO drop table first?
					$query3 = "create temporary table if not exists join{$i} (id int, data varchar(100))";
					mysqli_query($linki, $query3) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR101 - ' . $query3 . ']'));
					$query3 = "insert into join{$i} values ";
					for ($j = 1; $j <= count($options); $j++) {
						$query3 .= '(' . $j . ', \'' . $options[$j - 1] . '\'), ';
					}
					$query3 = substr($query3, 0, strlen($query3) - 2);
					mysqli_query($linki, $query3) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR094 - ' . $query3 . ']'));
					$query2 .= 'data, ';
					$joinClause .= " left join join{$i} on {$form}." . $elementSet->item($i)->getAttribute("name") . " = join{$i}.id";
				}
				else {
					$query2 .= $elementSet->item($i)->getAttribute("display") . ', ';
					$joinClause .= ' left join ' .  $elementSet->item($i)->getAttribute("source") . " join$i on {$form}." . $elementSet->item($i)->getAttribute("name") . " = join{$i}.id";
				}
			}
			$gridNum++;
			} //  end of checking if permission == 'h'
		} // end of looping through elementSet

		$query2 = substr($query2, 0, strlen($query2) - 2);
		$query2 .= " from $form $joinClause $filterTableCondition $criteria"; 
		if ($reportAction == 'print_selected' && isset($_POST['bulk_selected']) && strlen($_POST['bulk_selected']) > 0) {
			$query2 .= " and {$form}.id in ({$_POST['bulk_selected']})";
		}
		//$query = substr($query, 0, strlen($query) - 2);
		$xmlStr[$xmlStrIdx++] = "\n\t\t\t</tr>";
		$exportStr[$exportIdx++] = "\n</Row>";
		//$query .= " from $form $filterTableCondition $selectCriteria";
		if (strlen(trim($filteredOptions)) > 0) {
			//$query .= " and $filteredOptions";
			$query2 .= " AND $filteredOptions";
		}
		// query needs to be ordered to faciliate the grid grouping
	
		if ($gridCount > 0 && $aggregateOn) {
			$query2 .= $orderCriteria;
		}
		elseif($gridCount > 0) {
			$query2 .= " order by {$form}.id";
		}
		else {
			$query2 .= $orderCriteria;
		}
		//$query2 .= " order by {$form}.fullname";

		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Report query: " . mysqli_real_escape_string($linki, $query2) . '     ' . $_SESSION['debug']);
		//echo $query2 . "\n\n\n"; exit;
		//$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR015 - $query ] "));
		$rowCount = 0;
		if ($aggregateOn) {
			$newValue = '';
			$oldValue = '';
			$subTotal = array();
			$oldSubTotal = array();
			$grandTotal = array();
			$grandTotalCount = array();
			$countTotal = array();
			$oldCountTotal = array();
			$noGridCount = 0;
			for ($i = 0; $i < $elementSet->length; $i++) {
				if ($elementSet->item($i)->getAttribute("type") != 'grid') {
					$subTotal[$noGridCount] = 0;
					$oldSubTotal[$noGridCount] = 0;
					$grandTotal[$noGridCount] = 0;
					$grandTotalCount[$noGridCount] = 0;
					$countTotal[$noGridCount] = 0;
					$oldCountTotal[$noGridCount] = 0;
					$noGridCount++;
				}
			}
			while (strlen($aggregateFunctions) < $noGridCount) {
				$aggregateFunctions .= '-';
			//	echo strlen($aggregateFunctions);
			}
		}
		//echo "\n" . $noGridCount . '|' . $aggregateFunctions[4]; exit;
		//if ($reportAction == 'nofilter' and $selectCriteria != ' and 694=694' and $selectCriteria != ' and 693=693' and $selectCriteria != ' and 692=692') OPENBRACE
		//if ($reportAction == 'filter') 
		//echo $query2; exit;
			$filteredResult = mysqli_query($linki, $query2) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR095 - ' . $query2 . ']'));
			if (mysqli_num_rows($filteredResult) == 0) $noResult = true; else $noResult = false;
			$totalRecordCount = 0;
			$prevRowId = 0;
			$currentRow = '';
			$previousRow = '';
			$difCurrentRow = '';
			$difPreviousRow = '';
			while ($row = mysqli_fetch_row($filteredResult)) {
				// output every single row for the export
				$elementNum = 1;
				$exportStr[$exportIdx++] = "\n<Row>";
				while ($elementNum < mysqli_num_fields($filteredResult)) {
					// skip past the gridIdentifier and the grid id to the first displayable grid value
					if ($gridIdentifierStr == htmlspecialchars($row[$elementNum])) {
						$elementNum+=2;
					}
					$exportStr[$exportIdx++] = "\n\t<Cell><Data ss:Type=\"String\">" . htmlspecialchars($row[$elementNum++]) . "</Data></Cell>";
				}
				$exportStr[$exportIdx++] = "\n</Row>";
				$rowId = $row[0];
				if ($rowId == $prevRowId) {
					// If the current row is the same as the previous, don't do very much
					$match = true;
				}
				else {
					// This is the exit point when the row id changes; it inserts any grid information for all rows but the last,
					// which is done at last_row_processing . I should TODO be able to replace this hack with num_rows
					$match = false; 
					if ($prevRowId != 0) {
						for ($i = 0; $i < $gridCount; $i++) {
							$tmp = $gridStore[$i]->toString();
							$previousRow = str_replace("$gridIdentifierStr$i", "<table>{$tmp}</table>", $previousRow);
							$tmp = str_replace('<tr>', '[', $tmp);
							$tmp = str_replace('</tr>', ']', $tmp);
							$tmp = str_replace('<td>', '', $tmp);
							$tmp = str_replace('</td>', " | ", $tmp); 
							$tmp = str_replace(' | ]', "]", $tmp); 
							$tmp = str_replace('[]', "", $tmp); 

							$difPreviousRow = str_replace("$gridIdentifierStr$i", $tmp, $difPreviousRow);
							//$difPreviousRow = str_replace('<tr>', '', $previousRow);
							//$difPreviousRow = str_replace('</tr>', '', $difPreviousRow);

						}
						$xmlStr[$xmlStrIdx++] = $previousRow;
						$difStr[$difIdx++] = $difPreviousRow;
						// insertion here enters something after each row except the last
						// $xmlStr[$xmlStrIdx++] = '<tr><td>$previousRow</td></tr>';
						$totalRecordCount++;
						if ($aggregateOn) {
							$xmlStr[$xmlStrIdx] = '';
							$insertSummaryRowAt = $xmlStrIdx++;
						}
					}
				}
				//$rowMod = $rowCount++ % 2;
				$rowMod = $totalRecordCount % 2;
				$currentRow = "\n\t\t\t<tr>";
				//$difCurrentRow = "BOT\n1,0\n";
				$difCurrentRow = "-1,0\nBOT\n";
				if ($reportAction != 'print_all' && $reportAction != 'print_selected') {
					$currentRow .= "\n\t\t\t\t<td><checkbox name='bulk_select' id='$row[0]' /></td>";
					$currentRow .= "\n\t\t\t\t<td style=\"bg{$rowMod}\"><formButton xml='{$xml}' xsl='" . XSL_TEMPLATE . "' id='{$rowId}' /></td>";
					// TODO up to here: need to strip out all the unnecesaary chars
				}
				$gridNum = 0;
				$elementNum = 1;
				$fieldNum = 1;
				$aggFuncIdx = 0;
				while ($elementNum < $elementSet->length + 1 - $hiddenOffset) {
					// TODO next line (the element num up to the max (4 here)) can be manipulated to show a column selection
					//while ($elementNum < 4 + 1 - $hiddenOffset) {
					//if ($aggregateFunctions[$aggFuncIdx] != '-') $_SESSION['debugMsg'] .= logIt($linki, 'Elementnum: ' . $elementNum . '|' . $elementSet->item($aggFuncIdx)->getAttribute("name") . '|' . $aggregateFunctions[$aggFuncIdx]);
					if ($aggregateOn) {
						if ($elementSet->item($aggFuncIdx)->getAttribute("name") == $aggregateOn) {
							$newValue = $row[$elementNum];
							//$_SESSION['debugMsg'] .= logIt($linki, 'Aggregate - newValue: ' . $newValue);
						}
						if ($aggregateFunctions[$aggFuncIdx] == 's' && ($elementSet->item($aggFuncIdx)->getAttribute("validate") == 'integer' || $elementSet->item($aggFuncIdx)->getAttribute("validate") == 'decimal')) {
							$oldSubTotal[$aggFuncIdx] = $subTotal[$aggFuncIdx];
							$subTotal[$aggFuncIdx] += $row[$elementNum];
							$grandTotal[$aggFuncIdx] += $row[$elementNum];
			//				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'Aggregate - oldSub:newSub: ' . $elementNum . " - " . $oldSubTotal[$elementNum] . ":" . $subTotal[$elementNum]);
						}
						elseif ($aggregateFunctions[$aggFuncIdx] == 'c') {
							$oldSubTotal[$aggFuncIdx] = $subTotal[$aggFuncIdx];
							$subTotal[$aggFuncIdx]++;
							$grandTotal[$aggFuncIdx]++;
							//$_SESSION['debugMsg'] .= logIt($linki, 'grand total: ' . $subTotal[$aggFuncIdx]);
						}
						if ($aggregateFunctions[$aggFuncIdx] == 'a' && ($elementSet->item($aggFuncIdx)->getAttribute("validate") == 'integer' || $elementSet->item($aggFuncIdx)->getAttribute("validate") == 'decimal')) {
							$oldSubTotal[$aggFuncIdx] = $subTotal[$aggFuncIdx];
							$oldCountTotal[$aggFuncIdx] = $countTotal[$aggFuncIdx];
							$subTotal[$aggFuncIdx] += $row[$elementNum];
							$countTotal[$aggFuncIdx]++;
							$grandTotalCount[$aggFuncIdx]++;
							$grandTotal[$aggFuncIdx] += $row[$elementNum];
						}
					}
					// TODO see if $fieldNum++ can go here
					if ($gridIdentifierStr == htmlspecialchars($row[$fieldNum])) {

						//      write_grid_value

						$currentRow .= "\n\t\t\t\t<td style=\"bg{$rowMod}\">";
						$fieldNum++;
						$gridRowId = $row[$fieldNum++];
						//echo $gridRowId;
						if (!$match) {
							$gridStore[$gridNum] = new GridStore($fieldCount[$gridNum]);
						}
						// next line inserts the unique value to be replaced with the array contents
						
						for ($j = 0; $j < $fieldCount[$gridNum]; $j++) {
							$gridStore[$gridNum]->addGridRowId("{$gridRowId}_{$j}");
							$gridStore[$gridNum]->addText('<td>' . htmlspecialchars($row[$fieldNum++]) . '</td>');
						}
						$currentRow .= $gridIdentifierStr . $gridNum;
						$difCurrentRow .= "1,0\n\"$gridIdentifierStr$gridNum\"\n";
						$currentRow .= "\n\t\t\t\t</td>";
						$gridNum++;
						//echo '..' . $fieldNum . '=' . $row[$fieldNum];
					}
					else {
						$currentRow .= "\n\t\t\t\t<td style=\"bg{$rowMod}\">" . htmlspecialchars($row[$fieldNum]) . '</td>';
						$difCurrentRow .= "1,0\n\"" . htmlspecialchars($row[$fieldNum]) . "\"\n";
						$fieldNum++;
					}
					$elementNum++;
					$aggFuncIdx++;
				}
				$currentRow .= "\n\t\t\t</tr>";
				$previousRow = $currentRow;
				$difPreviousRow = $difCurrentRow;
				$prevRowId = $rowId;
			if ($aggregateOn) {
				if ($oldValue != $newValue && $oldValue != '') {
					$xmlStr[$insertSummaryRowAt] = buildSummaryRow('sub', $reportAction, $noGridCount, $aggregateFunctions, $subTotal, $oldSubTotal, $countTotal, $oldCountTotal, $grandTotal, $grandTotalCount);
					for ($j = 0; $j < $noGridCount; $j++) {
						if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "function: $aggregateFunctions j: $j subTotal: $subTotal[$j] countTotal: $countTotal[$j] grandTotal: $grandTotal[$j] grantTotalCount: $grandTotalCount[$j] ");
						$subTotal[$j] -= $oldSubTotal[$j];
						$countTotal[$j] -= $oldCountTotal[$j];
					}
					/*
					$xmlStr[$insertSummaryRowAt] = "\n\t\t\t<tr>\n\t\t\t\t<td style=\"bg0\"></td>\n\t\t\t\t<td style=\"bg0\"></td>";
					for ($j = 0; $j < $noGridCount; $j++) {
						if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "function: $aggregateFunctions j: $j subTotal: $subTotal[$j] countTotal: $countTotal[$j] grandTotal: $grandTotal[$j] grantTotalCount: $grandTotalCount[$j] ");

						if ($aggregateFunctions[$j] == 's') $xmlStr[$insertSummaryRowAt] .= "\n\t\t\t<td style=\"bg3\">" . SUM_PREFIX . $oldSubTotal[$j] . "</td>";
						elseif ($aggregateFunctions[$j] == 'c') $xmlStr[$insertSummaryRowAt] .= "\n\t\t\t<td style=\"bg3\">" . COUNT_PREFIX . $oldSubTotal[$j] . "</td>";
						elseif ($aggregateFunctions[$j] == 'a') {
							$tmp = $oldSubTotal[$j] / $oldCountTotal[$j];
							$xmlStr[$insertSummaryRowAt] .= "\n\t\t\t<td style=\"bg3\">" . AVERAGE_PREFIX . $tmp . "</td>";
						}
						else $xmlStr[$insertSummaryRowAt] .= "\n\t\t\t<td style=\"bg0\"></td>";
						$subTotal[$j] -= $oldSubTotal[$j];
						$countTotal[$j] -= $oldCountTotal[$j];
					}
					$xmlStr[$insertSummaryRowAt] .= "\n\t\t\t</tr>";
					 */
				}
				$oldValue = $newValue;
			}
			} // end of while loop fetching row data 

			// get the data from the last row (last_row_processing)
			if (mysqli_num_rows($filteredResult) > 0) {
				for ($i = 0; $i < $gridCount; $i++) {
					$tmp = $gridStore[$i]->toString();
					$currentRow = str_replace($gridIdentifierStr . $i, '<table>' . $tmp . '</table>', $currentRow);
					$tmp = str_replace('<tr>', '[', $tmp);
					$tmp = str_replace('</tr>', ']', $tmp);
					$tmp = str_replace('<td>', '', $tmp);
					$tmp = str_replace('</td>', " | ", $tmp); 
					$tmp = str_replace(' | ]', "]", $tmp); 
					$tmp = str_replace('[]', "", $tmp); 
					$difCurrentRow = str_replace($gridIdentifierStr . $i, $tmp, $difCurrentRow);
				}
			}
			$xmlStr[$xmlStrIdx++] = $currentRow;
			$difStr[$difIdx++] = $difCurrentRow;
			// insertion here enters something after the last row
			// $xmlStr[$xmlStrIdx++] = '<tr><td>lastRow</td></tr>';
			if (!$noResult) $totalRecordCount++;
		if ($aggregateOn) {
			$xmlStr[$xmlStrIdx++] = buildSummaryRow('lastSub', $reportAction, $noGridCount, $aggregateFunctions, $subTotal, $oldSubTotal, $countTotal, $oldCountTotal, $grandTotal, $grandTotalCount);
			$xmlStr[$xmlStrIdx++] = buildSummaryRow('grand', $reportAction, $noGridCount, $aggregateFunctions, $subTotal, $oldSubTotal, $countTotal, $oldCountTotal, $grandTotal, $grandTotalCount);
		}
// {{{ // SPECIAL REPORTS
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//
//    SPECIAL_REPORTS
//
//    Create a report which can run the SQL, set up the column names and the column number
//    This should be automated eventually
//    
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
		
		//else if ($reportAction == 'filter' and $selectCriteria == ' and 694=694') {

		//	include 'specialReport_1.php';
		//}
		//else if ($reportAction == 'filter' and $selectCriteria == ' and 692=692') {

		//	include 'specialReport_2.php';

		//}
			//		}}}
		$xmlStr[$xmlStrIdx++] = "\n\t\t</table>\n";
		//$difStr[$difIdx++] = "\n\t\t</table>\n";
		$difStr[$difSnapshot] = "0,$totalRecordCount\n";
		$xmlStr[$recordCountIndex] = "\n\t\t<table name='Report' recordCount='$totalRecordCount'>\n\t\t\t<tr>";
		
		if ($reportAction != 'print_all' && $reportAction != 'print_selected') {
			$xmlStr[$recordCountIndex] .= "\n\t\t\t\t<th><img src='images/tick.png'/></th>\n\t\t\t\t<th>GO</th>";
		}
		$exportStr[$exportIdx++] = "\n</Table>";
		
	}
	else if ($reportAction == 'update') {
		$updateQuery = "update $form set ";
		$updateFieldsAndValues = '';
		for ($i = 0; $i < $elementSet->length; $i++) {
			// TODO ensure that every type of element possible in a report is in this list; otherwise it will never update
			// remember how you searched for the solution to the radio option being missing?
			if ($elementSet->item($i)->getAttribute("type")=="select" || $elementSet->item($i)->getAttribute("type")=="checkbox" || $elementSet->item($i)->getAttribute("type")=="radio" || $elementSet->item($i)->getAttribute("type")=="input") {
				$tmpStr = $elementSet->item($i)->getAttribute("name") . '_from';
				if (isset($_POST[$elementSet->item($i)->getAttribute("name")]) || isset($_POST[$tmpStr])) {
					$postedValue = (isset($_POST[$tmpStr])) ? formatDateFor('databaseExPost', $_POST[$tmpStr]) : $_POST[$elementSet->item($i)->getAttribute("name")];
					if ($postedValue > -1 and strlen($postedValue) > 0) {
						$updateFieldsAndValues .= "{$elementSet->item($i)->getAttribute("name")} = '$postedValue', ";
					}
				}
			}
		}
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'Bulk selected:' . $_POST['bulk_selected']);
		if (isset($_POST['bulk_selected']) && strlen($_POST['bulk_selected']) > 0) {
			$bulkSelectedIDs = $_POST['bulk_selected'];
		}
		else {
			$bulkSelectedIDs = '';
		}
		if ($updateFieldsAndValues && $bulkSelectedIDs) {
			$updateFieldsAndValues = substr($updateFieldsAndValues, 0, strlen($updateFieldsAndValues) - 2);
			$updateQuery .= $updateFieldsAndValues;
			$updateIDs = " where id in (";
			$idsFound = 0;
			if (strlen($bulkSelectedIDs) > 0) { 
				$idsFound = count(explode(',', $bulkSelectedIDs));
				$updateIDs .= $bulkSelectedIDs;
			}
			if ($idsFound > 0) {
				$updateQuery .= $updateIDs . ')';
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'Bulk update query:' . $updateQuery);
				mysqli_query($linki, $updateQuery) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR017 - ' . $updateQuery . ']'));
		// TODO put this into messages
				$successMsg = "<msg>$idsFound {$messageArr[16]}</msg>";
				//$successMsg = "<msg>$idsFound record(s) updated.</msg>";
			}
		}
		else {
		// TODO put this into messages
			$errorMsg = "<msg>{$messageArr[17]}</msg>";
			//$errorMsg = "<msg>No records have been updated, because no selections were made and/or no criteria was set.</msg>";
		}

	}


	$xmlStr[$xmlStrIdx++] = "\n\t<script>document.getElementById('busy').style.display = 'none';</script>";
	$xmlStr[$xmlStrIdx++] = "\n\t</reportForm>";
	if ($reportAction == 'print_all' || $reportAction == 'print_selected') {
		// TODO 2498 pabulumba is hard=coded here at the xsl: fix!
		$xmlStr[$xmlStrIdx++] = "\n\t<switches>\n\t\t<switch navigation=\"none|-\" xml=\"{$form}\" xsl=\"pabulumba\" printXsl=\"$printXsl\" action=\"report\" permission=\"whhhhhhhhh\">$title</switch>\n\t</switches>";
	}
	$exportStr[$exportIdx++] = "\n</Worksheet>\n</Workbook>";
	$difStr[$difIdx++] = "-1,0\nEOD\n";
	$xmlStr[$xmlStrIdx++] = "\n\t<successMessages>{$successMsg}</successMessages>\n\t<errorMessages>{$errorMsg}</errorMessages>";
	if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'Table has now been created into the xmlStr');
	if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'New method:' . $query2);
	// TODO the above phrase needs to replace the original standard report method at some stage :-(
	// It needs to aggregate, and filterByUser, as well as work properly!
	$xmlStr[$xmlStrIdx++] = "\n\t<information>\n\t\t<info name=\"userName\">{$user->userFullName}</info>";
	$xmlStr[$xmlStrIdx++] = "\n\t\t<info name=\"userRole\">{$user->userRoleRefNo}</info>";
	$xmlStr[$xmlStrIdx++] = "\n\t</information>";
	$xmlStr[$xmlStrIdx++] = "\n\t<debugMessages>{$_SESSION['debugMsg']}</debugMessages>";
	$xmlStr[$xmlStrIdx++] = "\n</doc>";
	if (USER_LOGGING) {
		//$logInsertQuery = "insert into log (action_time, user, form_name, record_id, action_id, deleted) values (now(), $user->userId, '$form', null, " . REPORT . ", 0)";
		$logInsertQuery = "insert into log (action_time, user, form_name, record_id, action_id, deleted) values (now(), $user->userId, '$xml', null, " . REPORT . ", 0)";
		mysqli_query($linki, $logInsertQuery) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR078 - ' . $logInsertQuery . ']'));
	}
	if ($reportAction == 'export') {
		if ($fileType == 'dif') {
			header("Content-type: text/plain");
			header("Content-Disposition: attachment; filename='{$form}.dif'");
			for ($i = 0; $i < $difIdx; $i++) echo $difStr[$i];
		}
		elseif ($fileType == 'xls') {
			header("Content-type: application/vnd.ms-excel");
			header("Content-Disposition: attachment; filename='{$form}.xls'");
			for ($i = 0; $i < $exportIdx; $i++) echo $exportStr[$i];
		}
		//header("Content-type: application/vnd.ms-excel");
	}
	// TODO don't think next elseif is necessary
	elseif ($reportAction == 'print_all' || $reportAction == 'print_selected') {
		header("Content-type: application/xml");
		for ($i = 0; $i < $xmlStrIdx; $i++) echo $xmlStr[$i];
	}
	else {
		header("Content-type: application/xml");
		for ($i = 0; $i < $xmlStrIdx; $i++) echo $xmlStr[$i];
	}
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//
//  CUSTOM_REPORTS
//
//
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

elseif ($action == 'customReport') {




	$totalRecordCount = 0;
	if (isset($_POST['reportId'])) $reportId = $_POST['reportId'];
	else $reportId = '0';
	if (isset($_POST['reportAction'])) $reportAction = $_POST['reportAction'];
	else $reportAction = 'none';
	if (isset($_POST['selectCriteria'])) $selectCriteria = $_POST['selectCriteria'];
	else $selectCriteria = '';
	if (isset($_POST['orderCriteria'])) $orderCriteria = $_POST['orderCriteria'];
	else $orderCriteria = '';
	if (isset($_POST['xsl'])) $xsl = $_POST['xsl'];
	else $xsl = '';
	$query = "select report_title, sql_text, target_table from custom_report where id = {$_POST['reportId']}";
	$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR049 - $query ] "));
	$row = mysqli_fetch_row($result);
	$reportTitle = $row[0];
	$exportStr = array();
	$exportIdx = 0;
	$exportStr[$exportIdx++] = '<?xml version="1.0" encoding="UTF-8"?><?mso-application progid="Excel.Sheet"?>
		<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet"
		xmlns:x="urn:schemas-microsoft-com:office:excel"
 		xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet"
 		xmlns:html="http://www.w3.org/TR/REC-html40">
		<ss:Styles>
    		<ss:Style ss:ID="1">
    	    	<ss:Font ss:Color="#009966" ss:Bold="1"/>
				<ss:Interior ss:Color="#cbf9cb" ss:Pattern="Solid"/>
    		</ss:Style>
		</ss:Styles>
		<Worksheet ss:Name="' . $reportTitle . '"><Table>';
	$sqlText = $row[1];
	$targetTable = $row[2];
	// if there is any content in the 'Target table' column, modify the sql query so it retrieves the id of
	// the targetTable as well as existing SQL
	if (strlen($targetTable) > 0) {
		// the possible combinations here are:
		//    select * from table
		//    `         select          *          from table'
		//    select table.*
		//    select table.id
		//    select id
		// unlike perl, the ungreedy operator is a `?'
		if (preg_match('/^\s*select\s*\*/i', $sqlText)) {
			// TODO state in the manual that you can't use '*' where there are mulitple tables; they need to be specified
			// because I can't guarnatee a join on a derived table  will be there (i.e. select * from log where id )
			// There also must be a way I can run the regexp as a single expression, but how???
			$matches = array();
			preg_match_all('/join\s?\(.*\)\s?(\w*)\s/', $sqlText, $matches);
			//preg_match_all('/join\s?(\w*)\s/', $sqlText, $matches);
			//preg_match_all('/join\s?(\w*)\s|join\s?\(.*\)\s?(\w*)\s/', $sqlText, $matches);
			$i = 0;
			$tmp = '';
			while ($i < sizeof($matches[1])) {
				//$_SESSION['debugMsg'] .= logIt($linki, 'matches: ' . $matches[1][$i]);
				$tmp .= ', ' . $matches[1][$i] . '.* ';
				$i++;
			}
			preg_match_all('/join\s{1,}?(\w*)\s/', $sqlText, $matches);
			//preg_match_all('/join\s*?\(.*?\)\s*?(\w*)\s/', $sqlText, $matches);
			$i = 0;
			//$tmp .= '|';
			while ($i < sizeof($matches[1])) {
				//$_SESSION['debugMsg'] .= logIt($linki, 'matches: ' . $matches[1][$i++]);
				$tmp .= ', ' . $matches[1][$i++] . '.* ';
			}
			$sqlText = preg_replace('/^\s*?select\s*?\*/i', "SELECT {$targetTable}.id, {$targetTable}.* $tmp", $sqlText);
			//$sqlText = preg_replace('/^\s*?select\s*?\*/i', "SELECT {$targetTable}.id, {$targetTable}.* ", $sqlText);
		}
		else {
			$sqlText = preg_replace('/^\s*?select\s*?/i', "SELECT {$targetTable}.id, ", $sqlText);
		}
		//$_SESSION['debugMsg'] .= logIt($linki, 'sqlText:' . $tmp);
	}
	$sqlText = preg_replace('/\[CURRENT_USER_ID\]/', $userId, $sqlText);

	$recordsProcessed = 0;
	// if there are any semi-colons, this probably indicates statements to be run
	if (strpos($sqlText, ';') > 0) {
		$sqlText = preg_replace('/\\n/', '', $sqlText);
		$sqlText = preg_replace('/;\s*$/', '', $sqlText);
		$sqlTextArr = explode(';', $sqlText);
		$numSqlStatements = count($sqlTextArr);
		$numSqlStatementCounter = 0;
		while ($numSqlStatementCounter < $numSqlStatements) {
			if (strpos(strtolower(substr($sqlTextArr[$numSqlStatementCounter], 0, 20)), 'insert into') > -1) {
				$result = mysqli_query($linki, $sqlTextArr[$numSqlStatementCounter]) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR064 - $query ] "));
				$recordsProcessed++;
			}
			$numSqlStatementCounter++;
		}
	}
	else {
		$result = mysqli_query($linki, $sqlText) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR050 - $sqlText ] "));
	}

	// necessary to identify what type of variable is returned because INSERT statements may be used in the custom report fields
	
	if (gettype($result) == 'boolean') {
		$numCols = 0;
		$totalRecordCount = $recordsProcessed;
	}
	else {
		$numCols = mysqli_num_fields($result);
		$totalRecordCount = mysqli_num_rows($result);
	}
	$xmlStr = array();
	$xmlStrIdx = 0;
	$xmlStr[$xmlStrIdx++] = '<?xml version="1.0" encoding="UTF-8"?><?xml-stylesheet href="config/' . $xsl . '.xsl" type="text/xsl" ?>';
	$xmlStr[$xmlStrIdx++] = "\n<doc>\n\t<switches>\n\t\t<switch navigation=\"none|-\" xml=\"main\" xsl=\"" . XSL_TEMPLATE . "\" selectCriteria=\"\" permission=\"wwwr\">Return to Main</switch>\n\t\t<switch navigation=\"none|-\" xml=\"reports\" xsl=\"" . XSL_TEMPLATE . "\" selectCriteria=\"\" permission=\"wwwr\">Return to Reports</switch>\n\t</switches>\n\t<information>\n\t\t<info name=\"userName\">{$user->userFullName}</info>\n\t</information>";
				
	$xmlStr[$xmlStrIdx++] = "\n\t<debugMessages>{$_SESSION['debugMsg']}</debugMessages>";
		
	$xmlStr[$xmlStrIdx++] = "\n\t<page title=\"{$reportTitle}\" />";
	$recordCountIndex = $xmlStrIdx++;
	//$xmlStr[$xmlStrIdx++] = "\n<customReport reportId='$reportId' action='pabulumba.php' method='POST'>\n\t\t<hidden name='reportAction' value='{$reportAction}' />\n\t\t<hidden name='xml' value='reports' />\n\t\t<hidden name='xsl' value='" . XSL_TEMPLATE . "' />\n\t\t<hidden name='action' value='customReport' />\n\t\t<hidden name='prevValues' value='' />\n\t\t<table>\n\t\t\t<tr>";
	$exportStr[$exportIdx++] = '<Row>';
	// if there is any content in the 'Target table' column, insert the heading
	// and set the number of the starting column to display
	if (strlen($targetTable) > 0) {
		$xmlStr[$xmlStrIdx++] = "\n\t\t\t\t<th>-</th>";
		$startCol = 1;
		mysqli_fetch_field($result)->name;
	}
	else {
		$startCol = 0;
	}
	for ($i = $startCol; $i < $numCols; $i++) {
	//for ($i = 0; $i < $numCols; $i++) {
		$tmp = mysqli_fetch_field($result)->name;
		//$_SESSION['debugMsg'] .= logIt($linki, '$tmp:' . "$i __ $tmp");
		$xmlStr[$xmlStrIdx++] = "\n\t\t\t\t<th>$tmp</th>";
		$exportStr[$exportIdx++] = '<Cell ss:StyleID="1"><Data ss:Type="String">' . $tmp . '</Data></Cell>';
	}
	$xmlStr[$xmlStrIdx++] = "\n\t\t\t</tr>";
	$exportStr[$exportIdx++] = "\n</Row>";
	$rowCount = 0;
	// following an INSERT "report", the $result returned will be boolean, so prevent report from crashing by checking for the type of $result
	if (gettype($result) != 'boolean') {
		while ($row = mysqli_fetch_row($result)) {
			$rowMod = $rowCount++ % 2;
			$xmlStr[$xmlStrIdx++] = "\n\t\t\t<tr>";
			$exportStr[$exportIdx++] = '<Row>';
			if (strlen($targetTable) > 0) {
				// TODO make sure that $targetTable is a valid table name
				$xmlStr[$xmlStrIdx++] = "\n\t\t\t\t<td style=\"bg{$rowMod}\"><formButton xml='{$targetTable}' xsl='" . XSL_TEMPLATE . "' id='{$row[0]}' /></td>";
			}
			for ($i = $startCol; $i < $numCols; $i++) {
			//for ($i = 0; $i < $numCols; $i++) {
				$xmlStr[$xmlStrIdx++] = "\n\t\t\t\t<td style=\"bg{$rowMod}\">" . htmlspecialchars($row[$i]) . "</td>";
				$exportStr[$exportIdx++] = '<Cell><Data ss:Type="String">' . htmlspecialchars($row[$i]) . '</Data></Cell>';
			}
			$xmlStr[$xmlStrIdx++] = "\n\t\t\t</tr>";
			$exportStr[$exportIdx++] = '</Row>';
		}
	}
	$xmlStr[$xmlStrIdx++] = "\n</table></customReport>";
	$xmlStr[$xmlStrIdx++] = "\n\t<script>document.getElementById('busy').style.display = 'none';</script>";
	$xmlStr[$xmlStrIdx++] = "\n</doc>";
	$xmlStr[$recordCountIndex] = "\n\t<customReport reportId='$reportId' action='pabulumba.php' method='POST'>\n\t\t<hidden name='reportAction' value='{$reportAction}' />\n\t\t<hidden name='xml' value='reports' />\n\t\t<hidden name='xsl' value='" . XSL_TEMPLATE . "' />\n\t\t<hidden name='action' value='customReport' />\n\t\t<hidden name='prevValues' value='' />\n\t\t<table recordCount='$totalRecordCount'>\n\t\t\t<tr>";
	$exportStr[$exportIdx++] = '</Table></Worksheet></Workbook>';
	if ($reportAction == 'export') {
		header("Content-type: application/vnd.ms-excel");
		for ($i = 0; $i < $exportIdx; $i++) echo $exportStr[$i];
	}
	else {
		header("Content-type: application/xml");
		for ($i = 0; $i < $xmlStrIdx; $i++) echo $xmlStr[$i];
	}

}
elseif ($action=='erd') {
	$xmlStr = array();
	$xmlStrIdx = 0;
	$xmlStr[$xmlStrIdx++] = '<?xml version="1.0" encoding="UTF-8"?><?xml-stylesheet href="config/' . XSL_TEMPLATE . '.xsl" type="text/xsl" ?>';
	$xmlStr[$xmlStrIdx++] = "\n<doc><page title=\"Database entity-relationship diagram\" />";
	$xmlStr[$xmlStrIdx++] = buildMenu($menuItemSet, $user, '', $linki);
	$xmlStr[$xmlStrIdx++] = "\n\t<erd />";
	$xmlStr[$xmlStrIdx++] = "\n\t<information>\n\t\t<info name=\"userName\">{$user->userFullName}</info>\n\t</information>";
	$xmlStr[$xmlStrIdx++] = "\n\t<script>document.getElementById('busy').style.display = 'none';</script>";
	$xmlStr[$xmlStrIdx++] = "\n</doc>";
	header("Content-type: application/xml");
	for ($i = 0; $i < $xmlStrIdx; $i++) echo $xmlStr[$i];
}
//}}}
//{{{ Output - XML display
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//
//    XML_OUTPUT
//
//
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

else {

	// TODO
	//echo sizeof($ruleArr); exit;
	// CREATE THE XML OUTPUT

	if (!(isset($_SESSION['gridIds'][$form]) && strpos($_SESSION['gridIds'][$form], $form) > -1)) {
		$_SESSION['gridIds'] = null;
	}
	if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'CREATING THE XML OUTPUT with a record id of: ' . $navIds->id);
	$xmlStr = array();
	$xmlStrIdx = 0;
	$additionalJS = '';
	$pagePermission = '';
	$gridCount = 0;

	$pagePermission = checkPermission('page', $pagePermission, $user, $configXmlDoc->getElementsByTagName("page")->item(0)->getAttribute("permission"));
	if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'Page permission: ' . $pagePermission . ' XSL: ' . $xsl);
	$xmlStr[$xmlStrIdx++] = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?xml-stylesheet href=\"config/{$xsl}.xsl\" type=\"text/xsl\"?>";
	$xmlStr[$xmlStrIdx++] = "\n<doc>\n\t<page title=\"{$configXmlDoc->getElementsByTagName("page")->item(0)->getAttribute("heading")}\" permission=\"{$pagePermission}\" />";
	$xmlStr[$xmlStrIdx++] = buildMenu($menuItemSet, $user, $pagePermission, $linki);
	if (isset($processParam)) {
		if (strlen($processParam->returnString) > 0) {
		// TODO put this into messages
			$successMsg = '<msg>' . $processParam->returnString . '</msg>';
		}
	}
	$xmlStr[$xmlStrIdx++] = "\n\t<successMessages>{$successMsg}</successMessages>\n\t<errorMessages>{$errorMsg}</errorMessages>";
	if (SHOW_NAV_HISTORY == 2) {
		$xmlStr[$xmlStrIdx++] = "\n\t<navHistory>";
		$query = "select b.record_id, b.form_name from (select log.record_id, log.form_name from log where log.id > (select max(id) from log where action_id = 1 and log.user = $userId) and log.id not in (select id from log where action_id not in (7,8) and log.user = $userId) and log.user = $userId and log.form_name is not null and log.record_id is not null order by log.id desc limit " . MAX_NAV_HISTORY . ") a right join (select log.record_id, log.form_name from log where log.id > (select max(id) from log where action_id = 1 and log.user = $userId) and log.id not in (select id from log where action_id in (7,8) and log.user = $userId) and log.user = $userId and log.form_name is not null and log.record_id is not null order by log.id desc limit " . MAX_NAV_HISTORY . ") b using (record_id, form_name) where a.record_id is null";       
		
		$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR083 - $query ] "));
		$numFields = mysqli_num_fields($result);
		while ($row = mysqli_fetch_row($result)) {
			$navHistXmlDoc = new DOMDocument();
			getConfigData($navHistXmlDoc,"{$row[1]}.xml",5, $linki);
			$xpath = new DOMXPath($navHistXmlDoc);
			$xpQuery = "/doc/page";
			$pageHeading = $xpath->query($xpQuery)->item(0)->getAttribute('heading');
			$targetId = $row[0] != -1 ? "{$row[0]}) " : '';
			$xmlStr[$xmlStrIdx++] = "\n\t\t<nhItem id='{$row[0]}' target='{$row[1]}'>{$targetId} {$pageHeading}</nhItem>";
		}
		$xmlStr[$xmlStrIdx++] = "\n\t</navHistory>";
	}
	if (SHOW_PREVIEW == 2) {
		if ($form != 'dummy') {
			$previewXmlDoc = new DOMDocument();
			// get contents from either doc, db, or memory
			$previewXmlDoc->load("config/{$form}.xml");
			$xpath = new DOMXPath($previewXmlDoc);
			$xpQuery = '/doc/form[1]';
			$nodelist = $xpath->query($xpQuery);
			if ($nodelist->item(0)->getAttribute('previewColumns') != null && $nodelist->item(0)->getAttribute('autoPreview') == 'y') {
				$previewColumns = explode('~', str_replace('[CURRENT_USER_ID]', $userId, $nodelist->item(0)->getAttribute('previewColumns')));
				$xpQuery = '/doc/form/element[@filterByUser="y"]';
				$dataset = $xpath->query($xpQuery);
				$filterByUser = $dataset->length;
				if ($filterByUser > 0) {
					$filterTableName = $dataset->item(0)->getAttribute("name");
					$query = str_replace('\\', '', $previewColumns[0]);
					$query .= " where {$form}.{$filterTableName} in (select $filterTableName from {$filterTableName}_user where user = $userId) $selectCriteria $previewColumns[1] $previewColumns[2]";
				}
				else {
					$query = "$previewColumns[0] where 1=1 $selectCriteria $previewColumns[1] $previewColumns[2]";
				}
				$query .= " limit " . MAX_PREVIEW;
		//$_SESSION['debugMsg'] .= logIt($linki, $query);

				$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR109 - $query ] "));
				$numFields = mysqli_num_fields($result);
				$xmlStr[$xmlStrIdx++] = "\n\t<preview target='{$form}'>";
				while ($row = mysqli_fetch_row($result)) {
					$xmlStr[$xmlStrIdx++] = "\n\t\t<pItem id='{$row[0]}'>";

					for ($fieldCount = 1; $fieldCount < $numFields; $fieldCount++) {
						$xmlStr[$xmlStrIdx++] = htmlspecialchars($row[$fieldCount]) . ' __ ';
					}
					$xmlStr[$xmlStrIdx++] = '</pItem>';
				}
				$xmlStr[$xmlStrIdx++] = "\n\t</preview>";
			}
		}
	}
	$xmlStr[$xmlStrIdx++] = "\n\t<form name=\"{$form}\" showId=\"{$configXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("showId")}\" showNavButtons=\"{$configXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("showNavButtons")}\" showSaveButton=\"{$configXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("showSaveButton")}\" showNewButton=\"{$configXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("showNewButton")}\" showDeleteButton=\"{$configXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("showDeleteButton")}\" showDuplicateButton=\"{$configXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("showDuplicateButton")}\" showNavHistoryButton=\"{$configXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("showNavHistoryButton")}\" showXofXX=\"{$configXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("showXofXX")}\" previewColumns=\"{$configXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("previewColumns")}\" sendEmailOnSave=\"{$configXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("sendEmailOnSave")}\">\n\t\t";

	// cycle through each element in the form

	for ($i = 0; $i < $elementSet->length; $i++) {
		$permission = checkPermission('element', $pagePermission, $user, $elementSet->item($i)->getAttribute("permission"));
		$phrase = '';
		if (USE_RULES == 2  && $formUsesRules == 'y') {
/*



0: Apply Permission to Target when Select element value = Current
1: Apply SQL
2: Apply SQL when Select same as Proposed for Role/s
3: Restrict Select element options to Current and Proposed when Select element value = Current for Role/s
4: Apply Permission to Switch when Select element value = Current for Role/s
   
*/
			for ($j = 0; $j < $ruleCounter; $j++) {
				if ($ruleArr[$j]->ruleType == ELEMENT_PERMISSION) {
					if ($ruleArr[$j]->elementName == $elementSet->item($i)->getAttribute("name")) {
						if ($_POST['navigation'] == 'new|-' || $_POST['navigation'] == 'save|0') {
							$permission = 'r'; 
							break;
						}
					}
					if ($ruleArr[$j]->subjectName == $elementSet->item($i)->getAttribute("name")) {
						if (isset($valueArr[$ruleArr[$j]->elementName])) {
							if ($ruleArr[$j]->fromValue == $valueArr[$ruleArr[$j]->elementName]) {
								switch ($ruleArr[$j]->permission) {
									case 1: $permission = 'h'; break;
									case 2: $permission = 'r'; break;
									case 3: $permission = 'w'; break;
								}
								break;
							}
						}
					}
				}
			}
		}
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'Creating element (name|type|permission): ' . $elementSet->item($i)->getAttribute("name") . "|" . $elementSet->item($i)->getAttribute("type") . "|" . $permission);
		if ($permission != 'h') {
		if ($elementSet->item($i)->getAttribute("mandatory")=="y") $mandatory="*"; else $mandatory="";

		// create input fields

		if ($elementSet->item($i)->getAttribute("type")=="input") {
			$showWindow = '';
			$tmpStr = '';
			if ($elementSet->item($i)->getAttribute("validate")=="date") {
				$showWindow = 'calendar';
				$calendarVarArr = explode('|', getCalendarVariables());
			}
			elseif ($elementSet->item($i)->getAttribute("validate")=="tree") {
				$showWindow = 'tree';
				$tmpStr = ' source="' . $elementSet->item($i)->getAttribute("source") . '" display="' . $elementSet->item($i)->getAttribute("display") . '" ';
			}
			else {
				$showWindow = '';
				$calendarWindowString = ""; 
			}

			$phrase = "\n\t\t<input name=\"{$elementSet->item($i)->getAttribute("name")}\" value=\"{$valueArr[$elementSet->item($i)->getAttribute("name")]}\" size=\"{$elementSet->item($i)->getAttribute("maxSize")}\" label=\"{$elementSet->item($i)->getAttribute("label")}{$mandatory}\" {$tmpStr} showHistory=\"{$elementSet->item($i)->getAttribute("showHistory")}\" showWindow=\"{$showWindow}\"";
			if ($showWindow == 'calendar') {
				$phrase .= " calDateArr=\"{$calendarVarArr[0]}\" calDayNum=\"{$calendarVarArr[4]}\" calMonthNum=\"{$calendarVarArr[1]}\" calYear=\"{$calendarVarArr[2]}\" calRange=\"{$calendarVarArr[3]}\" calFormat=\"" . DATE_FORMAT . "\" calSeparator=\"" . getDateSeparator() . "\"";
			}
			elseif ($showWindow == 'tree') {
				$phrase .= " instance=\"{$PABULUMBA_INSTANCE_ID}\"";
			}
			$phrase .= " permission=\"{$permission}\" javascript=\"{$elementSet->item($i)->getAttribute("javascript")}\">";
			if ($elementSet->item($i)->getAttribute("showHistory")=="y") {
				$query = "select h.action_time, u.full_name, element_name, new_value from history h inner join user u on h.user=u.id where record_id = '$navIds->id' and form_name='{$form}' and element_name='{$elementSet->item($i)->getAttribute("name")}' order by action_time";
				$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR019 - $query ] "));
				$phrase .= "\n\t\t\t<history>";
				while ($row = mysqli_fetch_row($result)) {
					// original pabulumba uses next line: 
					// $phrase .= "\n\t\t\t\t<hist>On " . formatDateTime($row[0]) . ", $row[1] said: " . htmlspecialchars($row[3]) . "</hist>";
					$phrase .= "\n\t\t\t\t<hist>" . formatDateTime($row[0]) . ' (' . htmlspecialchars($row[1]) . '): ' . htmlspecialchars($row[3]) . '</hist>';
				}
				$phrase .= "\n\t\t\t</history>";
			}
			$phrase .= "\n\t\t</input>";
		}
		else if ($elementSet->item($i)->getAttribute("type")=="grid") {
			$gridName = $elementSet->item($i)->getAttribute("name");
			$xpath = new DOMXPath($configXmlDoc);

			// get the fields to be shown within the grid

			$xpQuery = "/doc/form/element[@name='{$gridName}']/field";
			$fieldTree = $xpath->query($xpQuery);

			// match up the grid fields with the table fields

			// All this next stuff is used twice; surely this can be amalgamated with the UPDATE stuff

			$gridXmlDoc[$gridCount] = new DOMDocument();
			getConfigData($gridXmlDoc[$gridCount],"{$elementSet->item($i)->getAttribute("source")}.xml",6, $linki);
			$xpath = new DOMXPath($gridXmlDoc[$gridCount]);
			$xpQuery = '/doc/form/element[@filterByUser="y"]';
			$dataset = $xpath->query($xpQuery);
			$filterByUser = $dataset->length;
			$gridElementSet = $gridXmlDoc[$gridCount]->getElementsByTagName("element");
			$xpath = new DOMXPath($configXmlDoc);
			$fieldTreeAttributes = array();
			for ($j = 0; $j < $fieldTree->length; $j++) {
				for ($k = 0; $k < $gridElementSet->length; $k++) {
					// TODO maybe all the fieldTree attributes can be put into a class because they are used at least twice
					if ($gridElementSet->item($k)->getAttribute("name") === $fieldTree->item($j)->getAttribute("name")) {
						$fieldTreeAttributes[$j] = array();
						$fieldTreeAttributes[$j]["validate"] = $gridElementSet->item($k)->getAttribute("validate");
						$fieldTreeAttributes[$j]["maxSize"] = $fieldTree->item($j)->getAttribute("maxSize");
						$fieldTreeAttributes[$j]["label"] = $gridElementSet->item($k)->getAttribute("label");
						$fieldTreeAttributes[$j]["type"] = $gridElementSet->item($k)->getAttribute("type");
						$fieldTreeAttributes[$j]["name"] = $gridElementSet->item($k)->getAttribute("name");
						$fieldTreeAttributes[$j]["filterByUser"] = $gridElementSet->item($k)->getAttribute("filterByUser");
						if ($gridElementSet->item($k)->getAttribute("type") == "select" || $gridElementSet->item($k)->getAttribute("type") == "radio") {
							$fieldTreeAttributes[$j]["display"] = $gridElementSet->item($k)->getAttribute("display");
							$fieldTreeAttributes[$j]["source"] = $gridElementSet->item($k)->getAttribute("source");
						}
					}
				}
			}
			// get the row names to be shown as y-axis labels

			$xpQuery = "/doc/form/element[@name='{$gridName}']/row";
			$rowTree = $xpath->query($xpQuery);
			
			// draw a hidden field which represents the grid; this is absolutely necessary at this stage

			$phrase = "\n\t\t<hidden name=\"{$gridName}\">" . $valueArr[$gridName] . "</hidden>";
			
			// start drawing the grid
	// It's possible that naming the table the same thing as the hidden element above may cause issues, so append _grid...
			// TODO document the above
			$phrase .= "\n\t\t<table name=\"{$gridName}_grid\">";

			$rowCount = $elementSet->item($i)->getAttribute("autoRowNumber") == 0 ? $rowTree->length : $elementSet->item($i)->getAttribute("autoRowNumber");
			$colCount = $fieldTree->length;

			// draw the label of the grid as a table heading 

			$phrase .= "\n\t\t\t<tr>\n\t\t\t\t<th/>\n\t\t\t\t<th colspan=\"" . ($colCount + 3) . "\">".$elementSet->item($i)->getAttribute('label').$mandatory."</th>\n\t\t\t</tr>";
			$phrase .= "\n\t\t\t<tr>";
			//
			// draw an empty header cell

			$phrase .= "\n\t\t\t\t<th>Max: {$rowCount}</th>";

			// draw the column headings, with the exception of the id field

			for ($j = 0; $j <= $colCount; $j++) {
				if ($j == 0) {
					$phrase .= "\n\t\t\t\t<th colspan=\"2\">Select</th>";
				}
				else {
					$phrase .= "\n\t\t\t\t<th>{$fieldTreeAttributes[$j - 1]["label"]}</th>";
				}
			}
			$phrase .= "\n\t\t\t</tr>";
			
			// if autoRowNumber is set to zero, get the row display labels, else number the rows
			
			$j = 0;
			$existingRowCount = 0;
			$_SESSION['gridIds'][$elementSet->item($i)->getAttribute("source")] = " and {$elementSet->item($i)->getAttribute("source")}.id in (";
			while ($j <= $rowCount) {
				//$_SESSION['debugMsg'] .= logIt($linki, "new rowId: $gridName $j ");
				// if no specific row value has been returned either from db or the web page, skip drawing output
				if (! isset($valueArr["{$gridName}_{$j}_0"])) {
					$j++;
					continue;
				}
				$existingRowCount++;
				$label = $elementSet->item($i)->getAttribute("autoRowNumber") == 0 ? $rowTree->item($j)->getAttribute("label") : $existingRowCount;
				$rowId = htmlspecialchars($valueArr["{$gridName}_{$j}_0"]);
				//$_SESSION['debugMsg'] .= logIt($linki, "new rowId: $gridName $j 0 value: $rowId");
				$_SESSION['gridIds'][$elementSet->item($i)->getAttribute("source")] .= "{$rowId}," ;
				$phrase .= "\n\t\t\t<tr>\n\t\t\t\t<td style=\"bg2\">{$label}</td>\n\t\t\t\t<td>\n\t\t\t\t\t<inputCheckbox name=\"{$gridName}_{$j}_delete\" value=\"{$rowId}\"/><gridButton xml='{$elementSet->item($i)->getAttribute("source")}' xsl='" . XSL_TEMPLATE . "' id='{$rowId}' />\n\t\t\t\t</td>";
				$phrase .= "\n\t\t\t\t<td>\n\t\t\t\t\t<hidden name=\"{$gridName}_{$j}_0\" value=\"{$rowId}\" />\n\t\t\t\t</td>";
				for ($k = 1; $k <= $colCount; $k++) {
					if ($fieldTreeAttributes[$k - 1]["type"] == "input") {
						$phrase .= "\n\t\t\t\t<td>\n\t\t\t\t\t<inputCell name=\"{$gridName}_{$j}_{$k}\" value=\"";
						if ($fieldTreeAttributes[$k - 1]["validate"] == 'date') {
							$phrase .= formatDateFor('displayExDb', htmlspecialchars($valueArr["{$gridName}_{$j}_{$k}"]));
						}
						else {
							$phrase .= htmlspecialchars($valueArr["{$gridName}_{$j}_{$k}"]);
						}
						$phrase .= "\" style=\"bg" . $j % 2 . "\" size=\"{$fieldTreeAttributes[$k - 1]["maxSize"]}\" permission=\"$permission\" />\n\t\t\t\t</td>";
					}
					elseif ($fieldTreeAttributes[$k - 1]["type"] == "checkbox") {
						$checked = ($valueArr["{$gridName}_{$j}_{$k}"] == 1) ? 'checked="y"' : '';
						$phrase .= "\n\t\t\t\t<td>\n\t\t\t\t\t<inputCheckbox name=\"{$gridName}_{$j}_{$k}\" $checked value=\"" . htmlspecialchars($valueArr["{$gridName}_{$j}_{$k}"]) . "\" style=\"bg" . $j % 2 . "\" permission=\"$permission\" /></td>";
					}
					elseif ($fieldTreeAttributes[$k - 1]["type"] == "select" || $fieldTreeAttributes[$k - 1]["type"] == "radio") {
						// TODO
						if (strpos($fieldTreeAttributes[$k - 1]["source"], ',') > -1) {
							$options = explode(',', $fieldTreeAttributes[$k - 1]["source"]);
							$tmpVal = $options[$valueArr["{$gridName}_{$j}_{$k}"] - 1];
							$phrase .= "\n\t\t\t\t<td>\n\t\t\t\t\t<hidden name=\"{$gridName}_{$j}_{$k}\" value=\"" . htmlspecialchars($valueArr["{$gridName}_{$j}_{$k}"]) . "\" />";
							$phrase .= "\n\t\t\t\t<inputCell name=\"_{$gridName}_{$j}_{$k}\" value=\"{$tmpVal}\" style=\"bg" . $j % 2 . "\" size=\"{$fieldTreeAttributes[$k - 1]["maxSize"]}\" permission=\"r\" /></td>";
						}
						else {
							$query = "select {$fieldTreeAttributes[$k - 1]["display"]} from {$fieldTreeAttributes[$k - 1]["source"]} where id = " . $valueArr["{$gridName}_{$j}_{$k}"];
							$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR087 - $query ] "));
							//$result = mysqli_query($linki, $query) or die();
							$phrase .= "\n\t\t\t\t<td>\n\t\t\t\t\t<inputCell name=\"{$gridName}_{$j}_{$k}\" value=\"" . htmlspecialchars($valueArr["{$gridName}_{$j}_{$k}"]) . "\" style=\"bg" . $j % 2 . "\" size=\"{$fieldTreeAttributes[$k - 1]["maxSize"]}\" permission=\"h\" />";
							$row = mysqli_fetch_row($result);
							$phrase .= "\n\t\t\t\t\t<inputCell name=\"_{$gridName}_{$j}_{$k}\" value=\"" . $row[0] . "\" style=\"bg" . $j % 2 . "\" size=\"{$fieldTreeAttributes[$k - 1]["maxSize"]}\" permission=\"r\" />\n\t\t\t\t</td>";
						}
					}
				}
				$phrase .= "\n\t\t\t</tr>";
				$j++;
			}
			$_SESSION['gridIds'][$elementSet->item($i)->getAttribute("source")] = substr($_SESSION['gridIds'][$elementSet->item($i)->getAttribute("source")], 0, strlen($_SESSION['gridIds'][$elementSet->item($i)->getAttribute("source")]) - 1); 
			$_SESSION['gridIds'][$elementSet->item($i)->getAttribute("source")] .= ')';
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, $_SESSION['gridIds'][$elementSet->item($i)->getAttribute("source")]);

			//  If the grid size limit has not been reached, draw the New row to allow input of...a new row of information!!!

			if ($existingRowCount < $rowCount) {
				$phrase .= "\n\t\t\t<tr>\n\t\t\t\t<td style=\"bg2\">New</td><td/>";
				$phrase .= "\n\t\t\t\t<td/>";
				for ($k = 1; $k <= $colCount; $k++) {
					if ($fieldTreeAttributes[$k - 1]["type"] == "input") {
						if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "testing for: {$gridName}_new_{$k}");
						// surely this next line could go a little earlier and save looking up the value later?
						if (isset($valueArr["{$gridName}_new_{$k}"])) {
							$tmp = $valueArr["{$gridName}_new_{$k}"];
							if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "{$gridName}_new_{$k} exists; value = |{$tmp}|");
						}
						else {
							$tmp = '';
						}
						$phrase .= "\n\t\t\t\t<td><inputCell name=\"{$gridName}_new_{$k}\" value=\"" . htmlspecialchars($tmp) . "\" style=\"bg2\"" . " size=\"{$fieldTreeAttributes[$k - 1]["maxSize"]}\" permission=\"$permission\" /></td>";
					}
					elseif ($fieldTreeAttributes[$k - 1]["type"] == "select" || $fieldTreeAttributes[$k - 1]["type"] == "radio") {
						$phrase .= "\n\t\t\t\t<td><inputSelect name=\"{$gridName}_new_{$k}\" source=\"{$fieldTreeAttributes[$k - 1]["source"]}\" display=\"{$fieldTreeAttributes[$k - 1]["display"]}\"";
						if ($fieldTreeAttributes[$k - 1]["validate"] == 'tree') {
							//$phrase .= " showWindow=\"tree\" >";
							$phrase .= " showWindow=\"tree\" instance=\"{$PABULUMBA_INSTANCE_ID}\">";
							if (isset($valueArr["{$gridName}_new_{$k}"]) && strlen($valueArr["{$gridName}_new_{$k}"]) > 0) {
								$query = "select id, {$fieldTreeAttributes[$k - 1]["display"]} from {$fieldTreeAttributes[$k - 1]["source"]} where id = " . $valueArr["{$gridName}_new_{$k}"]; 
								$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR104 - $query ] "));
								$row = mysqli_fetch_row($result);
								// $_SESSION['debugMsg'] .= logIt($linki, $query);
								$phrase .= "\n\t\t\t\t\t<option value=\"{$row[0]}\">{$row[1]}</option>";
							}
							else {
								// "Please select using Tree"
								$phrase .= "\n\t\t\t\t\t<option value=\"\">{$messageArr[6]}...</option>";
							}
							//if (isset($valueArr['grid_' . $gridCount . '_new_' . $k])) $phrase .= ' selected = "selected"';
						}
						else {
							$phrase .= ">\n\t\t\t\t\t<option value=\"\"></option>";
							if (strpos($fieldTreeAttributes[$k - 1]["source"], ',') > -1) {
								$options = explode(',', $fieldTreeAttributes[$k - 1]["source"]);
								$selected = '';
								for ($l = 1; $l <= count($options); $l++) {
									if ($action != 'display') {
										if (isset($valueArr["{$gridName}_new_{$k}"]) && "$l" === $valueArr["{$gridName}_new_{$k}"]) $selected = ' selected="selected"'; else $selected = '';
									}
									$phrase .= "\n\t\t\t\t\t" . '<option value="' . $l . '"' . $selected . '>' . $options[$l - 1] . '</option>';
								}
							}
							else {
								$query = "select id, {$fieldTreeAttributes[$k - 1]["display"]} from {$fieldTreeAttributes[$k - 1]["source"]} where 1=1 ";
								if ($fieldTreeAttributes[$k - 1]["filterByUser"] == 'y') {
									// TODO get selectCriteria working
									$filterTableName = $fieldTreeAttributes[$k - 1]["source"];
									$query .= " and id in (select {$fieldTreeAttributes[$k - 1]["name"]} from {$fieldTreeAttributes[$k - 1]["name"]}_user where user = $userId)"; // $selectCriteria";
								}
								$query .= ' and deleted = 0 limit 150';

								$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR088 - $query ] "));
								while ($row = mysqli_fetch_row($result)) {
									$phrase .= "\n\t\t\t\t\t<option value=\"{$row[0]}\" ";
									if ($action != 'display') {
										if (isset($valueArr["{$gridName}_new_{$k}"]) && $row[0] == $valueArr["{$gridName}_new_{$k}"]) $phrase .= ' selected = "selected"';
									}
									$phrase .= ">{$row[1]}</option>";
								}
							}
						}
						$phrase .= "\n\t\t\t\t</inputSelect></td>";
					}
					elseif ($fieldTreeAttributes[$k - 1]["type"] == "checkbox") {
						// The next 4 commented lines were crashing pabulumba when database was completely emplty.
						// Not sure what purpose they actually serve, as they don't see to affect anything.

						//if ($valueArr["{$gridName}_new_{$k}"] == "1") $phrase .= ' selected = "selected"';
						//else $selected = '';
						$phrase .= "\n\t\t\t\t<td><inputSelect name=\"{$gridName}_new_{$k}\">";
						$phrase .= "\n\t\t\t\t\t<option value=\"\"></option>";
						$phrase .= "\n\t\t\t\t\t<option value=\"1\"";
						if (isset($valueArr["{$gridName}_new_{$k}"]) && $valueArr["{$gridName}_new_{$k}"] == "1") $phrase .= ' selected = "selected"';
						$phrase .= ">&#10004;</option>";
						$phrase .= "\n\t\t\t\t\t<option value=\"0\"";
						if (isset($valueArr["{$gridName}_new_{$k}"]) && $valueArr["{$gridName}_new_{$k}"] == "0") $phrase .= ' selected = "selected"';
						$phrase .= ">&#10006;</option>";
						$phrase .= "\n\t\t\t\t</inputSelect></td>";
					}
				}
				$phrase .= "\n\t\t\t</tr>";
			}

			$phrase .= "\n\t\t</table>";
			/*for ($j = 0; $j < $rowCount; $j++) {
				for ($k = 0; $k < $colCount; $k++) {
					$phrase .= "\n\t\t\t<hidden name=\"";
					$phrase .= 'grid_' . $gridCount . '_' . $j . '_' . $k . "\">";
					$phrase .= $valueArr['grid_' . $gridCount . '_' . $j . '_' . $k];
					$phrase .= "</hidden>";
				}
			}*/
			$gridCount++;
		}
		else if ($elementSet->item($i)->getAttribute("type")=="search") {
			$phrase = '<input name="' . $elementSet->item($i)->getAttribute("name") . '"' . ' value="' . $valueArr[$elementSet->item($i)->getAttribute("name")] . '" size="'. $elementSet->item($i)->getAttribute("maxSize") . '" label="'. $elementSet->item($i)->getAttribute("label"). "$mandatory\" permission=\"{$permission}\"" . ' />' . "\n\t\t";
			$searchTable = $elementSet->item($i)->getAttribute("searchTable");
			$searchQuery = $elementSet->item($i)->getAttribute("searchSql");

			if ($action == 'update') {

				$searchTerm = $_POST['search_term'];
				if (strlen($searchTerm) > 0) {
				$result = mysqli_query($linki, $searchQuery) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR018 - $query ] "));
				while ($row = mysqli_fetch_row($result)) {
					$temp = '';
					for ($i = 1; $i < (mysqli_num_fields($result)); $i++) {
						$temp .= $row[$i] . " ";
					}
					$searchStart = 0;
					if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, $temp);
					$subphrase = "\n\t\t<searchResult table=\"{$searchTable}\"><formButton xml='{$searchTable}' xsl='" . XSL_TEMPLATE . "' id='{$row[0]}' />\n\t\t\t<id>$row[0]</id>";
					$foundAt = -1;
					//  need to use htmlspecialchars AFTER the search because otherwise the search will look inside the
					//  expanded entity, e.g. search will find the 't' in &quot;
					while (stripos($temp, $searchTerm, $searchStart) > -1) {
						$foundAt = stripos($temp, $searchTerm, $searchStart);
						$subphrase .= "\n\t\t\t" . '<context>' . htmlspecialchars(substr($temp, $searchStart, $foundAt - $searchStart));
						$subphrase .= "\n\t\t\t\t<searchTerm>" . htmlspecialchars($searchTerm) . "</searchTerm>\n\t\t\t</context>";
					       $searchStart = $foundAt + strlen($searchTerm);
					}
					$subphrase .= "\n\t\t\t" . '<context>' . htmlspecialchars(substr($temp, $foundAt + strlen($searchTerm))) . "</context>\n\t\t</searchResult>";
					if ($searchStart > 0) {
						$phrase .= $subphrase;
					}
				}
				}
				else {
					$phrase = '<input name="' . $elementSet->item($i)->getAttribute("name") . '"' . ' value="' . $valueArr[$elementSet->item($i)->getAttribute("name")] . '" size="'. $elementSet->item($i)->getAttribute("maxSize") . '" label="'. $elementSet->item($i)->getAttribute("label"). "$mandatory\" permission=\"{$permission}\"" . ' />' . "\n\t\t";
					$phrase .= "<searchResult></searchResult>";
				}
			}
		}
		else if ($elementSet->item($i)->getAttribute("type")=="textarea") {
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "showHistory: {$elementSet->item($i)->getAttribute("showHistory")} for {$elementSet->item($i)->getAttribute("name")}");
			$phrase .= "\n\t\t" . '<textarea name="' . $elementSet->item($i)->getAttribute("name") . '" rows="' . $elementSet->item($i)->getAttribute("rows") . '" cols="' . $elementSet->item($i)->getAttribute("cols") . '" value="' . stripslashes(str_replace("\r\n", "&#013;&#010;", $valueArr[$elementSet->item($i)->getAttribute("name")])) . '" showHistory="' . $elementSet->item($i)->getAttribute("showHistory") . '" label="'. $elementSet->item($i)->getAttribute("label") . "$mandatory\" permission=\"{$permission}\" >";
			if ($elementSet->item($i)->getAttribute("showHistory")=="y") {
				$query = "select h.action_time, u.full_name, element_name, new_value from history h inner join user u on h.user=u.id where record_id = '$navIds->id' and form_name='{$form}' and element_name='{$elementSet->item($i)->getAttribute("name")}' order by action_time";
				$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR019 - $query ] "));
				$phrase .= "\n\t\t\t<history>";
				while ($row = mysqli_fetch_row($result)) {
					$phrase .= "\n\t\t\t\t<hist>" . formatDateTime($row[0]) . ' (' . htmlspecialchars($row[1]) . '): ' . htmlspecialchars($row[3]) . "</hist>";
				}
				$phrase .= "\n\t\t\t</history>";
			}
			$phrase .= "\n\t\t</textarea>";
		}
		else if ($elementSet->item($i)->getAttribute("type")=="file") {
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Handling the files on displaying xml");
			$phrase = "\n\t\t" . '<file name="' . $elementSet->item($i)->getAttribute("name") . '"' . ' type="file" value="' . $valueArr[$elementSet->item($i)->getAttribute("name")] . '" size="'. $elementSet->item($i)->getAttribute("maxSize") . '" label="'. $elementSet->item($i)->getAttribute("label"). "$mandatory\" permission=\"{$permission}\"" . ' >';
			if ($valueArr[$elementSet->item($i)->getAttribute("name")] == 1) {

				// the reason why this logic is here, rather than in update is to simply
				// avoid doing the file retrieve from the db twice - I could pass the file names
				// in a string from the update lookup, if I do that in the future

				$query = "select file_name from file where record_id = $navIds->id and form_name = '" . $form . "'";
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "File query: " . addslashes($query));
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Values of action and nextAction: $action | $nextAction ");
				$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR020 - $query ] "));
				$deleteQuery = "delete from file where form_name = '$form' and record_id = '$navIds->id' and (";
				$deleteFlag = false;
				$subphrase = '';
				while ($row = mysqli_fetch_row($result)) {
					if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Values of action and nextAction inside file list loop: $action | $nextAction ");
					$displayImages = 'n';
					if (DISPLAY_IMAGES == 2) {
						$displayImages = strtolower(substr($row[0], -4));
					}
					if ($action == 'display') {
						$phrase .= "\n\t\t\t<fileName alias=\"" . encode($row[0]) . "\" path=\"" . FILE_UPLOAD_PATH . "\" displayImages=\"{$displayImages}\">{$row[0]}</fileName>";
						if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Each new file name: " . FILE_UPLOAD_PATH . $row[0]);
					}
					else {
						$temp = $row[0];
						$temp = encode($temp);
						if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'Replaced file name: ' . $temp);
						if (isset($_POST[$temp]) || strlen($_FILES['uploadedFile']['name']) > 0) {
							if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Keep this file: " . $row[0]);
							if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Keep this file: " . $temp);
							$phrase .= "\n\t\t\t<fileName alias=\"{$temp}\" path=\"" . FILE_UPLOAD_PATH . "\" displayImages=\"{$displayImages}\">{$row[0]}</fileName>";
						}
						else {
							$deleteFlag = true;
							$subphrase .= "file_name = '{$row[0]}' or ";
						}
					}
				}
				$subphrase = substr($subphrase, 0, strlen($subphrase) - 4) . ')';
				if ($deleteFlag) {
					if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt ('Deleting files: ' . mysqli_real_escape_string($linki, $deleteQuery . $subphrase));
					mysqli_query($linki, $deleteQuery . $subphrase) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR021 - ' . $deleteQuery . ']'));
				}
			}
			$query = "select count(id) from file where form_name = '$form' and record_id = '$navIds->id'";
			//echo $query; exit;
			$row = mysqli_fetch_row(mysqli_query($linki, $query));
			$filesLeft = $row[0];
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Number of files left on this id: $filesLeft ");
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Replace phrase before: " . mysqli_real_escape_string($linki, $phrase));
			if (!$filesLeft && $navIds->id != '') {
				$phrase = str_replace("value=\"1\"", "value=\"0\"", $phrase);
				$query = "update $form set {$elementSet->item($i)->getAttribute("name")} = '0' where id = $navIds->id";
				mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR022 - ' . $query . ']'));
			}
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Replace phrase after: " . mysqli_real_escape_string($linki, $phrase));
			$phrase .= "\n\t\t</file>";
		}
		else if ($elementSet->item($i)->getAttribute("type")=="url") {
			$phrase = "\n\t\t" . '<url name="' . $elementSet->item($i)->getAttribute("name") . '"' . ' type="url" value="';
		       	if (isset($_POST['uploadedURL']) && strlen($errorMsg) > 0) {
				$phrase .= $_POST['uploadedURL'];
			}
			$phrase .= '" size="'. $elementSet->item($i)->getAttribute("maxSize") . '" label="'. $elementSet->item($i)->getAttribute("label"). "$mandatory\" permission=\"{$permission}\"" . ' >';
			if (($valueArr[$elementSet->item($i)->getAttribute("name")] == 1 || isset($_POST['uploadedURL'])) && strlen($navIds->id) > 0) {

				// the reason why this logic is here, rather than in update is to simply
				// avoid doing the url retrieve from the db twice - I could pass the url names
				// in a string from the update lookup, if I do that in the future

				$query = "select url_name from url where record_id = $navIds->id and form_name = '" . $form . "'";
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "url query in display: " . addslashes($query));
				$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR068 - $query ] "));
				$deleteQuery = "delete from url where form_name = '$form' and record_id = '$navIds->id' and (";
				$deleteFlag = false;
				$subphrase = '';
				while ($row = mysqli_fetch_row($result)) {
					if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Values of action and nextAction inside file list loop: $action | $nextAction ");
					$displayImages = 'n';
					if ($action == 'display') {
						$phrase .= "\n\t\t\t<urlName alias=\"" . encode($row[0]) . "\">{$row[0]}</urlName>";
						if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Each new url name: " . $row[0]);
					}
					else {
						$temp = $row[0];
						$temp = encode($temp);
						if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'Replaced url name: ' . $temp);
						if (isset($_POST[$temp]) || strlen($_POST['uploadedURL']) > 0) {
							if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Keep this url: " . $row[0]);
							if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Keep this url: " . $temp);
							$phrase .= "\n\t\t\t<urlName alias=\"{$temp}\">{$row[0]}</urlName>";
						}
						else {
							$deleteFlag = true;
							$subphrase .= "url_name = '{$row[0]}' or ";
						}
					}
				}
				$subphrase = substr($subphrase, 0, strlen($subphrase) - 4) . ')';
				if ($deleteFlag) {
					if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt ('Deleting urls: ' . mysqli_real_escape_string($linki, $deleteQuery . $subphrase));
					mysqli_query($linki, $deleteQuery . $subphrase) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR069 - ' . $deleteQuery . ']'));
				}
			}
			$query = "select count(id) from url where form_name = '$form' and record_id = '$navIds->id'";
			$result = mysqli_query($linki, $query);
			$row = mysqli_fetch_row($result);
			$urlLeft = $row[0];
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Number of urls left on this id: $urlLeft ");
			// TODO is this replace stuff necessary here?
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Replace phrase before: " . mysqli_real_escape_string($linki, $phrase));
			if (!$urlLeft && isset($navIds->id)) {
				$phrase = str_replace("value=\"1\"", "value=\"0\"", $phrase);
				$query = "update $form set {$elementSet->item($i)->getAttribute("name")} = '0' where id = $navIds->id";
				mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . ' [ERR070 - ' . $query . ']'));
			}
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Replace phrase after: " . mysqli_real_escape_string($linki, $phrase));
			$phrase .= "\n\t\t</url>";
		}
		else if ($elementSet->item($i)->getAttribute("type")=="password") {
			$phrase = '<password name="' . $elementSet->item($i)->getAttribute("name") . '"' . ' value="' . $valueArr[$elementSet->item($i)->getAttribute("name")] . '" label="'. $elementSet->item($i)->getAttribute("label"). "$mandatory\" permission=\"{$permission}\"" . ' />' . "\n\t\t";
		}
		else if ($elementSet->item($i)->getAttribute("type")=="checkbox") {
			$phrase = "\n\t\t" . '<checkbox name="' . $elementSet->item($i)->getAttribute("name") . '"' . ' value="' . $valueArr[$elementSet->item($i)->getAttribute("name")] . '" label="'. $elementSet->item($i)->getAttribute("label"). "$mandatory\" javascript=\"" . $elementSet->item($i)->getAttribute("javascript") . "\" permission=\"{$permission}\"" . ' />' . "\n\t\t";
		}
		// create select fields
		elseif ($elementSet->item($i)->getAttribute("type")=="select") {
			$turnSelectFilterOn = false;

			// create an options array if the data source is a list

			$options = array();

			// if the data source contains a comma, it is considered a list, otherwise, it is
			// the name of a db table to get the data from

			if (strpos($elementSet->item($i)->getAttribute("source"), ',') > -1) {
				$options = explode(',', $elementSet->item($i)->getAttribute("source"));
				$phrase = "\n\t\t" . '<select name="' . $elementSet->item($i)->getAttribute("name") . '" label="' . $elementSet->item($i)->getAttribute("label") . "$mandatory\" showHistory=\"{$elementSet->item($i)->getAttribute("showHistory")}\" javascript=\"" . $elementSet->item($i)->getAttribute("javascript") . "\">\n\t\t";
				$matchFound = false;
				if ($permission == 'r') {
					$phrase .= "\n\t\t\t<option value=\"{$valueArr[$elementSet->item($i)->getAttribute("name")]}\" selected=\"selected\">{$options[$valueArr[$elementSet->item($i)->getAttribute("name")]]}</option>";
				}
				else {
					if (USE_RULES == 2 && ($formUsesRules == 'y' || $switchesUseRules == 'y')) {
						//$criteriaClause = ' and id in (';
						for ($j = 1; $j <= count($options); $j++) {
							//if ($j == $valueArr[$elementSet->item($i)->getAttribute("name")]) $selected = ' selected="selected"'; else $selected = '';
							//			$phrase .= "\n\t\t\t" . '<option value="' . $j . '"' . $selected . '>' . $options[$j - 1] . '</option>';
						for ($k = 0; $k < $ruleCounter; $k++) {
							if ($ruleArr[$k]->ruleType == TRANSITION) {
								if ($ruleArr[$k]->elementName == $elementSet->item($i)->getAttribute("name")) {
									//if ($ruleArr[$k]->fromValue == $valueArr[$elementSet->item($i)->getAttribute("name")]) {
//					$_SESSION['debugMsg'] .= logIt($linki, "$j $k " . $ruleArr[$k]->toValue . " " . $ruleArr[$k]->elementName);
										if ($j == $ruleArr[$k]->fromValue || $j == $ruleArr[$k]->toValue) {
											if ($j == $valueArr[$elementSet->item($i)->getAttribute("name")]) $selected = ' selected="selected"'; else $selected = '';
											$phrase .= "\n\t\t\t" . '<option value="' . $j . '"' . $selected . '>' . $options[$j - 1] . '</option>';
										$matchFound = true;
										}
						//				$criteriaClause .= $ruleArr[$j]->toValue . ',';
									//}
								}
							}
						}
						}
						//$criteriaClause .= $valueArr[$elementSet->item($i)->getAttribute("name")] . ')';
						// TODO there is something not quite right here on adding a Select element to a form - it is empty because id where 1=10 is produced
						//$criteria .= ($matchFound) ? $criteriaClause : (strlen($valueArr[$elementSet->item($i)->getAttribute("name")]) > 0) ? " and id = {$valueArr[$elementSet->item($i)->getAttribute("name")]}" : '';
						// this is wrong, but might work well enough for the moment
						// TODO TODO TODO TODO
						//$criteria .= ($matchFound) ? $criteriaClause : '';
					//$_SESSION['debugMsg'] .= logIt($linki, $query . ':' . $elementSet->item($i)->getAttribute("name") . ':' . $criteriaClause);
					}
				}
				if (!$matchFound) {
					for ($j = 1; $j <= count($options); $j++) {
						if ($j == $valueArr[$elementSet->item($i)->getAttribute("name")]) $selected = ' selected="selected"'; else $selected = '';
						$phrase .= "\n\t\t\t" . '<option value="' . $j . '"' . $selected . '>' . $options[$j - 1] . '</option>';
					}
				}
			}
			else {

				// get data from a reference table

				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Value of id here: $navIds->id");
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Value of permission here: $permission");
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Creating a select field for {$elementSet->item($i)->getAttribute("name")} with an id of {$valueArr[$elementSet->item($i)->getAttribute("name")]}");
				$phrase = "\n\t\t" . '<select name="' . $elementSet->item($i)->getAttribute("name") . '" source="' . $elementSet->item($i)->getAttribute("source") . '" display="' . $elementSet->item($i)->getAttribute("display") . '" label="' . $elementSet->item($i)->getAttribute("label") . "$mandatory\" showSelectFilter=\"n\" showHistory=\"{$elementSet->item($i)->getAttribute("showHistory")}\" javascript=\"" . $elementSet->item($i)->getAttribute("javascript") . "\"";
				if ($elementSet->item($i)->getAttribute("validate") == 'tree') {
					$phrase .= " showWindow=\"tree\" instance=\"{$PABULUMBA_INSTANCE_ID}\"";
				}
				else {
					//$phrase .= "javascript=\"" . $elementSet->item($i)->getAttribute("javascript") . "\">";
				}
				$phrase .= '>';

				$criteria = " where 1=1";
				// TODO - there has to be a nicer way to do this (than appending || userRoleRefNo == 0) - this results in multiple recurring rows in the DDL,
				// but at least they are now visible to the SysAdmin when displayed
				// NOT SO! This does not work, so removing all admin sees everything stuff
				//if ($permission=="r" || $user->userRoleRefNo == 0) $criteria .= ' and id = \'' . $valueArr[$elementSet->item($i)->getAttribute("name")] . '\'';
				if ($permission=="r" || $elementSet->item($i)->getAttribute("validate") == 'tree') {
					$criteria .= ' and id = \'' . $valueArr[$elementSet->item($i)->getAttribute("name")] . '\'';
				}
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Current user role ref no: " . $user->userRoleRefNo);
				if ($elementSet->item($i)->getAttribute("filterByUser") == 'y') {
					$criteria .= " and id in (select {$elementSet->item($i)->getAttribute("name")} from {$elementSet->item($i)->getAttribute("name")}_user where user = {$user->userId})";
				}
					//$_SESSION['debugMsg'] .= logIt($linki, '$ruleCounter');
				if (USE_RULES == 2 && ($formUsesRules == 'y' || $switchesUseRules == 'y')) {
					$matchFound = false;
					$criteriaClause = ' and id in (';
					for ($j = 0; $j < $ruleCounter; $j++) {
						if ($ruleArr[$j]->ruleType == TRANSITION) {
							if ($ruleArr[$j]->elementName == $elementSet->item($i)->getAttribute("name")) {
								if ($ruleArr[$j]->fromValue == $valueArr[$elementSet->item($i)->getAttribute("name")]) {
									$criteriaClause .= $ruleArr[$j]->toValue . ',';
									$matchFound = true;
								}
							}
						}
					}
					$criteriaClause .= $valueArr[$elementSet->item($i)->getAttribute("name")] . ')';
					// TODO there is something not quite right here on adding a Select element to a form - it is empty because id where 1=10 is produced
					//$criteria .= ($matchFound) ? $criteriaClause : (strlen($valueArr[$elementSet->item($i)->getAttribute("name")]) > 0) ? " and id = {$valueArr[$elementSet->item($i)->getAttribute("name")]}" : '';
					// this is wrong, but might work well enough for the moment
					// TODO TODO TODO TODO
					$criteria .= ($matchFound) ? $criteriaClause : '';
				//$_SESSION['debugMsg'] .= logIt($linki, $query . ':' . $elementSet->item($i)->getAttribute("name") . ':' . $criteriaClause);
				}

				// if showDeleted setting is set to NO, then only records which are not marked as deleted are retrieved
				if (!$showDeleted) $criteria .= ' and (deleted = 0 or deleted is null)';
				if (strlen($elementSet->item($i)->getAttribute("selectCriteria")) > 0) {
						$criteria .= preg_replace('/\[CURRENT_USER_ID\]/', $userId, $elementSet->item($i)->getAttribute("selectCriteria"));
				}
				// IMPORTANT: Example of ordering select fields using a specific source
				
				if ($elementSet->item($i)->getAttribute("source") == "time_table") {
					$criteria .= ' order by id limit ' . SELECT_FILTER_THRESHOLD;
				}
				else {
					$criteria .= ' order by ' . $elementSet->item($i)->getAttribute("display") . ' limit ' . SELECT_FILTER_THRESHOLD;
				}
				
				if ($elementSet->item($i)->getAttribute("validate") == "date") {
					$df = "date_format(";
					$fs = ", '" . getSQLDateFormatStr() . "')";
				}
				else {
					$df = '';
					$fs = '';
				}

				$query = "select id, " . $df . $elementSet->item($i)->getAttribute("display") . $fs . ", deleted from " . $elementSet->item($i)->getAttribute("source") . $criteria;
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Select field query: $query");
				//$_SESSION['debugMsg'] .= logIt($linki, "Select field query: $query");
				$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR023 - $query ] "));
				$numRows = mysqli_num_rows($result);
				$counter = 0;
				$selectedItemFound = false;
				if ($elementSet->item($i)->getAttribute("mandatory") == "y") {
					// "Please select"
					$phrase .= "\n\t\t\t<option value='-694'>{$messageArr[2]}...</option>";
				}
				else {
					// "Optional"
					$phrase .= "\n\t\t\t<option value='-693'>{$messageArr[3]}...</option>";
				}
				while ($row = mysqli_fetch_row($result)) {
					if ($row[2] == '1') $deletedSymbol = '[-] '; else $deletedSymbol = '';
					if ($row[0] == $valueArr[$elementSet->item($i)->getAttribute("name")]) {
						$selected = ' selected="selected"';
						$selectedItemFound = true;
					}
					else {
						$selected = '';
					}
					if ($row[2] != '1' || $selected) {
						$phrase .= "\n\t\t\t" . '<option value="' . $row[0] . '"' . $selected . '>' . $deletedSymbol . htmlspecialchars($row[1]) . '</option>';
					}
					$counter++;
					if ($counter == SELECT_FILTER_THRESHOLD) {
						$turnSelectFilterOn = true;
						if ((!$selectedItemFound) && $valueArr[$elementSet->item($i)->getAttribute("name")] > 0) {
							$result = null;
							$criteria = " where id = " . $valueArr[$elementSet->item($i)->getAttribute("name")];
							if ($elementSet->item($i)->getAttribute("filterByUser") == 'y') {
								$criteria .= " and id in (select {$elementSet->item($i)->getAttribute("name")} from {$elementSet->item($i)->getAttribute("name")}_user where user = {$user->userId})";
							}
							if (!$showDeleted) $criteria .= ' and (deleted = 0 or deleted is null)';
							$criteria .= ' order by ' . $elementSet->item($i)->getAttribute("display");
							$query = "select id, " . $elementSet->item($i)->getAttribute("display") . ", deleted from " . $elementSet->item($i)->getAttribute("source") . $criteria;
							$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR048 - $query ] "));
							$row = mysqli_fetch_row($result);
							if ($row[2] == '1') $deletedSymbol = '[-] '; else $deletedSymbol = '';
							$selected = ' selected="selected"';
							if ($row[2] != '1' || $selected) {
								$phrase .= "\n\t\t\t" . '<option value="' . $row[0] . '"' . $selected . '>' . $deletedSymbol . htmlspecialchars($row[1]) . '</option>';
							}
						}
						break;
					}
				}
			}
			if ($elementSet->item($i)->getAttribute("showHistory")=="y") {
				if (strpos($elementSet->item($i)->getAttribute("source"), ',') > -1) {
					$query = "select h.action_time, u.full_name, element_name, new_value from history h inner join user u on h.user=u.id where record_id = '$navIds->id' and element_name='{$elementSet->item($i)->getAttribute("name")}' order by action_time";
				}
				else {
					$query = "select h.action_time, u.full_name, element_name, display.{$elementSet->item($i)->getAttribute("display")} from history h inner join user u on h.user=u.id inner join {$elementSet->item($i)->getAttribute("source")} display on new_value = display.id where record_id = '$navIds->id' and element_name='{$elementSet->item($i)->getAttribute("name")}' order by action_time";
				}
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Obtaining history for select: " . mysqli_real_escape_string($linki, $query));
				$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR024 - $query ] "));
				if (mysqli_num_rows($result) > 0) {
					$phrase .= "\n\t\t\t<history>";
					while ($row = mysqli_fetch_row($result)) {
						if (strpos($elementSet->item($i)->getAttribute("source"), ',') > -1) {
							$phrase .= "\n\t\t\t\t<hist>On " . formatDateTime($row[0]) . ', ' . htmlspecialchars($row[1]) . ' set: ' . htmlspecialchars($options[$row[3]]) . '</hist>';
						}
						else {
							$phrase .= "\n\t\t\t\t<hist>On " . formatDateTime($row[0]) . ', ' . htmlspecialchars($row[1]) . ' set: ' . htmlspecialchars($row[3]) . '</hist>';
						}
					}
					$phrase .= "\n\t\t\t</history>";
				}
			}
			$phrase .= "\n\t\t" . '</select>' . "\n\t\t";
			if ($turnSelectFilterOn) {
				$phrase = str_replace("showSelectFilter=\"n\"", "showSelectFilter=\"y\"", $phrase);
			}
			if (strpos($elementSet->item($i)->getAttribute("javascript"), 'filterSelectOptions') > -1) {
				$phrase .= "<script>{$elementSet->item($i)->getAttribute("javascript")}</script>";
			}
		}
		elseif ($elementSet->item($i)->getAttribute("type")=="radio") {
			$usePhrase = false;
			$phrase = '<radio name="' . $elementSet->item($i)->getAttribute("name") . '" label="' . $elementSet->item($i)->getAttribute("label") . "$mandatory\" javascript=\"" . $elementSet->item($i)->getAttribute("javascript") . "\">\n\t\t";
			$defaultPhrase = '<radio name="' . $elementSet->item($i)->getAttribute("name") . '" label="' . $elementSet->item($i)->getAttribute("label") . "$mandatory\" javascript=\"" . $elementSet->item($i)->getAttribute("javascript") . "\">\n\t\t";
			$options = array();
			if (strpos($elementSet->item($i)->getAttribute("source"), ',') > -1) {
				$options = explode(',', $elementSet->item($i)->getAttribute("source"));
				$phrase = '<radio name="' . $elementSet->item($i)->getAttribute("name") . '" label="' . $elementSet->item($i)->getAttribute("label") . "$mandatory\" javascript=\"" . $elementSet->item($i)->getAttribute("javascript") . "\">\n\t\t";
				$optionCount = 0;
				if ($permission == 'r') {
					$defaultPhrase .= "\n\t\t\t" . '<radiooption value="' . $valueArr[$elementSet->item($i)->getAttribute("name")] . '" selected="selected">' . $options[$valueArr[$elementSet->item($i)->getAttribute("name")]] . '</radiooption>';
				}
				else {
					for ($j = 1; $j <= count($options); $j++) {
						$optionCount++;
						if ($j == $valueArr[$elementSet->item($i)->getAttribute("name")]) {
							$selected = ' selected="selected"';
							$usePhrase = true;
						}
						else {
							$selected = '';
						}
						if ($optionCount == 1) {
							$defaultPhrase .= "\n\t\t\t" . '<radiooption value="' . $j . '" selected="selected">' . $options[$j - 1] . '</radiooption>';
						}
						else {
							//echo $elementSet->item($i)->getAttribute("source") . " : $j";
							$defaultPhrase .= "\n\t\t\t" . '<radiooption value="' . $j . '"' . $selected . '>' . $options[$j - 1] . '</radiooption>';
						}
						$phrase .= "\n\t\t\t" . '<radiooption value="' . $j . '"' . $selected . '>' . $options[$j - 1] . '</radiooption>';
					}
					}
			}
			else {
			$criteria = " where 1=1";
			if ($permission=="r") $criteria .= ' and id = ' . $valueArr[$elementSet->item($i)->getAttribute("name")];
			if (!$showDeleted) $criteria .= ' and (deleted = 0 or deleted is null)';
			$query = "select id, " . $elementSet->item($i)->getAttribute("display") . " from " . $elementSet->item($i)->getAttribute("source") . $criteria;
			$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR026 - $query ] "));
			$optionCount = 0;
			while ($row = mysqli_fetch_row($result)) {
				$optionCount++;
				if ($row[0] == $valueArr[$elementSet->item($i)->getAttribute("name")]) {
					$selected = ' selected="selected"';
					$usePhrase = true;
				}
				else {
					$selected = '';
				}
				if ($optionCount == 1) {
					$defaultPhrase .= "\n\t\t\t" . '<radiooption value="' . $row[0] . '" selected="selected">' . $row[1] . '</radiooption>';
				}
				else {
					$defaultPhrase .= "\n\t\t\t" . '<radiooption value="' . $row[0] . '"' . $selected . '>' . $row[1] . '</radiooption>';
				}
				$phrase .= "\n\t\t\t" . '<radiooption value="' . $row[0] . '"' . $selected . '>' . $row[1] . '</radiooption>';
			}
			}
			$phrase .= "\n\t\t" . '</radio>' . "\n\t\t";
			$defaultPhrase .= "\n\t\t" . '</radio>' . "\n\t\t";
			if (!$usePhrase) {
				$phrase = $defaultPhrase;
			}
		}
		$xmlStr[$xmlStrIdx++] = $phrase;
		}
	}
	if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'Made it to creating the hidden fields');
	$prevValues = '';
	if ($action == 'display') {
	//	for ($i = 0; $i < $prevValueIdx; $i++) {
	//		$prevValuesViaDb .= "{$prevValue[$i]}|";
	//	}
	//	if ($prevValueIdx > 0) $prevValuesViaDb = substr($prevValuesViaDb, 0, strlen($prevValuesViaDb) - 1);
		$prevValues = strlen($prevValuesViaDb) > 0 ? substr($prevValuesViaDb, 0, strlen($prevValuesViaDb) - 1) : '';
	}
	else if ($action == 'update' && strlen($errorMsg) == 0) {
		$prevValues = strlen($prevValuesViaUpdate) > 0 ? substr($prevValuesViaUpdate, 0, strlen($prevValuesViaUpdate) - 1) : '';
	}
	else {
		$prevValues = (isset($_POST['prevValues'])) ? $_POST['prevValues'] : '';
	}

	$xmlStr[$xmlStrIdx++] = '
		<hidden name="action" value="' . $nextAction . '" />
		<hidden name="xml" value="'  . $xml  . '" />
		<hidden name="xsl" value="'  . $xsl  . '" />
		<hidden name="selectCriteria" value="'  . $selectCriteria  . '" />
		<hidden name="id" value="'  . $navIds->id  . '" />
		<hidden name="idPosition" value="'  . $navIds->idPosition  . '" />
		<hidden name="idCount" value="'  . $navIds->idCount  . '" />
		<hidden name="minId" value="'  . $navIds->minId  . '" />
		<hidden name="maxId" value="'  . $navIds->maxId  . '" />
		<hidden name="prevValues" value="' . $prevValues . '" />';

	if ($navIds->filtering) $xmlStr[$xmlStrIdx++] = "\n\t\t<hidden name=\"filtering\" />";
	$xmlStr[$xmlStrIdx++] = '
		<script>document.getElementById(\'busy\').style.display = \'none\';
		if (document.getElementById(\'showPreview\')) document.getElementById(\'showPreview\').style.display=\'none\';
		</script>
	</form>
	<hypertext>';
	for ($i = 0; $i < $hypertextSet->length; $i++) {
		$xmlStr[$xmlStrIdx++] = "\n\t{$hypertextSet->item($i)->nodeValue}\n\t";
	}
	$xmlStr[$xmlStrIdx++] =	"\n\t</hypertext>";
	if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'Made it to creating the switches');
	$xmlStr[$xmlStrIdx++] = "\n\t<switches>";
	$phrase = '';
	for ($i = 0; $i < $switchSet->length; $i++) {
		$switchXml = $switchSet->item($i)->getAttribute("xml");
		$switchXmlDoc = new DOMDocument();
		
		getConfigData($switchXmlDoc,"{$switchXml}.xml",7, $linki);
	 
		$switchForm = $switchXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("name");
		$permission = checkPermission('switch', $pagePermission, $user, $switchSet->item($i)->getAttribute("permission"));
//					$_SESSION['debugMsg'] .= logIt($linki, USE_RULES . '/' . $switchesUseRules);
		if (USE_RULES == 2 && $switchesUseRules == 'y') {
			for ($j = 0; $j < $ruleCounter; $j++) {
//						$_SESSION['debugMsg'] .= logIt($linki, SWITCH_PERMISSION);
				// TODO not usre if this is necessary or not, I dont think so as at 1/6/2014
				//if ($ruleArr[$j]->elementName == $switchSet->item($i)->getAttribute("xml")) {
				//	if ($_POST['navigation'] == 'new|-' || $_POST['navigation'] == 'save|0') {
				//		$permission = 'r'; 
				//		break;
				//	}
				//}
				if ($ruleArr[$j]->ruleType == SWITCH_PERMISSION) {
				// Apply Permission to Target as switch when Select element value = Current for Role(s)
//	$_SESSION['debugMsg'] .= logIt($linki, 'subject: ' . $ruleArr[$j]->subjectName . ' xml: ' . $switchSet->item($i)->getAttribute("xml") . ' value of element: ' . $valueArr[$ruleArr[$j]->elementName] . ' ruleFromVal: ' . $ruleArr[$j]->fromValue);
					if ($ruleArr[$j]->subjectName == $switchXml) {
						//$_SESSION['debugMsg'] .= logIt($linki, 'subject: '. $ruleArr[$j]->subjectName . ' element name:  ' . $ruleArr[$j]->elementName);
						//$_SESSION['debugMsg'] .= logIt($linki, 'subject: '. $ruleArr[$j]->subjectName . ' element name:  ' . $ruleArr[$j]->elementName);
						//$_SESSION['debugMsg'] .= logIt($linki, 'from value: ' . $ruleArr[$j]->fromValue . ' actual of element: ' . $valueArr[$ruleArr[$j]->elementName]);
						if (isset($valueArr[$ruleArr[$j]->elementName])) {
//					$_SESSION['debugMsg'] .= logIt($linki, $ruleArr[$j]->fromValue . '/' . $valueArr[$ruleArr[$j]->elementName]);
							if ($ruleArr[$j]->fromValue == $valueArr[$ruleArr[$j]->elementName]) {
								switch ($ruleArr[$j]->permission) {
									case 1: $permission = 'h'; break;
									case 2: $permission = 'r'; break;
									case 3: $permission = 'w'; break;
								}
							}
						}
					}
				}
			}
		}
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "After nav ids: $switchForm");
		// useCurrentId is necessary to tell a transforming XSL to use the current record
		// example is Print Invoice, in pabulumba TODO
		if ($switchSet->item($i)->getAttribute("useCurrentId") == 'y') {
			$tempId = $navIds->id;
			$navigation = 'disp|' . $tempId;
		}
		// TODO i suspect that $tempId is always going to be 0 from here on...
		else if ($switchXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("initialId") == "min") {
			$tempId = 0;//$switchNavIds->minId;
			$navigation = 'min|-';
		}
		else if ($switchXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("initialId") == "new") {
			$tempId = 0;
			$navigation = 'new|-';
		}
		else {
			$tempId = 0;//$switchNavIds->maxId;
			$navigation = $switchXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("initialId") . '|-';
		}
		if ($permission != 'h') {
			// copy  taken before inserting navigation variable
			//$phrase .= "\n\t\t" . '<switch navigation="' . $switchXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("initialId") . '|-" id="' . $tempId . '" xml="' . $switchSet->item($i)->getAttribute("xml") . '" xsl="' . $switchSet->item($i)->getAttribute("xsl") . '" action="' . $switchSet->item($i)->getAttribute("action") . '" permission="' . $permission . '" selectCriteria="' . $switchSet->item($i)->getAttribute("selectCriteria") . '" processParam1="' . $switchSet->item($i)->getAttribute("processParam1") . '" aggregateOn="' . $switchSet->item($i)->getAttribute("aggregateOn"). '" aggregateFunctions="' . $switchSet->item($i)->getAttribute("aggregateFunctions"). '" orderCriteria="' . $switchSet->item($i)->getAttribute("orderCriteria") . '">' . $switchSet->item($i)->nodeValue . '</switch>';
			$phrase .= "\n\t\t" . '<switch navigation="' . $navigation . '" id="' . $tempId . '" xml="' . $switchSet->item($i)->getAttribute("xml") . '" xsl="' . $switchSet->item($i)->getAttribute("xsl") . '" printXsl="' . $switchSet->item($i)->getAttribute("printXsl") . '" action="' . $switchSet->item($i)->getAttribute("action") . '" fileType="' . $switchSet->item($i)->getAttribute("fileType") . '" permission="' . $permission . '" selectCriteria="' . $switchSet->item($i)->getAttribute("selectCriteria") . '" processParam1="' . $switchSet->item($i)->getAttribute("processParam1") . '" aggregateOn="' . $switchSet->item($i)->getAttribute("aggregateOn"). '" aggregateFunctions="' . $switchSet->item($i)->getAttribute("aggregateFunctions"). '" orderCriteria="' . $switchSet->item($i)->getAttribute("orderCriteria") . '">' . $switchSet->item($i)->nodeValue . '</switch>';
		}
	}
	$phrase .= "\n\t\t" . '<switch navigation="none|-" xml="main" xsl="' . XSL_TEMPLATE . '" action="processLogout" processParam1="n" permission="wwwwwwwwww">=== Logout ===</switch>';
	$xmlStr[$xmlStrIdx++] = $phrase . "\n\t" . '</switches>

	<reports>';
	$phrase = '';
	for ($i = 0; $i < $reportSet->length; $i++) {
		$permission = checkPermission('report', 'w', $user, $reportSet->item($i)->getAttribute("permission"));
		if ($permission != 'h') {
			$phrase .= "\n\t\t" . '<report xml="none-necessary" reportId="' . $reportSet->item($i)->getAttribute("reportId") . '" xsl="' . $reportSet->item($i)->getAttribute("xsl") . '" action="' .  $reportSet->item($i)->getAttribute("action"). '">';
			$phrase .= $reportSet->item($i)->nodeValue;
			$phrase .= "</report>";
		}
	}
	$xmlStr[$xmlStrIdx++] = $phrase . "\n\t" . '</reports>

	<links>';
	$phrase = '';
	for ($i = 0; $i < $linkSet->length; $i++) {
		$permission = checkPermission('link', 'w', $user, $linkSet->item($i)->getAttribute("permission"));
		if ($permission != 'h') {
			$phrase .= "\n\t\t" . '<link label="' . $linkSet->item($i)->getAttribute("label") . '" value="' .  $linkSet->item($i)->getAttribute("value"). '"/>';
		}
	}
	if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Time taken (usec): " . (int)((microtime(true) - $time_start) * 1000));
	$timeTaken = '';
	if (SHOW_PAGE_PROCESS_TIME == 2) {
		$timeTaken = ' Page processed in ' . ((int)((microtime(true) - $time_start) * 1000)) . ' usec';
	}
	$xmlStr[$xmlStrIdx++] = $phrase . "\n\t" . '</links>


	<information>
		<info name="userName">' . $user->userFullName . "&#160;&#160;&#160;&#160;$timeTaken" . '</info>
		<info name="userId">' . $user->userId . '</info>
	</information>';



	$xmlStr[$xmlStrIdx++] = "\n\t<debugMessages>{$_SESSION['debugMsg']}\n\t</debugMessages>";
$xmlStr[$xmlStrIdx++] = "\n</doc>";
if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Echoing the strings to the screen");
header("Content-type: application/xml");
for ($i = 0; $i < $xmlStrIdx; $i++) echo $xmlStr[$i];
}
//}}}

close_db($linki);


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//    UPGRADE SCRIPTS 
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/*
	


*/
function pad($str, $side, $char, $count) {
	if ($side == 'l') {
		while (strlen($str) < $count) {
			$str = $char . $str;
		}
	}
	else {
		while (strlen($str) < $count) {
			$str .= $char;
		}
	}
	return $str;
}

function encode($s) {
	$encodedStr = '';
	for ($i = 0; $i < strlen($s); $i++) {
		$encodedStr .= toHex8In(pad(decbin(ord(substr($s, $i, 1))), 'l', '0', 8));
	}
	return $encodedStr;
}

function toHex8In($str) {
	$hexHigh = substr($str, 0, 4);
	$hexLow = substr($str, 4);
	return toHex4In($hexHigh) . toHex4In($hexLow);
}

function toHex4In($str) {
	$hex = substr($str, 0, 4);
	$value = 0;
	for ($i = 3; $i > -1; $i--) {
		$value += substr($hex, 3 - $i, 1) * pow(2, $i);
	}
	if ($value < 10) return $value;
	else if ($value == 10) return 'A';
	else if ($value == 11) return 'B';
	else if ($value == 12) return 'C';
	else if ($value == 13) return 'D';
	else if ($value == 14) return 'E';
	else if ($value == 15) return 'F';
}

function buildMenu($menuItemSet, $user, $pagePermission, $linki) {
	$xmlStr = "\n\t<menu>";
	for ($i = 0; $i < $menuItemSet->length; $i++) {
		$menusXml = $menuItemSet->item($i)->getAttribute("xml");
		$menusXmlDoc = new DOMDocument();
		getConfigData($menusXmlDoc,"{$menusXml}.xml",8, $linki);
		/*
		if (CONFIG_SOURCE == 1) { 
			$query = "select configText from config where id = '{$menusXml}.xml'";
			$result = mysqli_query($query);
			$menusXmlDoc->loadXML(mysqli_result($result,0,0));
		}
		else {
			$menusXmlDoc->load("config/{$menusXml}.xml");
		}*/
		$menusForm = $menusXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("name");
		//if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "NewNav - building the menus for $menusForm");
		$permission = checkPermission('menuItem', $pagePermission, $user, $menuItemSet->item($i)->getAttribute("permission"));
		//if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Build menu permissions (page perm / input perm / generated perm): $pagePermission {$menuItemSet->item($i)->getAttribute("permission")} $permission ");
		if ($menusXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("initialId") == "min") {
			$tempId = 0; 
		}
		else if ($menusXmlDoc->getElementsByTagName("form")->item(0)->getAttribute("initialId") == "new") {
			$tempId = 0;
		}
		else $tempId = 0;
		$xmlStr .= "\n\t\t<menuItem id=\"{$tempId}\" xml=\"{$menuItemSet->item($i)->getAttribute("xml")}\" xsl=\"{$menuItemSet->item($i)->getAttribute("xsl")}\" selectCriteria=\"{$menuItemSet->item($i)->getAttribute("selectCriteria")}\" permission=\"{$permission}\">{$menuItemSet->item($i)->nodeValue}</menuItem>";
	}
	$xmlStr .= "\n\t" . '</menu>';
	return $xmlStr;
}


function buildFilter(&$elementSet, $showDeleted, $arr, &$user, &$form, &$configXmlDoc, $linki, $reportAction) {
	//$atLeastOneGridExists = false;
	$pagePermission = '';
	$pagePermission = checkPermission('page', $pagePermission, $user, $configXmlDoc->getElementsByTagName("page")->item(0)->getAttribute("permission"));
	$phrase = "<filter>";
	$postedValue = "";
	$postedValueFrom = "";
	$postedValueTo = "";
	$filteredOptions = '';
/*
		$xpQuery = '/doc/form/element[@type="grid"]/@source';
		$dataset2 = $xpath->query($xpQuery);
		$filterByGridUser = 0;
		$gridSource = '';
		if ($dataset2->length > 0) {
			$gridSource = $dataset2->item(0)->nodeValue;
			$gridXmlDoc = new DOMDocument();
			getConfigData($gridXmlDoc,"{$gridSource}.xml",9.5);
			$xpQuery2 = '/doc/form/element[@filterByUser="y"]';
			$xpath2 = new DOMXPath($gridXmlDoc);
			$dataset3 = $xpath2->query($xpQuery2);
			$filterTableName = $dataset3->item(0)->getAttribute("name");
			$filterByGridUser = 1;
		}
 */		
	if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'Entered method `buildFilter\': ' . $elementSet->length);
	for ($i = 0; $i < $elementSet->length; $i++) {
		$postedValue = "";
		$permission = checkPermission('element', $pagePermission, $user, $elementSet->item($i)->getAttribute("permission"));
		if ($permission != 'h') {
		//
		// if a value is returned from the on-screen filter, the name and value are appended to the filteredOptions string, e.g.:
		//     deleted = 1
		// The NoFilter option has a value of -1
		//
		if (isset($_POST[$elementSet->item($i)->getAttribute("name")])) {
			$postedValue = $_POST[$elementSet->item($i)->getAttribute("name")];
			//$postedValue = '';
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Postey value: " . $postedValue);
			if ($postedValue != -1) {
				if ($elementSet->item($i)->getAttribute("type")=="input"){
					if (strlen($postedValue) > 0) {
						$filteredOptions .= "$form.{$elementSet->item($i)->getAttribute("name")} like '{$postedValue}' and ";
					}
				}
				else {
					$filteredOptions .= "$form.{$elementSet->item($i)->getAttribute("name")} = '$postedValue' and ";
				}
			}
		}
		else {
			// 
			// dates within the filter are duplicated with a (from) and a (to), for obvious reasons
			//
			if (isset($_POST[$elementSet->item($i)->getAttribute("name") . '_from'])) {
				$postedValueFrom = ($reportAction == 'clear') ? '' : $_POST[$elementSet->item($i)->getAttribute("name") . '_from'];
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "posted value from: " . $postedValueFrom);
				if ($postedValueFrom != '') {
					$filteredOptions .= "{$elementSet->item($i)->getAttribute("name")} >= '" . formatDateFor('databaseExPost',$postedValueFrom) . "' and ";
				}
			}
			if (isset($_POST[$elementSet->item($i)->getAttribute("name") . '_to'])) {
				$postedValueTo = ($reportAction == 'clear') ? '' : $_POST[$elementSet->item($i)->getAttribute("name") . '_to'];
				if ($postedValueTo != '') {
					$filteredOptions .= "{$elementSet->item($i)->getAttribute("name")} &lt;= '" . formatDateFor('databaseExPost',$postedValueTo) . "' and ";
				}
			}
		}
		//
		// the values for select and radio options need to be put inside the filter
		//
		if ($reportAction == 'clear') $postedValue = '';
		if ($elementSet->item($i)->getAttribute("type")=="select" || $elementSet->item($i)->getAttribute("type")=="radio"){

			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'Filtered Options: ' . mysqli_real_escape_string($linki, $filteredOptions));
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'Creating a select field for ' . $elementSet->item($i)->getAttribute("name") . ', with postvalue of ' . $postedValue);
			$options = array();

			// get options from the comma-separated list in source attribute

			if (strpos($elementSet->item($i)->getAttribute("source"), ',') > -1) {
				$options = explode(',', $elementSet->item($i)->getAttribute("source"));
				$phrase .= "\n\t\t\t" . '<select name="' . $elementSet->item($i)->getAttribute("name") . '" label="' . $elementSet->item($i)->getAttribute("label") . "\" javascript=\"" . $elementSet->item($i)->getAttribute("javascript") . "\">\n\t\t";
				$phrase .= "\n\t\t\t\t<option value='-1'>No filter</option>";
				for ($j = 1; $j <= count($options); $j++) {
					if ("$j" === $postedValue) $selected = ' selected="selected"'; else $selected = '';
					if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'contents of j/pv/selected: ' . "[$j] [$postedValue] [$selected]");
					$phrase .= "\n\t\t\t\t" . '<option value="' . $j . '"' . $selected . '>' . $options[$j -1] . '</option>';
				}
			}
			else {

				// get options from the source table and restrict by user if asked for

				$phrase .= "\n\t\t\t<select name=\"{$elementSet->item($i)->getAttribute("name")}\" label=\"{$elementSet->item($i)->getAttribute("label")}\" javascript=\"{$elementSet->item($i)->getAttribute("javascript")}\">";
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'Setting No Filter option: 1. filterByUser: ' . $elementSet->item($i)->getAttribute("filterByUser") . ', 2. userRoleRefNo:  ' . $user->userRoleRefNo);
				$phrase .= "\n\t\t\t\t<option value='-1'>No filter</option>";
				$criteria = " where 1=1";
				if ($elementSet->item($i)->getAttribute("filterByUser") == 'y') {
					$criteria .= " and id in (select {$elementSet->item($i)->getAttribute("name")} from {$elementSet->item($i)->getAttribute("name")}_user where user = {$user->userId})";
				}
				if (strlen($elementSet->item($i)->getAttribute("selectCriteria")) > 0) {
					$selectCriteria = preg_replace('/\[CURRENT_USER_ID\]/', $user->userId, $elementSet->item($i)->getAttribute("selectCriteria"));
					$criteria .= $selectCriteria;
				}
				if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'Creating a select query z: ' . $criteria);
				if (!$showDeleted) $criteria .= ' and deleted = 0';
				// TODO don't think the order by is necessary here
				$criteria .= ' order by ' . $elementSet->item($i)->getAttribute("display");
				$query = "select id, " . $elementSet->item($i)->getAttribute("display") . ", deleted from " . $elementSet->item($i)->getAttribute("source") . $criteria;
				$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $_SESSION['userId' . PABULUMBA_INSTANCE_ID], mysqli_error($linki) . " [ERR027 - $query ] "));
				while ($row = mysqli_fetch_row($result)) {
					if ($row[2] == '1') $deletedSymbol = '[-] '; else $deletedSymbol = '';
					if ($row[0] == $postedValue && strlen($postedValue) != 0) $selected = ' selected="selected"'; else $selected = '';
					if ($row[2] != '1' || $selected) {
						$phrase .= "\n\t\t\t\t" . '<option value="' . $row[0] . '"' . $selected . '>' . $deletedSymbol . htmlspecialchars($row[1]) . '</option>';
					}
				}
			}
			$phrase .= "\n\t\t\t" . '</select>' . "\n\t\t";
		}
		else if ($elementSet->item($i)->getAttribute("type")=="input" && $elementSet->item($i)->getAttribute("validate")=="date") {
			//$showCalendar = '';
			//if ($elementSet->item($i)->getAttribute("validate")=="date") {
			$showWindow = 'calendar';
				$calendarVarArr = explode('|', getCalendarVariables());
			//}
			//else {
			//	$showCalendar = 'n';
			//	$calendarWindowString = ""; 
			//}
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "posted value from2: " . $postedValueFrom);
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "posted value from3: " . formatDateFor('displayExPost',$postedValueFrom));
			$phrase .= "\n\t\t\t" . '<input name="' . $elementSet->item($i)->getAttribute("name") . '_from"' . ' showWindow="calendar" value="' . formatDateFor('displayExPost', $postedValueFrom) . '" size="'. $elementSet->item($i)->getAttribute("maxSize") . '" label="'. $elementSet->item($i)->getAttribute("label") . ' (from) [use for updating]"'; 
			// TODO always going to be calendar
			if ($showWindow == 'calendar') {
				$phrase .= " calDateArr=\"{$calendarVarArr[0]}\" calDayNum=\"{$calendarVarArr[4]}\" calMonthNum=\"{$calendarVarArr[1]}\" calYear=\"{$calendarVarArr[2]}\" calRange=\"{$calendarVarArr[3]}\" calFormat=\"" . DATE_FORMAT . "\" calSeparator=\"" . getDateSeparator() . "\"";
			}
			$phrase .= '/>' . "\n\t\t";
			$phrase .= '<input name="' . $elementSet->item($i)->getAttribute("name") . '_to"' . ' showWindow="calendar" value="' . formatDateFor('displayExPost', $postedValueTo) . '" size="'. $elementSet->item($i)->getAttribute("maxSize") . '" label="'. $elementSet->item($i)->getAttribute("label") . ' (to)"';
			// TODO always going to be calendar
			if ($showWindow == 'calendar') {
				$phrase .= " calDateArr=\"{$calendarVarArr[0]}\" calDayNum=\"{$calendarVarArr[4]}\" calMonthNum=\"{$calendarVarArr[1]}\" calYear=\"{$calendarVarArr[2]}\" calRange=\"{$calendarVarArr[3]}\" calFormat=\"" . DATE_FORMAT . "\" calSeparator=\"" . getDateSeparator() . "\"";
			}
			$phrase .= '/>' . "\n\t\t";
		}
		// Uncomment the next lines to include input boxes as part of the filter

		else if ($elementSet->item($i)->getAttribute("type")=="input" && $elementSet->item($i)->getAttribute("validate") != "date") {
			$phrase .= "\n\t\t\t" . '<input name="' . $elementSet->item($i)->getAttribute("name") . '" value="' . $postedValue . '" size="'. $elementSet->item($i)->getAttribute("maxSize") . '" label="'. $elementSet->item($i)->getAttribute("label") . '"'; 
			$phrase .= '/>' . "\n\t\t";
		}
		else if ($elementSet->item($i)->getAttribute("type")=="checkbox") {
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Post2 value: " . $postedValue);
			if (strlen($postedValue) == 0) $postedValue = -1;
			$phrase .= "\n\t\t\t<select name=\"{$elementSet->item($i)->getAttribute("name")}\" label=\"{$elementSet->item($i)->getAttribute("label")}\" >";
			$optionArray = array('No filter','No','Yes');
			for ($j = -1; $j < 2; $j++) {
				$phrase .= "\n\t\t\t\t<option value=\"{$j}\"";
				if ($postedValue == $j) $phrase .= ' selected="selected"';
				$phrase .= ">{$optionArray[$j + 1]}</option>";
			}
			$phrase .= "\n\t\t\t</select>\n\t\t";
			// TODO does this next line do anything useful at all?
		}
		//if ($elementSet->item($i)->getAttribute("type")=="grid") {
		//	$atLeastOneGridExists = true;
		//}
	} // end of checking if permission = 'h'
	}
	if (substr($filteredOptions, -5) == ' and ') {
		$filteredOptions = substr($filteredOptions, 0, strlen($filteredOptions) - 5);
	}
//if ($atLeastOneGridExists) {
//	if (isset($_POST['excludeGridData'])) $excludeGridData = '1';
//	else $excludeGridData = '0';
//	$phrase .= "\n\t\t\t<checkbox id=\"excludeGridData\" name=\"excludeGridData\" value=\"{$excludeGridData}\" label=\"Exclude grid data\" permission=\"w\" />";
//}
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Filtered options (from filter): " . $filteredOptions);
	return $phrase .= "\n\t\t</filter>\n\t\t<filteredOptions>\n\t\t\t{$filteredOptions}\n\t\t</filteredOptions>";
}



function displayErrorPage($linki, $userId, $msg) {
	$query = "update user set session_id = '' where id = $userId"; // . $processParam->userId;
	mysqli_query($linki, $query);
	$xmlStr = '<?xml version="1.0" encoding="UTF-8"?>
	<?xml-stylesheet href="config/pabulumba.xsl" type="text/xsl"?>
	<doc><login msg="' . $msg . '"/></doc>';
	header("Content-type: application/xml");
	echo $xmlStr;
	exit();
}

	// for some reason, the xml declaration triggers something in the syntax highlighting that does this! Please leave next line alone
	// \<?

function checkPermission($permType, $pagePermission, $user, $permissionStr) {
	$permission = '';
	//if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Permission parameters: $permType | $user->userRoleRefNo | $permissionStr");
	$userRefNo = $user->userRoleRefNo;
	if ($userRefNo > strlen($permissionStr)) {
		displayErrorPage($linki, $user->userId,"A role exists for which there are no corresponding permissions.");
	}
	//if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'Value of permission: ' . substr($permissionStr, $userRefNo, 1));
	$permission = substr($permissionStr, $userRefNo, 1);
	if (($permType == 'element' || $permType == 'switch' || $permType == 'menuItem' || $permType == 'report' || $permType == 'link') && $pagePermission == 'r') {
		if ($permission == 'h') $permission = 'h';
		else $permission = 'r';
	}
	return $permission;
}


function validate($value, $valType, $mandatory, $maxSize, $label, &$messageArr) {
	$value = htmlspecialchars_decode($value);

	if (strlen(trim($value)) > $maxSize) {
		if ($valType == 'filename') return 'File name (' . $value . ') has ' . strlen(trim($value)) . ' characters. It is restricted to ' . $maxSize;
		else return 'Field (' . $label . ') has too many characters (' . strlen(trim($value)) . ') for field size of ' . $maxSize;
	}
	if ($mandatory == "y") {
		if (strlen(trim($value)) == 0) {
			//return "Mandatory field ($label) is currently empty";
			return str_replace('[X]', $label, $messageArr[4]);
		}
	}
	elseif ($mandatory == "n") {
		if (strlen(trim($value)) == 0) {
			return '';
		}
	}
	switch ($valType) {
		case 'none': return ''; break;
		case 'tree':
			break;
			// TODO next case not necessary
		//case 'quarterYear':
		//	if ($value == '' or (preg_match('/^Q[1-4]20\d\d\d\d/', $value) && $value != 'null')) {
		//		return '';
		//	}
		//	else {
		//		return "Field ($label) must be formatted as per this example: Q3201011, meaning the third quarter in financial year 2010/2011";
		//	}
		//	break;
		case 'filename':
			if (preg_match('/[^0-9a-zA-Z\(\)\[\]._-]/', $value) && $value != 'null') {
				return "The file name ($value) must only contain numbers, letters, full-stops, underscores, hyphens, or brackets";
			}
			break;
		case 'url':
			if ((preg_match('/^http:\/\//', $value) || preg_match('/file:\/\//', $value)) && $value != 'null') {
				return '';
			}
			else {
				return "The URL ($value) must begin with 'http://' or 'file://'";
			}
			break;
		case 'email':
			if (preg_match('/[^0-9a-zA-Z@\._;-]/', $value) && $value != 'null') {
				return "Field ($label) must only contain numbers, letters, full-stops, hyphens, semi-colons, or underscores";
			}
			if (preg_match('/^.+@.+\..+$/', $value) && $value != 'null') {
				return '';
			}
			else {
				return "Field ($label) does not appear to be a valid email address";
			}
			break;
		case 'sentence':
			//$_SESSION['debugMsg'] .= logIt($linki, "pattern: " . SENTENCE_PATTERN);
			if (preg_match('/[^\n\r0-9a-zA-Z' . SENTENCE_PATTERN . '!@#$%^&*()_+-={}[\]|\\\\:;"\'<>?,.\/~` ]/', $value) && $value != 'null') {
				return "Field ($label) must only contain characters found on a normal keyboard";
			}
			else {
				return '';
			}
			break;
		case 'integer':
			if (preg_match('/[^-0-9]/', $value) && $value != 'null') {
				return "Field ($label) must only contain numbers or the negative sign";
			}
			if (preg_match('/..*-/', $value)) {
				return "Field ($label) contains a negative sign in the wrong position";
			}
			if ($value == "-") {
				return "Field ($label) contains only a negative sign";
			}
			else {
				return '';
			}
			break;
		case 'decimal':
			if (preg_match('/[^-0-9\.]/', $value) && $value != 'null') {
				return "Field ($label) must only contain numbers, the decimal point, or the negative sign";
			}
			if (preg_match('/\..*\./', $value) && $value != 'null') {
				return "Field ($label) contains too many decimal points";
			}
			if ($value == ".") {
				return "Field ($label) contains only a decimal point";
			}
			if (preg_match('/..*-/', $value)) {
				return "Field ($label) contains a negative sign in the wrong position";
			}
			if ($value == "-") {
				return "Field ($label) contains only a negative sign";
			}
			else {
				return '';
			}
			break;
		case 'selection':
			if ($value == '-694') {
				return str_replace('[X]', $label, $messageArr[5]);
			}
			break;
		case 'character':
			if (preg_match('/[^A-Za-z]|^.{2,}$/', $value) && $value != 'null') {
				return "Field ($label) must only contain a single letter";
			}
			else {
				return '';
			}
			break;
		case 'date':
			// TODO get this from the constants out of settings
			//$query = "select dateSeparator from setting where id = 1";
			//$result = mysqli_query($query) or die(displayErrorPage($_SESSION['userId' . PABULUMBA_INSTANCE_ID], mysqli_error($linki) . " [ERR039 - $query ] "));
			//if (mysqli_result($result, 0) == 0) {
			if (getDateSeparator() == '/') {
				$dateSeparator = '/';
				$regEx = "/^\d{1,2}\/\d{1,2}\/\d{4}$/";
			}
			else {
				$dateSeparator = '-';
				$regEx = "/^\d{1,2}-\d{1,2}-\d{4}$/";
			}
			if (preg_match($regEx, $value) && $value != 'null') {
				$dateArr = explode($dateSeparator, $value);
				$year = $dateArr[2];
				if (DATE_FORMAT == 1) {
					$month = $dateArr[1];
					$day = $dateArr[0];
				}
				elseif (DATE_FORMAT == 2) {
					$month = $dateArr[0];
					$day = $dateArr[1];
				}
				if (checkdate($month,$day,$year) || ($day == '00' && $month = '00' && $year == '0000')) {
					return '';
				}
				else {
					return "Field ($label) is not a valid date";
				}
			}
			else {
				return "Field ($label) must be a complete date";
			}
			break;
		default:
			return 'Unknown validation type';
	}
}

function buildDuplicateQuery(&$id, &$form, &$elementSet) {
	$duplicateQuery = "insert into $form (";
	$duplicateQueryFieldNames = '';
	$updateQuery = '';
	for ($i = 0; $i < $elementSet->length; $i++) {
		$duplicateQueryFieldNames .= $elementSet->item($i)->getAttribute("name");
		if ($i != ($elementSet->length - 1)) {
			$updateQuery .= ", ";
			$duplicateQueryFieldNames .= ", ";
		}
	}
	$duplicateQuery .= $duplicateQueryFieldNames . ") select " . $duplicateQueryFieldNames . " from $form where id = $id";
	return $duplicateQuery;
}

/*
function escapeChars($text) {
	return $text;
}

// replaced this function with htmlspecialchars - delete after a while
function unEscapeChars($text) {
	$text = str_replace('&', '&amp;', $text);
	$text = str_replace('<', '&lt;', $text);
	$text = str_replace('\'', '&apos;', $text);
	$text = str_replace('"', '&quot;', $text);
	return $text;
}
 */


function logIt($linki, $msg) {
	$query = "insert into log (action_time, user, query) values (now(), 1, '" . mysqli_real_escape_string($linki, $msg) . "')";
		mysqli_query($linki, $query) or die(mysqli_error($linki) . " Msg passed was: $query");
	return "<msg><![CDATA[" . htmlspecialchars($msg) . "]]></msg>";
}

function getDateSeparator() {
	switch (DATE_SEPARATOR) {
	case 1: return '/'; break;
	case 2: return '-'; break;
	}
}

function getSQLDateFormatStr() {
	$dateSeparator = getDateSeparator();
	$formatStr = '';
	if (DATE_FORMAT == 1) {
		$formatStr = "%e{$dateSeparator}%m{$dateSeparator}%Y";
	}
	elseif (DATE_FORMAT == 2) {
		$formatStr = "%m{$dateSeparator}%e{$dateSeparator}%Y";
	}
	return $formatStr;
}

function formatDateFor($displayOrDb, $dateStr) {
	$dateSeparator = getDateSeparator();
	if ($dateSeparator == '/') {
		//$dateSeparator = '/';
		$regExMedium = '/^\d{1,2}\/\d{1,2}$/';
		$regExLong = "/^\d{1,2}\/\d{1,2}\/\d{4}$/";
	}
	else {
		//$dateSeparator = '-';
		$regExMedium = '/^\d{1,2}-\d{1,2}$/';
		$regExLong = "/^\d{1,2}-\d{1,2}-\d{4}$/";
	}
	if ($displayOrDb == 'displayExDb') {
		$dateArr = array();
		$dateArr = explode("-", $dateStr);
		if (sizeof($dateArr) == 3) {
			$year = $dateArr[0];
			$month = $dateArr[1];
			$day = $dateArr[2];
			if (DATE_FORMAT == 1) {
				return "{$day}{$dateSeparator}{$month}{$dateSeparator}{$year}";
			}
			elseif (DATE_FORMAT == 2) {
				return "{$month}{$dateSeparator}{$day}{$dateSeparator}{$year}";
			}
		}
		else {
			return "** bad date **";
		}
	}
	else if ($displayOrDb == 'databaseExPost') {
		$today = getdate();
		if ($dateStr == 't') {
			return "{$today['year']}-{$today['mon']}-{$today['mday']}";
		}
		else if (preg_match('/^\d{1,2}$/', $dateStr)) {
			return "{$today['year']}-{$today['mon']}-{$dateStr}";
		}
		else if (preg_match($regExMedium, $dateStr)) {
			$dateArr = explode($dateSeparator, $dateStr);
			return "{$today['year']}-{$dateArr[1]}-{$dateArr[0]}";
		}
		else if (preg_match($regExLong, $dateStr)) {
			$dateArr = explode($dateSeparator, $dateStr);
			$year = $dateArr[2];
			if (DATE_FORMAT == 1) {
				$month = $dateArr[1];
				$day = $dateArr[0];
			}
			elseif (DATE_FORMAT == 2) {
				$month = $dateArr[0];
				$day = $dateArr[1];
			}
			return "{$year}-{$month}-{$day}";
		}
		else {
			return $dateStr;
		}
	}
	else if ($displayOrDb == 'displayExPost') {
		$today = getdate();
		if ($dateStr == 't') {
			if (DATE_FORMAT == 1) {
				return "{$today['mday']}{$dateSeparator}{$today['mon']}{$dateSeparator}{$today['year']}";
			}
			elseif (DATE_FORMAT == 2) {
				return "{$today['mon']}{$dateSeparator}{$today['mday']}{$dateSeparator}{$today['year']}";
			}
		}
		else if (preg_match('/^\d{1,2}$/', $dateStr)) {
			if (DATE_FORMAT == 1) {
				return "{$dateStr}{$dateSeparator}{$today['mon']}{$dateSeparator}{$today['year']}";
			}
			elseif (DATE_FORMAT == 2) {
				return "{$today['mon']}{$dateSeparator}{$dateStr}{$dateSeparator}{$today['year']}";
			}
		}
		else if (preg_match($regExMedium, $dateStr)) {
			return "{$dateStr}{$dateSeparator}{$today['year']}";
		}
		else return $dateStr;
	}
}

function formatDateTime($dateStr) {
	$dateSeparator = getDateSeparator();
	$dateArr = array();
	$arr = array();
	$arr = explode(" ", $dateStr);
	$dateArr = explode("-", $arr[0]);
	$time = $arr[1];
	$year = $dateArr[0];
	$month = $dateArr[1];
	$day = $dateArr[2];

	return "{$day}{$dateSeparator}{$month}{$dateSeparator}{$year} at $time";
	//return "{$day}{$dateSeparator}{$month}{$dateSeparator}{$year}";
}

function getNewRandomString($length) {
	$letters = array('a','b','c','d','e','f','g','h','i','j','k','m','n','p','q','r','s','t','u','v','w','x','y','z', 'A','B','C','D','E','F','G','H','J','K','L','M','N','P','Q','R','S','T','U','V','W','X','Y','Z', '2', '3', '4', '5', '6', '7', '8', '9');
	$string = '';
	for ($i = 0; $i < $length; $i++) {
		$randval = rand(0, 55);
		$string .= $letters[$randval];
	}
	return $string;
}

class ProcessParam {
	public $user;
	public $param1;
	public $navIds;
	public $jumped;
	public $form;
	public $returnString = '';
	public $linki;
	/*public $recordId;
	public $param1;
	public $database;
	public $returnInteger;
	public $returnString;*/

	function ProcessParam($user, $param1, $navIds, $jumped, $form, $linki) {
		$this->user = $user;
		$this->param1 = $param1;
		$this->navIds = $navIds;
		$this->jumped = $jumped;
		$this->form = $form;
		$this->linki = $linki;
	}
}

// this class is duplicated in `preview.php'  If it changes here, please change there as well

class User {
	public $userId;
	public $userName;
	public $userFullName;
	public $userRoleRefNo;

	function User($userId, $linki) {
		$this->userId = $userId;
		$this->userRoleRefNo = 0;
		$query = "select username, full_name, role_ref_no from user inner join role on user.role = role.id where user.id = $userId";
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Creating user query: " . $query);
		$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $userId, mysqli_error($linki) . " [ERR028 - $query ] "));
		$row = mysqli_fetch_row($result);
		$this->userName = htmlspecialchars($row[0]);
		$this->userFullName = htmlspecialchars($row[1]);
		$this->userRoleRefNo = htmlspecialchars($row[2]);
	}
}

// {{{ class NavigationIds
class NavigationIds {
	public $id;
	public $minId;
	public $maxId;
	public $idPosition;
	public $idCount;
	public $newRecord = false;
	public $filtering = false;

	function NavigationIds($form, $user, $selectCriteria, $linki) {
		if (isset($_SESSION['gridIds'][$form]) && strpos($_SESSION['gridIds'][$form], " and {$form}.id") > -1) {
			$this->filtering = true;
			$selectCriteria .= $_SESSION['gridIds'][$form];
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "We are in the same form for filtering: {$form}");
		}
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Session grid ids/criteria:" . $selectCriteria);
		$id = 0;
		// the idea is to completely get rid of passing the id in here,
		// because the function should be able to determine either min or max if the
		// id = '-' or a relative id if the function is 
		// ergo: work out min or max first; that then becomes the id for the rest of the functions

		// some config files such as help/main/reports which do not directly access a db nevertheless
		// (due to bad programming) require a dummy table to pretend to write to - this next handles this situation

		if (isset($_POST['navigation'])) {
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Posted navigation:" . $_POST['navigation']);
			$navigation = explode('|', $_POST['navigation']);
			$navAction = $navigation[0];
			if ($form == 'search' && !isset($navigation[1])) {
				$navId = 1;
			}
			else {
				$navId = $navigation[1];
			}
			if (isset($navigation[2])) {
				$this->filtering = false;
				// TODO is it possible that clearing this will stop any filtering - it's coming from the nav, not the xml...
				$selectCriteria = '';
				$_SESSION['gridIds'][$form] = '';
			}
		}
		else {
			echo "System problem - no navigation action set"; exit;
		}

		if ($form == 'dummy' || $navAction == 'none') {
			$this->minId = 0;
			$this->maxId = 0;
			$this->idPosition = 0;
			$this->idCount = 0;
			
			return;
		}
		elseif ($navAction == 'new') {
			$this->id = 0;
		}
		elseif ($navAction == 'disp' || $navAction == 'save' || $navAction == 'dupl') {
			$this->id = $navId;
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Id on clicking save: {$this->id}");
		}

		$userId = $user->userId;
		$userRoleRefNo = $user->userRoleRefNo;

		$filterByUser = 0;
		$filterTableName = '';

		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "NavId here1: {$this->id}");

		// open the form's XML doc and see if any element exists which has `filterByUser' set to `y'
		// it's possible that this is going to return more than one result TODO make sure that only one result
		// is ever returned
		//
		$configXmlDoc = new DOMDocument();
		getConfigData($configXmlDoc,"{$form}.xml",9, $linki);

		// Having got the config data, check for grids, and get the config data for the grid's source
		// If any grid's source elements equal filterByUser, then get the name  of that element

		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Opening {$form}.xml");
		$xpath = new DOMXPath($configXmlDoc);
		$xpQuery = '/doc/form/element[@filterByUser="y"]';
		$dataset = $xpath->query($xpQuery);

		$filterByUser = $dataset->length;
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Dataset length: $filterByUser");
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "User-role: $userRoleRefNo");

		$xpQuery = '/doc/form/element[@type="grid"]/@source';
		$dataset2 = $xpath->query($xpQuery);
		$filterByGridUser = 0;
		$gridSource = '';
		if ($dataset2->length > 0) {
			$gridSource = $dataset2->item(0)->nodeValue;
			$gridXmlDoc = new DOMDocument();
			getConfigData($gridXmlDoc,"{$gridSource}.xml",9.5, $linki);
			$xpQuery2 = '/doc/form/element[@filterByUser="y"]';
			$xpath2 = new DOMXPath($gridXmlDoc);
			$dataset3 = $xpath2->query($xpQuery2);
			if ($dataset3->length > 0) {
				$filterTableName = $dataset3->item(0)->getAttribute("name");
				$filterByGridUser = 1;
			}
		}
		if ($filterByUser > 0) {
			$filterTableName = $dataset->item(0)->getAttribute("name");
			if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "We are filtering by user using {$filterTableName}_user");
		}

		// the six values returned by the superquery are:
		// MIN,	MAX, COUNT
		// PREV or NEXT, 0, 0

// get the 'min', max and count:
//$asdf='';
		if ($filterByUser > 0) {
			$query = "select min({$form}.id), max({$form}.id), count({$form}.id) from $form";
			$query .= " where {$form}.{$filterTableName} in (select $filterTableName from {$filterTableName}_user where user = $userId) $selectCriteria";
		}
		elseif ($filterByGridUser > 0) {
			$query = "select min(distinct {$form}.id), max(distinct {$form}.id), count(distinct {$form}.id) from $form";
		       	$query .= " inner join $gridSource on user.id = {$gridSource}.user where $filterTableName in (select $filterTableName from {$filterTableName}_user where user = $userId)";
			//$asdf = $query;
			//$_SESSION['debugMsg'] .= logIt($linki, "Total: " . mysqli_result(mysqli_query('select count(id) from user'), 0, 0));
			//$_SESSION['debugMsg'] .= logIt($linki, "Total2: " . mysqli_result(mysqli_query('select count(user.id) from user inner join user_group on user.id = user_group.user where group_table = 15'), 0, 0));
			//$_SESSION['debugMsg'] .= logIt($linki, "Count u/g: " . mysqli_result(mysqli_query('select count(user_group.id) from user_group where group_table = 15'), 0, 0));
			//$_SESSION['debugMsg'] .= logIt($linki, "Min: " . mysqli_result(mysqli_query($query), 0, 0));
			//$_SESSION['debugMsg'] .= logIt($linki, "Max: " . mysqli_result(mysqli_query($query), 0, 1));
			//$_SESSION['debugMsg'] .= logIt($linki, "Count: " . mysqli_result(mysqli_query($query), 0, 2));
			$query .= $selectCriteria;
			//if (strlen($selectCriteria) > 0) exit; 
		}
		else {
			$query = "select min(id), max(id), count(id) from $form where 1=1 $selectCriteria";
		}

		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Min, Max, Count query: {$query}");
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "NavId here2: {$this->id}");
		$superquery = $query;

		if ($navAction == 'prev') {
			if ($filterByUser > 0) {
				$query = "select max({$form}.id),0,0 from $form where {$form}.id < {$navId}";
				$query .= " and {$form}.{$filterTableName} in (select $filterTableName from {$filterTableName}_user where user = $userId) $selectCriteria";
			}
			elseif ($filterByGridUser > 0) {
				$query = "select max({$form}.id),0,0 from $form";
				$query .= " inner join $gridSource on user.id = {$gridSource}.user where $filterTableName in (select $filterTableName from {$filterTableName}_user where user = $userId) and {$form}.id < {$navId}";
			$query .= $selectCriteria;
			}
			else {
				$query = "select max(id),0,0 from $form where id < $navId $selectCriteria ";
			}

			$superquery .= " union all $query";
		}
		elseif ($navAction == 'next' || $navAction == 'del') {
			if ($filterByUser > 0) {
				$query = "select min({$form}.id),0,0 from $form where {$form}.id > $navId";
				$query .= " and {$form}.{$filterTableName} in (select $filterTableName from {$filterTableName}_user where user = $userId)";
				$query .= " $selectCriteria ";
			}
			elseif ($filterByGridUser > 0) {
				$query = "select min({$form}.id),0,0 from $form";
				$query .= " inner join $gridSource on user.id = {$gridSource}.user where $filterTableName in (select $filterTableName from {$filterTableName}_user where user = $userId) and {$form}.id > $navId";
				$query .= $selectCriteria;
			}
			else {
				$query = "select min(id),0,0 from $form where id > $navId $selectCriteria ";
			}
			$superquery .= " union all $query";
		}
		else {
			$superquery .= " union all select 0,0,0 ";
		}

// get the id position relative to all the other available ids

		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Superquery: $superquery");
		//$_SESSION['debugMsg'] .= logIt($linki, "Superquery: $superquery");
$result = mysqli_query($linki, $superquery) or die(displayErrorPage($linki, $user->userId, mysqli_error($linki) . " [ERR059 - $superquery ] "));

// get the first row from the superquery

$row = mysqli_fetch_row($result);
//echo $superquery; exit;
//echo (mysqli_num_rows($result)); exit;
if (mysqli_num_rows($result) == 0) {
	$this->minId = 0;
	$this->maxId = 0;
	$this->idCount = 0;
}
else {
	$this->minId = $row[0];
	$this->maxId = $row[1];
	$this->idCount = $row[2];
	switch ($navAction) {
	case 'min':
		$this->id = $this->minId; break;
	case 'max':
		$this->id = $this->maxId; break;
	}
	// if the new record validates, it needs to display the new record, or the duplicated one, if desired in settings
	// this means the new record has been inserted, so go to it.
	// if there are errors, we don't want to jump to the max record unless a new record has been inserted.
	if (($navAction == 'save' && $navId == 0) || ($navAction == 'dupl' && DEST_ID_ON_DUPLICATION == 2)) {
		$this->id = $this->maxId;
		$this->newRecord = true;
		//$_SESSION['debugMsg'] .= logIt($linki, "Saving a new record with id of: {$this->id}");
	}

}

// get the second row from the superquery

$row = mysqli_fetch_row($result);

if ($navAction == 'prev') {
	if ($row != null) {
		$this->id = $row[0];
	}
	else {
		$this->id = 0;
	}
}
elseif ($navAction == 'next' || $navAction == 'del') {
	if ($row[0] != null) {
		$this->id = $row[0];
	}
	else {
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "NextId is null, so serving up this->maxId: {$this->maxId}");
		$this->id = $this->maxId;
	}
}
// it's annoying that the following query can't be unioned with the previous two; this is because
// it requires the new id as input after determining the prev, or next
//
		if ($filterByUser > 0) {
			$selectCriteriaForA = str_replace($form, 'A', $selectCriteria);
			$selectCriteriaForAA = str_replace($form, 'AA', $selectCriteria);
			// the alias is required here otherwise a table with a filterByUser condition can never edit itself!
			$query = "select count(AA.id) - (select count(A.id) from $form A inner join {$filterTableName}_user on A.{$filterTableName} = {$filterTableName}_user.{$filterTableName} where A.id > '$this->id' $selectCriteriaForA and {$filterTableName}_user.user = $userId) from $form AA inner join {$filterTableName}_user on AA.{$filterTableName} = {$filterTableName}_user.{$filterTableName} where {$filterTableName}_user.user = $userId $selectCriteriaForAA";
		}
		elseif ($filterByGridUser > 0) {
			$selectCriteriaForA = str_replace($form, 'A', $selectCriteria);
			$selectCriteriaForAA = str_replace($form, 'AA', $selectCriteria);
			$query = "select count(distinct AA.id) - (select count(distinct A.id) from $form A inner join $gridSource on A.id = {$gridSource}.user inner join {$filterTableName}_user on $gridSource.$filterTableName = {$filterTableName}_user.{$filterTableName} where A.id > '$this->id' $selectCriteriaForA and {$filterTableName}_user.user = $userId) from $form AA inner join $gridSource on AA.id = {$gridSource}.user inner join {$filterTableName}_user on $gridSource.$filterTableName = {$filterTableName}_user.{$filterTableName} $selectCriteriaForAA and {$filterTableName}_user.user = $userId"; 
		//$_SESSION['debugMsg'] .= logIt($linki, "Filter by grid user query: " . mysqli_result(mysqli_query($query),0,0));
		}
		else {
			$query = "select count(id) - (select count(id) from $form where id > '$this->id' $selectCriteria),0,0 from $form where 1=1 $selectCriteria";
		}
$result = mysqli_query($linki, $query) or die(displayErrorPage($linki, $user->userId, mysqli_error($linki) . " [ERR089 - $query ] "));
$row = mysqli_fetch_row($result);
$this->idPosition = $row[0];
	 
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "NavId here4: {$this->id}");

			//$_SESSION['debugMsg'] .= logIt($linki, "Min2: " . mysqli_result(mysqli_query($asdf), 0, 0));
			//$_SESSION['debugMsg'] .= logIt($linki, "Max2: " . mysqli_result(mysqli_query($asdf), 0, 1));
			//$_SESSION['debugMsg'] .= logIt($linki, "Count2: " . mysqli_result(mysqli_query($asdf), 0, 2));
			//$_SESSION['debugMsg'] .= logIt($linki, "All: " . mysqli_result(mysqil_query("select concat(min(distinct user.id), '.', max(distinct user.id), '.', count(distinct user.id)) from user inner join user_group on user.id = user_group.user where group_table = 15"),0,0));
	}
}
// }}}

// {{{ function getGridValues
function getGridValues(&$valueArr, &$configXmlDoc, &$elementSet, &$gridCount, &$i, $currentId, $userId, $linki) {

	$gridName = $elementSet->item($i)->getAttribute("name");
	$xpath = new DOMXPath($configXmlDoc);
	$xpQuery = "/doc/form/element[@name='{$gridName}']/field";
	$gridTree = $xpath->query($xpQuery);
	$xpQuery = "/doc/form/element[@name='{$gridName}']/row";
	$rowTree = $xpath->query($xpQuery);
	$criteria = $elementSet->item($i)->getAttribute("selectCriteria");
	if (strlen($elementSet->item($i)->getAttribute("filterColumn")) > 0) {
		$criteria .= " and {$elementSet->item($i)->getAttribute("filterColumn")} = $currentId";
	}
	$limitToNum = $elementSet->item($i)->getAttribute("autoRowNumber") == 0 ? $rowTree->length : $elementSet->item($i)->getAttribute("autoRowNumber");
	$rowCount = 0;
	$colCount = 0;

	//  This query grabs the field names for the grid element, which actually are the
	//  nominated element names of the secondary form (the `many' side of the one-to-many r'ship).
	//  It is then subject to the nominated criteria (if exists), and then limited to a number
	//  which is either the count of the row names (if exists), or the autoRowNumber value

	if ($_POST['navigation'] != 'new|-') {
		// no need to run this query if the record is new, as there should be no associated grid values
		$query = "select id, ";
		for ($j = 0; $j < $gridTree->length; $j++) {
			$query .= " {$gridTree->item($j)->getAttribute("name")}, ";
		}
		$query = substr($query, 0, strlen($query) - 2);
		$query .= " from {$elementSet->item($i)->getAttribute("source")} where deleted != 1 $criteria limit " . $limitToNum;

		$gridResult = mysqli_query($linki, $query) or die(displayErrorPage($linki, $_SESSION['userId' . PABULUMBA_INSTANCE_ID], mysqli_error($linki) . " [ERR035 - $query ] "));

		//  Loop through the result set, obtaining the id, and each value for each row and column intersect
		//  and placing the result into an assoc. array, which looks up the value using `[gridName_rowNumber_colNumber]
		//  The col number `0' always represents the id of the record

		while ($row = mysqli_fetch_row($gridResult)) {

			//$valueArr["{$gridName}_{$rowCount}_0"] = htmlspecialchars_decode(stripslashes($row[0]));
			for ($colCount = 0; $colCount < mysqli_num_fields($gridResult); $colCount++) {
				$lookupValue = "{$gridName}_{$rowCount}_{$colCount}";
				$valueArr[$lookupValue] = htmlspecialchars_decode(stripslashes($row[$colCount]));
			}
			$rowCount++;
		}
	}

	//  The assoc array is also initialised with the potential values of new items (set to empty string)

	if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Grid parameters: $gridName Length: {$gridTree->length}");
	//for ($colCount = 1; $colCount < mysqli_num_fields($gridResult); $colCount++) {
	for ($colCount = 1; $colCount <= $gridTree->length; $colCount++) {
		$lookupValue = "{$gridName}_new_{$colCount}";
		$valueArr[$lookupValue] = '';
	}

	// TODO no need for this line? $valueArr[$elementSet->item($i)->getAttribute("name")] = 'Grid';
	// I don't think this is necesssary now that the grids display correctly in reports

	if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "RowCol: {$rowCount}_{$colCount}");

	$gridCount++;
}
// }}}


//function getDuplicateKeyErrorMsg(&$elementSet, $mysqlErrorMsg, &$s) {
function getDuplicateKeyErrorMsg($mysqlErrorMsg) {
	//echo strlen($mysqlErrorMsg); exit;
	if (substr($mysqlErrorMsg, 0, 15) == 'Duplicate entry') {
		$location = strpos($mysqlErrorMsg, '\' for key');
		$val = substr($mysqlErrorMsg, 17, $location - 17);
		// TODO put this into messages
		return "<msg>\"{$val}\" {$messageArr[18]}</msg>";
		//return "<msg>\"{$val}\" (a value) has been entered in a field which is required to be unique across all records.</msg>";
	}
	elseif (substr($mysqlErrorMsg, 0, 32) == 'Cannot add or update a child row') {
		$fkLocation = strpos($mysqlErrorMsg, 'FOREIGN KEY');
		$refLocation = strpos($mysqlErrorMsg, 'REFERENCES');
		// TODO put this into messages
		return "<msg>{$messageArr[19]} " . substr($mysqlErrorMsg, $fkLocation + 13, ($refLocation - 3) - ($fkLocation + 12)) . "$mysqlErrorMsg</msg>";
		//return "<msg>It's possible an entered value in this form does not match a value in another table as required. Check the value with the field label which appears similar to " . substr($mysqlErrorMsg, $fkLocation + 13, ($refLocation - 3) - ($fkLocation + 12)) . "$mysqlErrorMsg</msg>";
	}
	else {
		// TODO put this into messages
		return "<msg>{$messageArr[20]} {$mysqlErrorMsg}</msg>";
		//return "<msg>An error has occurred while trying to save this record.  Is there an empty drop-down box perhaps? {$mysqlErrorMsg}</msg>";
	}
}

function buildSummaryRow($type, $reportAction, &$noGridCount, &$aggregateFunctions, &$subTotal, &$oldSubTotal, &$countTotal, &$oldCountTotal, &$grandTotal, &$grandTotalCount) {
	$str = '';
	if ($type == 'sub' || $type == 'lastSub') $style = 'bg3'; else $style = 'bg4';
	$str = "\n\t\t\t<tr>";
	if ($reportAction != 'print_all' && $reportAction != 'print_selected') {
		$str .= "\n\t\t\t\t<td style=\"bg0\"></td>\n\t\t\t\t<td style=\"bg0\"></td>";
	}
	for ($j = 0; $j < $noGridCount; $j++) {
		if ($aggregateFunctions[$j] == 's') {
			$str .= "\n\t\t\t<td style=\"$style\">";
			$str .= SUM_PREFIX;
			if ($type == 'sub') $str .= $oldSubTotal[$j];
			elseif ($type == 'lastSub') $str .= $subTotal[$j];
			else $str .= $grandTotal[$j];
			$str .= "</td>";
		}
		elseif ($aggregateFunctions[$j] == 'c') {
			$str .= "\n\t\t\t<td style=\"$style\">";
			$str .= COUNT_PREFIX;
			if ($type == 'sub') $str .= $oldSubTotal[$j];
			elseif ($type == 'lastSub') $str .= $subTotal[$j];
			else $str .= $grandTotal[$j];
			$str .= "</td>";
		}
		elseif ($aggregateFunctions[$j] == 'a') {
			if ($type == 'sub') {
				if ($countTotal[$j] == 0) {
					$tmp = 'n/a';
				}
				else {
					$tmp = round($oldSubTotal[$j] / $oldCountTotal[$j], AVERAGE_ROUND);
				}
			}
			elseif ($type == 'lastSub') {
				if ($countTotal[$j] == 0) {
					$tmp = 'n/a';
				}
				else {
					$tmp = round($subTotal[$j] / $countTotal[$j], AVERAGE_ROUND);
				}
			}
			else {
				if ($grandTotalCount[$j] == 0) {
					$tmp = 'n/a';
				}
				else {
					$tmp = round($grandTotal[$j] / $grandTotalCount[$j], AVERAGE_ROUND);
				}
			}
			$str .= "\n\t\t\t<td style=\"$style\">" . AVERAGE_PREFIX . $tmp . "</td>";
		}
		else $str .= "\n\t\t\t<td style=\"bg0\"></td>";
	}
	$str .= "\n\t\t\t</tr>";
	return $str;
}

function getCalendarVariables() {

	$alterCurrentMonth = 0; // leave at 0 unless testing changing the current month
	$rangeInYears = 10; // this should be a multiple of 2 to get the current month in the middle by default
	$counter = 0;
	$dateArr = array();
	for ($currentMonthOffset = -($rangeInYears * 12); $currentMonthOffset <= ($rangeInYears * 12); $currentMonthOffset++) {
		$firstOfMonth = date('w', mktime(0, 0, 0, date('n') + $currentMonthOffset + $alterCurrentMonth, 1, date('Y')));
		if ($firstOfMonth > 0) $firstOfMonth--;
		else $firstOfMonth = 6;

		$monthNum = date('n', mktime(0, 0, 0, date('n') + $currentMonthOffset + $alterCurrentMonth, 1, date('Y')));
		$daysInMonth = date('t', mktime(0, 0, 0, date('n') + $currentMonthOffset + $alterCurrentMonth, 1, date('Y')));
		$dayNum = date('j') - 1;

		$dateArr[$counter++] = $daysInMonth;
		$dateArr[$counter++] = $firstOfMonth;

		$year = date('Y', mktime(0, 0, 0, date('n'), 1, date('Y')));

	}
	$calVar = '';

		for ($i = 0; $i < $counter; $i++) $calVar .= "$dateArr[$i],"; 
		$calVar .= "-1";
		$calVar .= "|$monthNum";
		$calVar .= "|$year";
		$calVar .= "|$rangeInYears";
		$calVar .= "|$dayNum";
	return $calVar;

}
/*
Test mode, uses test email address
Who does the email go to? 1st param = 'user'
Why does it get POST['mailto']?
emailSendOnSave: 'user', template#, 
*/
function sendEmailOnSave(&$elementSet, $id, $form, &$user, $linki) {

	$tmpArr = explode(',', $_POST['sendEmailOnSave']);
	if (TEST_MODE == 2) {
		$mailTo = TEST_EMAIL_ADDRESS;
	}
	else {
		$mailTo = $tmpArr[0];
		if ($mailTo == 'user' && $form == 'user') {
			$query2 = "select email, full_name from user where id = $id";
		}
		else {
			$query2 = "select email, full_name from user where id = {$_POST[$mailTo]}";
		}
		$result2 = mysqli_query($linki, $query2) or die(displayErrorPage($linki, $user->userId, mysqli_error($linki) . " [ERR084 - $query ] "));
		$tmp = mysqli_fetch_row($result2);
		$mailTo = $tmp[0];
		$mailRecipient = $tmp[1];
	}
	$query2 = "select subject, body from email_template where id = {$tmpArr[1]}";
	$result2 = mysqli_query($linki, $query2) or die(displayErrorPage($linki, $user->userId, mysqli_error($linki) . " [ERR085 - $query ] "));
	$row = mysqli_fetch_row($result2);
	$email_subject = $row[0];
	$email_body = $row[1];
	$matches = array();
	preg_match_all('/({.*?})/', $email_body, $matches);
	$tmp = '';
	for ($i = 0; $i < sizeof($matches[1]); $i++) {
		//$tmp = preg_replace('/{(.*)}/', '\1', $matches[1][$i]);
		$tmp = preg_replace('/{(.*)}/', '\1', $matches[1][$i]);
	//	$_SESSION['debugMsg'] .= logIt($linki, 'matches: ' . $tmp);
	
		$value = '';
		for ($j = 0; $j < $elementSet->length; $j++) {
			// TODO make work for radio and other lookup options
			// TODO make more efficient - rather than going through a loop, use a (hash?) lookup
			if ($elementSet->item($j)->getAttribute("name") == $tmp) {
			       if ($elementSet->item($j)->getAttribute("type") == 'select') {
				if ($mailTo == 'user' && $form == 'user') {
					$query2 = "select {$elementSet->item($j)->getAttribute("display")} from {$elementSet->item($j)->getAttribute("source")} where id = {$id}";
				}
				else {
					$query2 = "select {$elementSet->item($j)->getAttribute("display")} from {$elementSet->item($j)->getAttribute("source")} where id = {$_POST[$tmp]}";
				}
				$result2 = mysqli_query($linki, $query2) or die(displayErrorPage($linki, $user->userId, mysqli_error($linki) . " [ERR086 - $query2 ] "));
				if (mysqli_num_rows($result2) < 1) {
					$value = ' '; //has to be at least 1 char long for check below
				}
				else {
					$row = mysqli_fetch_row($result2);
					$value = $row[0];
				}
				break;
			}
		       //elseif ($elementSet->item($j)->getAttribute("type") == 'input') {
		       //}
			}
		}
		if (strlen($value) == 0) $value = $_POST[$tmp];
		$email_body = str_replace('{' . $tmp . '}',$value,$email_body);
	}

	if (strlen(validate($mailTo, 'email', 'y', '50', 'Label', $messageArr)) > 0) {
		$mailTo = TEST_EMAIL_ADDRESS;
		mail($mailTo, "Unknown/invalid email address for $mailRecipient", $email_body, 'From: ' . FROM_EMAIL_ADDRESS);
	}
	else {
		mail($mailTo, $email_subject, $email_body, 'From: ' . FROM_EMAIL_ADDRESS);
	}
	if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "MAilTo: {$mailTo}");
	
	//$_SESSION['debugMsg'] .= logIt($linki, "MAilTo: {$mailTo}");
}

function getConfigData(&$domDoc, $idx, $num, $linki) {
	if (CONFIG_SOURCE == 3) { 
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'Getting config data from the session');
		$domDoc->loadXML($_SESSION['config']["{$idx}"]);
	}
	elseif (CONFIG_SOURCE == 2) { 
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'Getting config data from the database');
		$query = "select configText from config where id = '{$idx}'";
		$result = mysqli_query($linki, $query);
		$row = mysqli_fetch_row($result);
		$domDoc->loadXML($row[0]);
	}
	else {
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, 'Getting config data from the config files');
		$doc = new DOMDocument();
		if ($idx == 'sysadmin.xml') {
			$dir = 'config';
			if (!($dp = opendir($dir))) die(displayErrorPage("The directory $dir cannot be found."));
			$tmpStr = '';
			while ($xml = readdir($dp)) {
				if ($xml != '.' &&
					$xml != '..' &&
					$xml != 'dummy.xml' &&
					$xml != 'user.xml' &&
					$xml != 'menu.xml' &&
					$xml != 'role.xml' &&
					$xml != 'search.xml' &&
					preg_match('/^.*\.xml$/', $xml)) {

					// load the configuration file
					$xmlDoc = new DOMDocument();
					$xmlDoc->load("{$dir}/{$xml}");
					$table_name = $xmlDoc->getElementsByTagName("form")->item(0)->getAttribute("name");
					if ($table_name != 'dummy') {
						$tmpStr .= '
								<switch navigation="min|-" id="0" xml="' . $table_name . '" xsl="pabulumba" action="display" permission="w" selectCriteria="" processParam1="" aggregateOn="" aggregateFunctions="" orderCriteria="">' . $table_name . ' (form) [' . $xml . ']</switch>';

						$tmpStr .= '
								<switch navigation="min|-" id="0" xml="' . $table_name . '" xsl="pabulumba" action="report" permission="w" selectCriteria="" processParam1="" aggregateOn="" aggregateFunctions="" orderCriteria="">' . $table_name . ' (report)</switch>';
						
					}
				}
			}
			$doc->loadXML('<doc>
				<page title="SysAdmin" permission="w" />
				<menu>
					<menuItem id="0" xml="main" xsl="pabulumba" permission="w">Main</menuItem>
				</menu>
				<successMessages></successMessages>
				<errorMessages></errorMessages>
				<navHistory>
				</navHistory>
				<form name="dummy" showId="n" showNavButtons="n" showSaveButton="n" showNewButton="n" showDeleteButton="n" showDuplicateButton="n" showNavHistoryButton="" showXofXX="n" previewColumns="" sendEmailOnSave="">
					
					<hidden name="action" value="update" />
					<hidden name="xml" value="" />
					<hidden name="xsl" value="pabulumba" />
					<hidden name="selectCriteria" value="" />
					<hidden name="id" value="" />
					<hidden name="idPosition" value="0" />
					<hidden name="idCount" value="0" />;
					<hidden name="minId" value="0" />
					<hidden name="maxId" value="0" /><script>
					</script>
					<script>document.getElementById(\'busy\').style.display = \'none\';</script>
				</form>
				<hypertext>
				</hypertext>
				<switches>' . $tmpStr . '
				</switches>

				<reports>
				</reports>

				<links>
				</links>


				<information>
					<info name="userName">SysAdmin</info>
					<info name="userId">1</info>
				</information>
				<debugMessages>
				</debugMessages>
			</doc>');

			$domDoc = $doc;
		}
		else {
			$domDoc->load("config/{$idx}");// or die(displayErrorPage($linki, $userId, $msg));
		}
	}
}

class Rule {

	public $id;
	public $ruleType;
	public $elementName;
	public $fromValue;
	public $toValue;
	public $reason;
	public $sqlOrRegexp;
	public $sqlText;
	public $sqlText2;
	public $subjectName;
	public $permission;

	function Rule($id, $type, $elementName, $fromValue, $toValue, $reason, $sqlOrRegexp, $sqlText, $sqlText2, $subjectName, $permission) {
		$this->id = $id;
		$this->ruleType = $type;
		$this->elementName = $elementName;
		$this->fromValue = $fromValue;
		$this->toValue = $toValue;
		$this->reason = $reason;
		$this->sqlOrRegexp = $sqlOrRegexp;
		$this->sqlText = $sqlText;
		$this->sqlText2 = $sqlText2;
		$this->subjectName = $subjectName;
		$this->permission = $permission;
	}	

}

class GridInfo {
	public $name;
	public $colCount;
	public $errorCount = 0;
	function GridInfo($n, $c) {
		$this->name = $n;
		$this->colCount = $c;
	}
	function incrErrorCount() {
		$this->errorCount++;
	}
}

class GridStore {
	public $id2Arr = array();
	public $textArr = array();
	public $finalStr;
	public $fieldCount;
 	function GridStore($num) {
		$this->fieldCount = $num;
	}
	function addGridRowId($num) {
		array_push($this->id2Arr, $num);
	}
	function addText($text) {
		array_push($this->textArr, $text);
	}
	function toString() {
		$z = array();
		$finalArr = array();
		$rowCount = $this->fieldCount;
		while ($j = array_pop($this->id2Arr)) {
			if (in_array($j,$z)) {
				array_pop($this->textArr);
			}
			else {
				array_push($z, $j);
				$tmp2 = (($rowCount % $this->fieldCount) == 0) ? '</tr>' : '';
			       	$tmp1 = (($rowCount % $this->fieldCount) == ($this->fieldCount - 1)) ? '<tr>' : '';
				array_push($finalArr, $tmp1 . array_pop($this->textArr) . $tmp2);
			}
			$rowCount++;
		}
		//$count = count($finalArr) . $br;
		$count = count($finalArr);
		$this->finalStr = '';
		for ($i = 0; $i < $count; $i++) {
			$this->finalStr .= array_pop($finalArr);
		}
		return $this->finalStr;
	}
}

function replaceAllNewGridValues(&$gridInfoArr, &$gridCount, &$valueArr, $linki) {
				//$_SESSION['debugMsg'] .= logIt($linki, "Navigation: " . $_POST['navigation']);
	for ($i = 0; $i < $gridCount; $i++) {  
		if ($_SESSION['debug']) $_SESSION['debugMsg'] .= logIt($linki, "Grid:: {$gridInfoArr[$i]->name} eCount: {$gridInfoArr[$i]->errorCount}");
		for ($j = 1; $j <= $gridInfoArr[$i]->colCount; $j++) {  
			if ($gridInfoArr[$i]->errorCount > 0 || $_POST['navigation'] == 'save|0') {
				$valueArr[$gridInfoArr[$i]->name . "_new_{$j}"] = $valueArr["stored_" . $gridInfoArr[$i]->name . "_new_{$j}"];
			}
		}
	}
}

?>

